<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Token;
use GuzzleHttp\Client;
use App\Models\dataPasien;
use App\Models\Antrian;
use App\Models\Registrasi;
//use Illuminate\Support\Facades\Storage;
use Kangyasin\KTPNIKConvert\NikConvert;
use thiagoalessio\TesseractOCR\TesseractOCR;
use Donyahmd\KtpNikParser\NikParser;
use Carbon\Carbon;

class HomeController extends Controller
{
	
	public function ktpValidator()
    {
        /*$url = 'https://indonesia-ktp-parser-validator.p.rapidapi.com/ktp_validator';

        $response = Http::withHeaders([
            'X-RapidAPI-Host' => 'indonesia-ktp-parser-validator.p.rapidapi.com',
            'X-RapidAPI-Key' => 'c102d546c4msh33d1b98d140d0ebp170658jsnb500927f9cf0',
            'Content-Type' => 'application/json',
        ])->post($url, [
            'nik' => '3578101601900002', // Your NIK value
        ]);

        // Get the response body
        return $response->json();

        // You can process or display the result as needed
        //echo $result;*/
		
		//yasin//
		/*$nik = '3578101601900002'; // Ganti dengan NIK yang ingin Anda konversi

        $nikConvert = new NikConvert();
        $result = $nikConvert->convert($nik);

        // Anda dapat memproses atau menampilkan hasil sesuai kebutuhan
        return response()->json($result);*/
		
		$nik = '3578101601900002';
		$nikParser = new NikParser();
		$parsedData = $nikParser->parse($nik);

		// The $parsedData array will contain information like gender, birth date, and region.
		return $parsedData;
		
    }
	
	public function checkNIN(Request $request)
    {
        //$nik = '3516016309000001'; // NIN yang diberikan (gantilah dengan input yang sesuai)
		$nik = $request->nomer_identitas;

        //$nik = $request->input('nik');

        $provinceCode = substr($nik, 0, 2);
        $regencyCode = substr($nik, 2, 2);
        $districtCode = substr($nik, 4, 2);
        $birthdate = substr($nik, 6, 6); // Format: YYMMDD
		$birthYear = substr($nik, 10, 2);
		$fullYear = (int)$birthYear + 2000;
        $sequenceNumber = substr($nik, 12, 4);
		
		
        //$province = Province::where('code', $provinceCode)->first();
		$province = DB::table('m_provinsi')->where('code', '=', $provinceCode)->first();
		$regency = DB::table('m_kabupaten')->where('code', '=', $regencyCode)->first();
		$district = DB::table('m_kecamatan')->where('code', '=', $districtCode)->first();
        //$regency = Regency::where('code', $regencyCode)->first();
        //$district = District::where('code', $districtCode)->first();
		$gender = (int)substr($nik, 6, 2) > 40 ? 'Perempuan' : 'Laki-laki';
		//$day = substr($nik, 6, 2);
		if(substr($nik, 6, 2)>40){
			$day = substr($nik, 6, 2)-40;
		}else {
			$day = substr($nik, 6, 2);
		}
		$month = substr($nik, 8, 2);
		$year = '19' . substr($nik, 10, 2); // Anggap tahun selalu dimulai dengan 19
		
		if ($fullYear > date('Y')) {
			$formattedYear = '19' . $birthYear;
		} else {
			$formattedYear = '20' . $birthYear;
		}
		
		$tanggallahir = $formattedYear.'-'.$month.'-'.$day;
		$age = Carbon::parse($tanggallahir)->age;

        return [
            'province' => $province->provinsi,
            'regency' => $regency->kabupaten,
            'district' => $district->kecamatan,
			'kode_provinsi' => $province->code,
            'kode_kota' => $regency->code,
            'kode_kecamatan' => $district->code,
            //'birth_date' => $birthDate,
			'birthdate' => "$formattedYear-$month-$day", // Format: DD-MM-YYYY
            'sequence_number' => $sequenceNumber,
			'gender' => $gender,
			'umur' => $age,
			'tanggallahir' => $tanggallahir,
        ];
		
    }
    

   
	
	public function scanKtp(Request $request)
    {
        $this->validate($request, [
            'ktp_image' => 'required|image'
        ]);

        $path = $request->file('ktp_image.jpg')->store('ktp_images.jpg');
        $imagePath = storage_path('app/' . $path);

        $ocr = new TesseractOCR($imagePath);
        $ocr->lang('ind'); // Pastikan Anda telah menginstal dukungan bahasa Indonesia untuk Tesseract
        $text = $ocr->run();

        // Proses teks yang diekstrak sesuai kebutuhan Anda
        // ...

        return response()->json([
            'message' => 'Scan KTP berhasil.',
            'data' => $text,
            'image_path' => $imagePath // Menambahkan path image untuk referensi
        ]);
    }

	
   public function getToken() {
	try {
		$response = Http::asForm()->post('https://api-satusehat-stg.dto.kemkes.go.id/oauth2/v1/accesstoken?grant_type=client_credentials', [
			'client_id' => 'NHnpXzJM6IbUADRYRwfulEuhs2AGqrXWtwe3P1MZgATlQ7jv',
			'client_secret' => 'GdZ3zGu0bMLQUgDlInSOLjlcHxVsNQmSuN8LxrozM8qjAZeHbwweyeszN3X1iLOA',
			//Storage::disk('local')->put('example.txt', 'Contents');
		]);
		//return $response->json(); 
		$responseData = $response->json();
		$token = DB::table('token')
				->where('id_token', 1)
				->update(['token' => $responseData['access_token']]);
		//$token->token = $responseData['access_token']; // Adjust field names as needed
				
		//return $token; // You can return the saved object if needed
		$response_data = json_decode($response, true);
		$resource_id = $response_data['access_token'];
		if ($token) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $resource_id
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		} catch (\Exception $e) {
			// Handle any exceptions (e.g., 400 Bad Request)
			return response()->json(['error' => $e->getMessage()], 500);
		}
	}

   
	public function getPractitioner() {
		$getToken = DB::table('token')
			->where('id_token', '=', 1)
			->get();
		foreach ($getToken as $key => $ch){
			$token = $ch->token;
			$response = Http::withToken($token)->get('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Practitioner', [
			'identifier' => 'https://fhir.kemkes.go.id/id/nik|7209061211900001',
			]);
		}
		
	return $response->json(); 
	}
	
	public function updateToken(Request $request) {
			DB::begintransaction();
			try {
				$token = Token::find($request->id_token);
				$token->token = $request->token;
				if (!$token->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data token'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'token' => $token->token,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function storeOrganisation() {
		$getToken = DB::table('token')
			->where('id_token', '=', 1)
			->get();
				$response =Http::withToken('An7WI4iZCZAixJAMx7Hpi8ofRhv0')->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Organization', [
				'resourceType' => 'Organization',
				  'active' => true,
				  'identifier' => [
					[
					  'use' => 'official',
					'system' => 'http://sys-ids.kemkes.go.id/organization/24027125-68be-4154-a573-79d6571679d5',
					'value' => 'R220001',
					]
				  ],
				  'type' => [
					[
					  'coding' => [
						[
						  'system' => 'http://terminology.hl7.org/CodeSystem/organization-type',
								'code' => 'dept',
								'display' => 'Hospital Department',
						]
					  ]
					]
				  ],
				  'name' => 'Praktek dokter THT',
				  'telecom' => [
					[
					  'system' => 'phone',
					  'value' => '+62852-1000-1747',
					  'use' => 'work'
					],
					[
					  'system' => 'email',
					  'value' => 'praktekdoktertht@gmail.com',
					  'use' => 'work'
					],
					[
					  'system' => 'url',
					  'value' => 'https://dokterspesialistht.com',
					  'use' => 'work'
					]
				  ],
				  'address'=> [
					[
					  'use' => 'work',
					  'type' => 'both',
					  'line' => [
						'Jl. Gersikan Gg. Buntu No.9 E'
					  ],
					  'city' => 'Surabaya',
					  'postalCode' => '60131',
					  'country' => 'ID',
					  'extension' => [
						[
						  'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
						  'extension'=> [
							[
							  'url' => 'province',
							  'valueCode' => '35'
							],
							[
							  'url' => 'city',
							  'valueCode' => '3578'
							],
							[
							  'url' => 'district',
							  'valueCode'=> '357810'
							],
							[
							  'url' => 'village',
							  'valueCode' => '3578101006'
							]
						  ]
						]
					  ]
					]
				  ],
				  'partOf'=> [
					'reference' => 'Organization/24027125-68be-4154-a573-79d6571679d5'
				  ]
			]);
		return $response->json(); 
	}
	
	public function storeLocation() {
		$getToken = DB::table('token')
			->where('id_token', '=', 1)
			->get();
				$response =Http::withToken('An7WI4iZCZAixJAMx7Hpi8ofRhv0')->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Location', [
				'resourceType'=> 'Location',
				'identifier'=> [
					[
						'system'=> 'http://sys-ids.kemkes.go.id/location/24027125-68be-4154-a573-79d6571679d5',
						'value'=> 'G-2-R-1A'
					]
				],
				'status'=> 'active',
				'name'=> 'Ruang 1A',
				'description'=> 'Ruang 1A, Poliklinik THT, Lantai 1',
				'mode'=> 'instance',
				'telecom'=> [
					[
						'system'=> 'phone',
						'value'=> '0852-1000-1747',
						'use'=> 'work'
					],
					[
						'system'=> 'fax',
						'value'=> '2329',
						'use'=> 'work'
					],
					[
						'system'=> 'email',
						'value'=> 'praktekdoktertht@gmail'
					],
					[
						'system'=> 'url',
						'value'=> 'https://dokterspesialistht.com',
						'use'=> 'work'
					]
				],
				'address'=> [
					'use'=> 'work',
					'line'=> [
						'Jl. Gersikan Gg. Buntu No.9 E, Pacar Keling, Kec. Tambaksari, Surabaya,'
					],
					'city'=> 'Jakarta',
					'postalCode'=> '12950',
					'country'=> 'ID',
					'extension'=> [
						[
							'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
							'extension'=> [
								[
									'url'=> 'province',
									'valueCode'=> '35'
								],
								[
									'url'=> 'city',
									'valueCode'=> '3578'
								],
								[
									'url'=> 'district',
									'valueCode'=> '357810'
								],
								[
									'url'=> 'village',
									'valueCode'=> '3578101006'
								],
								[
									'url'=> 'rt',
									'valueCode'=> '1'
								],
								[
									'url'=> 'rw',
									'valueCode'=> '2'
								]
							]
						]
					]
				],
				'physicalType'=> [
					'coding'=> [
						[
							'system'=> 'http://terminology.hl7.org/CodeSystem/location-physical-type',
							'code'=> 'ro',
							'display'=> 'Room'
						]
					]
				],
				'position'=> [
					'longitude'=> -7.2574864,
					'latitude'=> 112.7612492,
					'altitude'=> 17
				],
				'managingOrganization'=> [
					'reference'=> 'Organization/24027125-68be-4154-a573-79d6571679d5'
				]
			]);
		return $response->json(); 
	}
	
	public function createPasien() {
		$response =Http::withToken('gsPYxVx7dWBvu3KFpUOltC6bzaSG')->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Patient', [
				'resourceType'=> 'Patient',
			    'meta'=> [
				  'profile'=> [
					 'https://fhir.kemkes.go.id/r4/StructureDefinition/Patient'
				  ]
			   ],
			   'identifier'=> [
				  [
					 'use'=> 'official',
					 'system'=> 'https://fhir.kemkes.go.id/id/nik',
					 //'value'=> $request->nomer_identitas,
					 'value'=> '3578101804810003'
				  ]
			   ],
			   'active'=> true,
			   'name'=> [
				  [
					 'use'=> 'official',
					 //'text'=> $request->nama_pasien,
					 'text'=> 'sutaji'
				  ]
			   ],
			   'telecom'=> [
				  [
					 'system'=> 'phone',
					 'value'=> '08123456789',
					 'use'=> 'mobile'
				  ],
				  [
					 'system'=> 'phone',
					 'value'=> '+622123456789',
					 'use'=> 'home'
				  ],
				  [
					 'system'=> 'email',
					 'value'=> 'john.smith@xyz.com',
					 'use'=> 'home'
				  ]
			   ],
			   'gender'=> 'female',
			   'birthDate'=> '1945-11-17',
			   'deceasedBoolean'=> false,
			   'address'=> [
				  [
					 'use'=> 'home',
					 'line'=> [
						'Gd. Prof. Dr. Sujudi Lt.5, Jl. H.R. Rasuna Said Blok X5 Kav. 4-9 Kuningan'
					 ],
					 'city'=> 'Jakarta',
					 'postalCode'=> '12950',
					 'country'=> 'ID',
					 'extension'=> [
						[
						   'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
						   'extension'=> [
							  [
								 'url'=> 'province',
								 'valueCode'=> '10'
							  ],
							  [
								 'url'=> 'city',
								 'valueCode'=> '1010'
							  ],
							  [
								 'url'=> 'district',
								 'valueCode'=> '1010101'
							  ],
							  [
								 'url'=> 'village',
								 'valueCode'=> '1010101101'
							  ],
							  [
								 'url'=> 'rt',
								 'valueCode'=> '2'
							  ],
							  [
								 'url'=> 'rw',
								 'valueCode'=> '2'
							  ]
						   ]
						]
					 ]
				  ]
			   ],
			   'maritalStatus'=> [
				  'coding'=> [
					 [
						'system'=> 'http://terminology.hl7.org/CodeSystem/v3-MaritalStatus',
						'code'=> 'M',
						'display'=> 'Married'
					 ]
				  ],
				  'text'=> 'Married'
			   ],
			   'multipleBirthInteger'=> 0,
			   'contact'=> [
				  [
					 'relationship'=> [
						[
						   'coding'=> [
							  [
								 'system'=> 'http://terminology.hl7.org/CodeSystem/v2-0131',
								 'code'=> 'C'
							  ]
						   ]
						]
					 ],
					 'name'=> [
						'use'=> 'official',
						'text'=> 'Jane Smith'
					 ],
					 'telecom'=> [
						[
						   'system'=> 'phone',
						   'value'=> '0690383372',
						   'use'=> 'mobile'
						]
					 ]
				  ]
			   ],
			   'communication'=> [
				  [
					 'language'=> [
						'coding'=> [
						   [
							  'system'=> 'urn=>ietf=>bcp=>47',
							  'code'=> 'id-ID',
							  'display'=> 'Indonesian'
						   ]
						],
						'text'=> 'Indonesian'
					 ],
					 'preferred'=> true
				  ]
			   ],
			   'extension'=> [
				  [
					 'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/birthPlace',
					 'valueAddress'=> [
						'city'=> 'Bandung',
						'country'=> 'ID'
					 ]
				  ],
				  [
					 'url'=> 'https=>//fhir.kemkes.go.id/r4/StructureDefinition/citizenshipStatus',
					 'valueCode'=> 'WNI'
				  ]
			   ]
			]);
		return $response->json(); 
	}
	
	public function encounter() {
		$response =Http::withToken('gsPYxVx7dWBvu3KFpUOltC6bzaSG')->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Encounter', [
				'resourceType'=>'Encounter',
				'identifier'=>[
					[
						'system'=>'http://sys-ids.kemkes.go.id/encounter/24027125-68be-4154-a573-79d6571679d5',
						'value'=>'P02029497401'
					]
				],
				'status'=>'arrived',
				'class'=>[
					'system'=>'http://terminology.hl7.org/CodeSystem/v3-ActCode',
					'code'=>'AMB',
					'display'=>'ambulatory'
				],
				'subject'=>[
					'reference'=>'Patient/P02029497401',
					'display'=>'Budi Santoso'
				],
				'participant'=>[
					[
						'type'=>[
							[
								'coding'=>[
									[
										'system'=>'http://terminology.hl7.org/CodeSystem/v3-ParticipationType',
										'code'=>'ATND',
										'display'=>'attender'
									]
								]
							]
						],
						'individual'=>[
							'reference'=>'Practitioner/N10000001',
							'display'=>'Dokter Bronsig'
						]
					]
				],
				'period'=>[
					'start'=>'2022-06-14T07:00:00+07:00'
				],
				'location'=>[
					[
						'location'=>[
							'reference'=>'Location/ef011065-38c9-46f8-9c35-d1fe68966a3e',
							'display'=>'Ruang 1A, Poliklinik Rawat Jalan'
						],
						'extension'=>[
							[
								'url'=>'https://fhir.kemkes.go.id/r4/StructureDefinition/ServiceClass',
								'extension'=>[
									[
										'url'=>'value',
										'valueCodeableConcept'=>[
											'coding'=>[
												[
													'system'=>'http://terminology.kemkes.go.id/CodeSystem/locationServiceClass-Outpatient',
													'code'=>'reguler',
													'display'=>'Kelas Reguler'
												]
											]
										]
									]
								]
							]
						]
					]
				],
				'statusHistory'=>[
					[
						'status'=>'arrived',
						'period'=>[
							'start'=>'2022-06-14T07:00:00+07:00'
						]
					]
				],
				'serviceProvider'=>[
					'reference'=>'Organization/24027125-68be-4154-a573-79d6571679d5'
				]
			]);
		return $response->json(); 
	}
	
	public function condition() {
		$response =Http::withToken('uMQz42mT9hAgLCWvAPaqgSlAkluv')->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Condition', [
		   'resourceType'=> 'Condition',
		   'clinicalStatus'=> [
			  'coding'=> [
				 [
					'system'=> 'http=>//terminology.hl7.org/CodeSystem/condition-clinical',
					'code'=> 'active',
					'display'=> 'Active'
				 ]
			  ]
		   ],
		   'category'=> [
			  [
				 'coding'=> [
					[
					   'system'=> 'http=>//terminology.hl7.org/CodeSystem/condition-category',
					   'code'=> 'encounter-diagnosis',
					   'display'=> 'Encounter Diagnosis'
					]
				 ]
			  ]
		   ],
		   'code'=> [
			  'coding'=> [
				 [
					'system'=> 'http=>//hl7.org/fhir/sid/icd-10',
					'code'=> 'K35.8',
					'display'=> 'Acute appendicitis, other and unspecified'
				 ]
			  ]
		   ],
		   'subject'=> [
			  'reference'=> 'Patient/P02029497230',
			  'display'=> 'Budi Santoso'
		   ],
		   'encounter'=> [
			  'reference'=> 'Encounter/815bfc4f-72a7-4e0b-9a14-643280824d0e',
			  'display'=> 'Kunjungan Budi Santoso di hari Selasa, 14 Juni 2022'
		   ]
		]);
		return $response->json(); 
	}
	
	public function storePatientByNik(Request $request) {
	try {
		$getToken = DB::table('token')
			->where('id_token', '=', 1)
			->get();
			foreach ($getToken as $key => $ch){
				$token = $ch->token;
				$response =Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Patient', [
				'resourceType'=> 'Patient',
			    'meta'=> [
				  'profile'=> [
					 'https://fhir.kemkes.go.id/r4/StructureDefinition/Patient'
				  ]
			   ],
			   'identifier'=> [
				  [
					 'use'=> 'official',
					 'system'=> 'https://fhir.kemkes.go.id/id/nik',
					 //'value'=> $request->nomer_identitas,
					 'value'=> '3578101601900002'
				  ]
			   ],
			   'active'=> true,
			   'name'=> [
				  [
					 'use'=> 'official',
					 //'text'=> $request->nama_pasien,
					 'text'=> 'sutaji'
				  ]
			   ],
			   'telecom'=> [
				  [
					 'system'=> 'phone',
					 'value'=> '08123456789',
					 'use'=> 'mobile'
				  ],
				  [
					 'system'=> 'phone',
					 'value'=> '+622123456789',
					 'use'=> 'home'
				  ],
				  [
					 'system'=> 'email',
					 'value'=> 'john.smith@xyz.com',
					 'use'=> 'home'
				  ]
			   ],
			   'gender'=> 'female',
			   'birthDate'=> '1945-11-17',
			   'deceasedBoolean'=> false,
			   'address'=> [
				  [
					 'use'=> 'home',
					 'line'=> [
						'Gd. Prof. Dr. Sujudi Lt.5, Jl. H.R. Rasuna Said Blok X5 Kav. 4-9 Kuningan'
					 ],
					 'city'=> 'Jakarta',
					 'postalCode'=> '12950',
					 'country'=> 'ID',
					 'extension'=> [
						[
						   'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
						   'extension'=> [
							  [
								 'url'=> 'province',
								 'valueCode'=> '10'
							  ],
							  [
								 'url'=> 'city',
								 'valueCode'=> '1010'
							  ],
							  [
								 'url'=> 'district',
								 'valueCode'=> '1010101'
							  ],
							  [
								 'url'=> 'village',
								 'valueCode'=> '1010101101'
							  ],
							  [
								 'url'=> 'rt',
								 'valueCode'=> '2'
							  ],
							  [
								 'url'=> 'rw',
								 'valueCode'=> '2'
							  ]
						   ]
						]
					 ]
				  ]
			   ],
			   'maritalStatus'=> [
				  'coding'=> [
					 [
						'system'=> 'http://terminology.hl7.org/CodeSystem/v3-MaritalStatus',
						'code'=> 'M',
						'display'=> 'Married'
					 ]
				  ],
				  'text'=> 'Married'
			   ],
			   'multipleBirthInteger'=> 0,
			   'contact'=> [
				  [
					 'relationship'=> [
						[
						   'coding'=> [
							  [
								 'system'=> 'http://terminology.hl7.org/CodeSystem/v2-0131',
								 'code'=> 'C'
							  ]
						   ]
						]
					 ],
					 'name'=> [
						'use'=> 'official',
						'text'=> 'Jane Smith'
					 ],
					 'telecom'=> [
						[
						   'system'=> 'phone',
						   'value'=> '0690383372',
						   'use'=> 'mobile'
						]
					 ]
				  ]
			   ],
			   'communication'=> [
				  [
					 'language'=> [
						'coding'=> [
						   [
							  'system'=> 'urn=>ietf=>bcp=>47',
							  'code'=> 'id-ID',
							  'display'=> 'Indonesian'
						   ]
						],
						'text'=> 'Indonesian'
					 ],
					 'preferred'=> true
				  ]
			   ],
			   'extension'=> [
				  [
					 'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/birthPlace',
					 'valueAddress'=> [
						'city'=> 'Bandung',
						'country'=> 'ID'
					 ]
				  ],
				  [
					 'url'=> 'https=>//fhir.kemkes.go.id/r4/StructureDefinition/citizenshipStatus',
					 'valueCode'=> 'WNI'
				  ]
			   ]
			]);
			
		
		$response_data = json_decode($response, true);
		$status = $response_data['success'];
		if ($status == "true"){
			$resource_id = $response_data['data']['patient_id'];
			$data_pasien = new dataPasien;
			$data_pasien->satusehat_number = $resource_id;
			$data_pasien->nama_pasien = $request->nama_pasien;
			$data_pasien->no_telp = $request->no_telp;
			$data_pasien->email = $request->email;
			$data_pasien->jenis_kelamin = $request->gender;
			$data_pasien->tanggal_lahir = $request->tanggal_lahir_form;
			$data_pasien->alamat_ktp = $request->alamat_ktp;
			$data_pasien->nama_penjamin = $request->nama_penjamin;
			$data_pasien->nomer_penjamin = $request->nomer_penjamin;
			$data_pasien->tempat_lahir = "surabaya";	
			$data_pasien->kode_pos = $request->kode_pos;
			$data_pasien->provinsi = $request->provinsi;
			$data_pasien->kota = $request->kota;	
			$data_pasien->kecamatan = $request->kecamatans;
			$data_pasien->rw = $request->rw;
			$data_pasien->rt = $request->rt;	
			$data_pasien->kartu_identitas = $request->kartu_identitas;
			$data_pasien->nomer_identitas = $request->nomer_identitas;	
			//$data_pasien->save();
			if (!$data_pasien->save()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan data Registrasi'
				];
			}
		}else{
			$resource_id = $response_data['data']['resourceID'];
			$data_pasien = new dataPasien;
			$data_pasien->satusehat_number = $resource_id;
			$data_pasien->nama_pasien = $request->nama_pasien;
			$data_pasien->no_telp = $request->no_telp;
			$data_pasien->email = $request->email;
			$data_pasien->jenis_kelamin = $request->gender;
			$data_pasien->tanggal_lahir = $request->tanggal_lahir_form;
			$data_pasien->alamat_ktp = $request->alamat_ktp;
			$data_pasien->nama_penjamin = $request->nama_penjamin;
			$data_pasien->nomer_penjamin = $request->nomer_penjamin;
			$data_pasien->tempat_lahir = "surabaya";	
			$data_pasien->kode_pos = $request->kode_pos;
			$data_pasien->provinsi = $request->provinsi;
			$data_pasien->kota = $request->kota;	
			$data_pasien->kecamatan = $request->kecamatans;
			$data_pasien->rw = $request->rw;
			$data_pasien->rt = $request->rt;	
			$data_pasien->kartu_identitas = $request->kartu_identitas;
			$data_pasien->nomer_identitas = $request->nomer_identitas;
			//$data_pasien->save();
			if (!$data_pasien->save()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan data Registrasi'
				];
			}
		}
		
		$dateNow = Carbon::now();
		
		//////ENCOUNTER/////////
		$encounter = Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Encounter', [
			'resourceType'=>'Encounter',
			'identifier'=>[
				[
					'system'=>'http://sys-ids.kemkes.go.id/encounter/24027125-68be-4154-a573-79d6571679d5',
					'value'=>$resource_id
				]
			],
			'status'=>'arrived',
			'class'=>[
				'system'=>'http://terminology.hl7.org/CodeSystem/v3-ActCode',
				'code'=>'AMB',
				'display'=>'ambulatory'
			],
			'subject'=>[
				'reference'=>'Patient/'.$resource_id,
				'display'=>'Budi Santoso'
			],
			'participant'=>[
				[
					'type'=>[
						[
							'coding'=>[
								[
									'system'=>'http://terminology.hl7.org/CodeSystem/v3-ParticipationType',
									'code'=>'ATND',
									'display'=>'attender'
								]
							]
						]
					],
					'individual'=>[
						'reference'=>'Practitioner/N10000001',
						'display'=>'Dokter Bronsig'
					]
				]
			],
			'period'=>[
				'start'=>$dateNow
				//'start'=>$dateNow'T01:00:00+00:00'
			],
			'location'=>[
				[
					'location'=>[
						'reference'=>'Location/ef011065-38c9-46f8-9c35-d1fe68966a3e',
						'display'=>'Ruang 1A, Poliklinik Rawat Jalan'
					],
					'extension'=>[
						[
							'url'=>'https://fhir.kemkes.go.id/r4/StructureDefinition/ServiceClass',
							'extension'=>[
								[
									'url'=>'value',
									'valueCodeableConcept'=>[
										'coding'=>[
											[
												'system'=>'http://terminology.kemkes.go.id/CodeSystem/locationServiceClass-Outpatient',
												'code'=>'reguler',
												'display'=>'Kelas Reguler'
											]
										]
									]
								]
							]
						]
					]
				]
			],
			'statusHistory'=>[
				[
					'status'=>'arrived',
					'period'=>[
						'start'=>$dateNow
						//'start'=>$dateNow'T01:00:00+00:00'
					]
				]
			],
			'serviceProvider'=>[
				'reference'=>'Organization/24027125-68be-4154-a573-79d6571679d5'
			]
		]);
		$encounter_data = json_decode($encounter, true);
		$encounter_id = $encounter_data['id'];
		$countAntrian = DB::table('data_antrian')
		->where('id_jadwal', '=', $request->id_jadwal)
		->max('no_antrian');
		$generateAntrian = $countAntrian+1 ;
		$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
		$countPx = DB::table('data_pasien')
		->max('id_pasien');
		$generateidpx = $countPx ;
		$antrian = new Antrian;
		$antrian->id_encounter = $encounter_id;
		$antrian->id_jadwal = $request->id_jadwal;
		$antrian->id_pasien = $generateidpx;
		$antrian->keluhan_awal = "demam";
		$antrian->no_antrian = $nomerAntrian;
		//$antrian->save();
		if (!$antrian->save()) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => 'Gagal menyimpan data Registrasi'
			];
		}
		
		//RFID//
		/*$cekRfid = DB::table('m_rfid')
		->where('rfid', '=', $request->rf_id)
		->select('rfid')
		->count();
		if ($cekRfid == 1){
			$rfid = Rfid::find($request->rf_id);
			$rfid->status = "aktif";
			$rfid->save();
		}else{
			$msg = "Rfid belum terdaftar"
		}
		*/
		
		}//end foreach//
		
		//return $resource_id; 
		$postKirim = array(
		"data" => $response
		);
		if ($response) {
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
			'token' => $token,
			'id_ss_number' => $resource_id,
			'antrian' => $nomerAntrian,
			'id_encounter' => $encounter_data,
			'encounter_id' => $encounter_id,
			'date now' => $dateNow,
			//'status' => $status,
			//'rfid validator' => $msg,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
		
		} catch (\Exception $e) {
			// Handle any exceptions (e.g., 400 Bad Request)
			return response()->json(['error' => $e->getMessage()], 500);
		}
	}
	
	public function storePatientByNikTest(Request $request) {
	try {
		$getToken = DB::table('token')
			->where('id_token', '=', 1)
			->get();
			foreach ($getToken as $key => $ch){
				$token = $ch->token;
				$response =Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Patient', [
				'resourceType'=> 'Patient',
			    'meta'=> [
				  'profile'=> [
					 'https://fhir.kemkes.go.id/r4/StructureDefinition/Patient'
				  ]
			   ],
			   'identifier'=> [
				  [
					 'use'=> 'official',
					 'system'=> 'https://fhir.kemkes.go.id/id/nik',
					 'value'=> $request->nomer_identitas
				  ]
			   ],
			   'active'=> true,
			   'name'=> [
				  [
					 'use'=> 'official',
					 'text'=> $request->nama_pasien
				  ]
			   ],
			   'telecom'=> [
				  [
					 'system'=> 'phone',
					 'value'=> $request->no_telp,
					 'use'=> 'mobile'
				  ],
				  [
					 'system'=> 'phone',
					 'value'=> '+622123456789',
					 'use'=> 'home'
				  ],
				  [
					 'system'=> 'email',
					 'value'=> $request->email,
					 'use'=> 'home'
				  ]
			   ],
			   'gender'=> $request->gender,
			   'birthDate'=> $request->tanggal_lahir_form,
			   'deceasedBoolean'=> false,
			   'address'=> [
				  [
					 'use'=> 'home',
					 'line'=> [
						$request->alamat_ktp
					 ],
					 'city'=> $request->kota,
					 'postalCode'=> $request->kode_pos,
					 'country'=> 'ID',
					 'extension'=> [
						[
						   'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
						   'extension'=> [
							  [
								 'url'=> 'province',
								 'valueCode'=> $request->kode_provinsi
							  ],
							  [
								 'url'=> 'city',
								 'valueCode'=> $request->kode_kota
							  ],
							  [
								 'url'=> 'district',
								 'valueCode'=> $request->kode_kecamatan
							  ],
							  [
								 'url'=> 'village',
								 'valueCode'=> '1010101101'
							  ],
							  [
								 'url'=> 'rt',
								 'valueCode'=> $request->rt
							  ],
							  [
								 'url'=> 'rw',
								 'valueCode'=> $request->rw
							  ]
						   ]
						]
					 ]
				  ]
			   ],
			   'maritalStatus'=> [
				  'coding'=> [
					 [
						'system'=> 'http://terminology.hl7.org/CodeSystem/v3-MaritalStatus',
						'code'=> 'M',
						'display'=> 'Married'
					 ]
				  ],
				  'text'=> 'Married'
			   ],
			   'multipleBirthInteger'=> 0,
			   'contact'=> [
				  [
					 'relationship'=> [
						[
						   'coding'=> [
							  [
								 'system'=> 'http://terminology.hl7.org/CodeSystem/v2-0131',
								 'code'=> 'C'
							  ]
						   ]
						]
					 ],
					 'name'=> [
						'use'=> 'official',
						'text'=> $request->nama_penjamin
					 ],
					 'telecom'=> [
						[
						   'system'=> 'phone',
						   'value'=> $request->nomer_penjamin,
						   'use'=> 'mobile'
						]
					 ]
				  ]
			   ],
			   'communication'=> [
				  [
					 'language'=> [
						'coding'=> [
						   [
							  'system'=> 'urn=>ietf=>bcp=>47',
							  'code'=> 'id-ID',
							  'display'=> 'Indonesian'
						   ]
						],
						'text'=> 'Indonesian'
					 ],
					 'preferred'=> true
				  ]
			   ],
			   'extension'=> [
				  [
					 'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/birthPlace',
					 'valueAddress'=> [
						'city'=> $request->kota,
						'country'=> 'ID'
					 ]
				  ],
				  [
					 'url'=> 'https=>//fhir.kemkes.go.id/r4/StructureDefinition/citizenshipStatus',
					 'valueCode'=> 'WNI'
				  ]
			   ]
			]);
			
		
		$response_data = json_decode($response, true);
		$status = $response_data['success'];
		if ($status == "true"){
			$resource_id = $response_data['data']['patient_id'];
			$data_pasien = new dataPasien;
			$data_pasien->satusehat_number = $resource_id;
			$data_pasien->nama_pasien = $request->nama_pasien;
			$data_pasien->no_telp = $request->no_telp;
			$data_pasien->email = $request->email;
			$data_pasien->jenis_kelamin = $request->gender;
			$data_pasien->tanggal_lahir = $request->tanggal_lahir_form;
			$data_pasien->alamat_ktp = $request->alamat_ktp;
			$data_pasien->nama_penjamin = $request->nama_penjamin;
			$data_pasien->nomer_penjamin = $request->nomer_penjamin;
			$data_pasien->tempat_lahir = $request->kota;	
			$data_pasien->kode_pos = $request->kode_pos;
			$data_pasien->provinsi = $request->provinsi;
			$data_pasien->kota = $request->kota;	
			$data_pasien->kecamatan = $request->kecamatans;
			$data_pasien->rw = $request->rw;
			$data_pasien->rt = $request->rt;	
			$data_pasien->kartu_identitas = $request->kartu_identitas;
			$data_pasien->nomer_identitas = $request->nomer_identitas;	
			//$data_pasien->save();
			if (!$data_pasien->save()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan data Registrasi'
				];
			}
		}else{
			$resource_id = $response_data['data']['resourceID'];
			$data_pasien = new dataPasien;
			$data_pasien->satusehat_number = $resource_id;
			$data_pasien->nama_pasien = $request->nama_pasien;
			$data_pasien->no_telp = $request->no_telp;
			$data_pasien->email = $request->email;
			$data_pasien->jenis_kelamin = $request->gender;
			$data_pasien->tanggal_lahir = $request->tanggal_lahir_form;
			$data_pasien->alamat_ktp = $request->alamat_ktp;
			$data_pasien->nama_penjamin = $request->nama_penjamin;
			$data_pasien->nomer_penjamin = $request->nomer_penjamin;
			$data_pasien->tempat_lahir = $request->kota;	
			$data_pasien->kode_pos = $request->kode_pos;
			$data_pasien->provinsi = $request->provinsi;
			$data_pasien->kota = $request->kota;	
			$data_pasien->kecamatan = $request->kecamatans;
			$data_pasien->rw = $request->rw;
			$data_pasien->rt = $request->rt;	
			$data_pasien->kartu_identitas = $request->kartu_identitas;
			$data_pasien->nomer_identitas = $request->nomer_identitas;
			//$data_pasien->save();
			if (!$data_pasien->save()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan data Registrasi'
				];
			}
		}
		
		$dateNow = Carbon::now();
		
		//////ENCOUNTER/////////
		$encounter = Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Encounter', [
			'resourceType'=>'Encounter',
			'identifier'=>[
				[
					'system'=>'http://sys-ids.kemkes.go.id/encounter/24027125-68be-4154-a573-79d6571679d5',
					'value'=>$resource_id
				]
			],
			'status'=>'arrived',
			'class'=>[
				'system'=>'http://terminology.hl7.org/CodeSystem/v3-ActCode',
				'code'=>'AMB',
				'display'=>'ambulatory'
			],
			'subject'=>[
				'reference'=>'Patient/'.$resource_id,
				'display'=>'Budi Santoso'
			],
			'participant'=>[
				[
					'type'=>[
						[
							'coding'=>[
								[
									'system'=>'http://terminology.hl7.org/CodeSystem/v3-ParticipationType',
									'code'=>'ATND',
									'display'=>'attender'
								]
							]
						]
					],
					'individual'=>[
						'reference'=>'Practitioner/N10000001',
						'display'=>'Dokter Bronsig'
					]
				]
			],
			'period'=>[
				'start'=>$dateNow
				//'start'=>$dateNow'T01:00:00+00:00'
			],
			'location'=>[
				[
					'location'=>[
						'reference'=>'Location/ef011065-38c9-46f8-9c35-d1fe68966a3e',
						'display'=>'Ruang 1A, Poliklinik Rawat Jalan'
					],
					'extension'=>[
						[
							'url'=>'https://fhir.kemkes.go.id/r4/StructureDefinition/ServiceClass',
							'extension'=>[
								[
									'url'=>'value',
									'valueCodeableConcept'=>[
										'coding'=>[
											[
												'system'=>'http://terminology.kemkes.go.id/CodeSystem/locationServiceClass-Outpatient',
												'code'=>'reguler',
												'display'=>'Kelas Reguler'
											]
										]
									]
								]
							]
						]
					]
				]
			],
			'statusHistory'=>[
				[
					'status'=>'arrived',
					'period'=>[
						'start'=>$dateNow
						//'start'=>$dateNow'T01:00:00+00:00'
					]
				]
			],
			'serviceProvider'=>[
				'reference'=>'Organization/24027125-68be-4154-a573-79d6571679d5'
			]
		]);
		$encounter_data = json_decode($encounter, true);
		$encounter_id = $encounter_data['id'];
		$countAntrian = DB::table('data_antrian')
		->where('id_jadwal', '=', $request->id_jadwal)
		->max('no_antrian');
		$generateAntrian = $countAntrian+1 ;
		$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
		$countPx = DB::table('data_pasien')
		->max('id_pasien');
		$generateidpx = $countPx ;
		$antrian = new Antrian;
		$antrian->id_encounter = $encounter_id;
		$antrian->id_jadwal = $request->id_jadwal;
		$antrian->id_pasien = $generateidpx;
		$antrian->keluhan_awal = "demam";
		$antrian->no_antrian = $nomerAntrian;
		//$antrian->save();
		if (!$antrian->save()) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => 'Gagal menyimpan data Registrasi'
			];
		}
		
		//RFID//
		/*$cekRfid = DB::table('m_rfid')
		->where('rfid', '=', $request->rf_id)
		->select('rfid')
		->count();
		if ($cekRfid == 1){
			$rfid = Rfid::find($request->rf_id);
			$rfid->status = "aktif";
			$rfid->save();
		}else{
			$msg = "Rfid belum terdaftar"
		}
		*/
		
		}//end foreach//
		
		//return $resource_id; 
		$postKirim = array(
		"data" => $response
		);
		if ($response) {
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
			'token' => $token,
			'id_ss_number' => $resource_id,
			'antrian' => $nomerAntrian,
			'id_encounter' => $encounter_data,
			'encounter_id' => $encounter_id,
			'date now' => $dateNow,
			//'status' => $status,
			//'rfid validator' => $msg,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => $response_data
			];
		}
		
		} catch (\Exception $e) {
			// Handle any exceptions (e.g., 400 Bad Request)
			return response()->json([
			'error' => $e->getMessage(),
			'patient' => $response_data,
			//'encounter' => $encounter_data,
			], 500);
		}
	}
	
	public function storePatientByNikUpdate(Request $request) {
	try {
		$getToken = DB::table('token')
			->where('id_token', '=', 1)
			->get();
			foreach ($getToken as $key => $ch){
				$token = $ch->token;
				$response =Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Patient', [
				'resourceType'=> 'Patient',
			    'meta'=> [
				  'profile'=> [
					 'https://fhir.kemkes.go.id/r4/StructureDefinition/Patient'
				  ]
			   ],
			   'identifier'=> [
				  [
					 'use'=> 'official',
					 'system'=> 'https://fhir.kemkes.go.id/id/nik',
					 'value'=> $request->nomer_identitas_update
					 //'value'=> '35781016019100008'
				  ]
			   ],
			   'active'=> true,
			   'name'=> [
				  [
					 'use'=> 'official',
					 'text'=> $request->nama_pasien_update
					 //'text'=> 'sutoyo'
				  ]
			   ],
			   'telecom'=> [
				  [
					 'system'=> 'phone',
					 'value'=> $request->no_telp_update,
					 //'value'=> '085566554556',
					 'use'=> 'mobile'
				  ],
				  [
					 'system'=> 'phone',
					 'value'=> '+622123456789',
					 'use'=> 'home'
				  ],
				  [
					 'system'=> 'email',
					 'value'=> $request->email_update,
					 //'value'=> 'email@email.com',
					 'use'=> 'home'
				  ]
			   ],
			   'gender'=> $request->gender_update,
			   //'gender'=> 'male',
			   'birthDate'=> $request->tanggal_lahir_form_update,
			   //'birthDate'=> '1990-01-16',
			   'deceasedBoolean'=> false,
			   'address'=> [
				  [
					 'use'=> 'home',
					 'line'=> [
						$request->alamat_ktp_update
						//'jalan lebak rejo 6'
					 ],
					 'city'=> $request->kota_update,
					 //'city'=> 'surabaya',
					 'postalCode'=> $request->kode_pos_update,
					 //'postalCode'=> '60134',
					 'country'=> 'ID',
					 'extension'=> [
						[
						   'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
						   'extension'=> [
							  [
								 'url'=> 'province',
								 'valueCode'=> $request->kode_provinsi_update
								 //'valueCode'=> '04'
							  ],
							  [
								 'url'=> 'city',
								 'valueCode'=> $request->kode_kota_update
								 //'valueCode'=> '04'
							  ],
							  [
								 'url'=> 'district',
								 'valueCode'=> $request->kode_kecamatan_update
								 //'valueCode'=> '04'
							  ],
							  [
								 'url'=> 'village',
								 'valueCode'=> '1010101101'
							  ],
							  [
								 'url'=> 'rt',
								 'valueCode'=> $request->rt_update
								 //'valueCode'=> '04'
							  ],
							  [
								 'url'=> 'rw',
								 'valueCode'=> $request->rw_update
								 //'valueCode'=> '04'
							  ]
						   ]
						]
					 ]
				  ]
			   ],
			   'maritalStatus'=> [
				  'coding'=> [
					 [
						'system'=> 'http://terminology.hl7.org/CodeSystem/v3-MaritalStatus',
						'code'=> 'M',
						'display'=> 'Married'
					 ]
				  ],
				  'text'=> 'Married'
			   ],
			   'multipleBirthInteger'=> 0,
			   'contact'=> [
				  [
					 'relationship'=> [
						[
						   'coding'=> [
							  [
								 'system'=> 'http://terminology.hl7.org/CodeSystem/v2-0131',
								 'code'=> 'C'
							  ]
						   ]
						]
					 ],
					 'name'=> [
						'use'=> 'official',
						'text'=> $request->nama_penjamin_update
						//'text'=> 'Ardhi'
					 ],
					 'telecom'=> [
						[
						   'system'=> 'phone',
						   'value'=> $request->nomer_penjamin_update,
						   //'value'=> '08566554556654',
						   'use'=> 'mobile'
						]
					 ]
				  ]
			   ],
			   'communication'=> [
				  [
					 'language'=> [
						'coding'=> [
						   [
							  'system'=> 'urn=>ietf=>bcp=>47',
							  'code'=> 'id-ID',
							  'display'=> 'Indonesian'
						   ]
						],
						'text'=> 'Indonesian'
					 ],
					 'preferred'=> true
				  ]
			   ],
			   'extension'=> [
				  [
					 'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/birthPlace',
					 'valueAddress'=> [
						'city'=> $request->kota_update,
						//'city'=> 'surabaya',
						'country'=> 'ID'
					 ]
				  ],
				  [
					 'url'=> 'https=>//fhir.kemkes.go.id/r4/StructureDefinition/citizenshipStatus',
					 'valueCode'=> 'WNI'
				  ]
			   ]
			]);
			
		
		$response_data = json_decode($response, true);
		$status = $response_data['success'];
		if ($status == "true"){
			$resource_id = $response_data['data']['patient_id'];
			//$data_pasien = new dataPasien;
			$data_pasien = dataPasien::find($request->id_pasien_update);
			$data_pasien->satusehat_number = $resource_id;
			$data_pasien->nama_pasien = $request->nama_pasien_update;
			$data_pasien->no_telp = $request->no_telp_update;
			$data_pasien->email = $request->email_update;
			$data_pasien->jenis_kelamin = $request->gender_update;
			$data_pasien->tanggal_lahir = $request->tanggal_lahir_form_update;
			$data_pasien->alamat_ktp = $request->alamat_ktp_update;
			$data_pasien->nama_penjamin = $request->nama_penjamin_update;
			$data_pasien->nomer_penjamin = $request->nomer_penjamin_update;
			$data_pasien->tempat_lahir = $request->kota_update;	
			$data_pasien->kode_pos = $request->kode_pos_update;
			$data_pasien->provinsi = $request->provinsi_update;
			$data_pasien->kota = $request->kota_update;	
			$data_pasien->kecamatan = $request->kecamatans_update;
			$data_pasien->rw = $request->rw_update;
			$data_pasien->rt = $request->rt_update;	
			$data_pasien->kartu_identitas = $request->kartu_identitas_update;
			$data_pasien->nomer_identitas = $request->nomer_identitas_update;	
			//$data_pasien->save();
			if (!$data_pasien->save()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan data Registrasi'
				];
			}
		}else{
			$resource_id = $response_data['data']['resourceID'];
			//$data_pasien = new dataPasien;
			$data_pasien = dataPasien::find($request->id_pasien_update);
			$data_pasien->satusehat_number = $resource_id;
			$data_pasien->nama_pasien = $request->nama_pasien_update;
			$data_pasien->no_telp = $request->no_telp_update;
			$data_pasien->email = $request->email_update;
			$data_pasien->jenis_kelamin = $request->gender_update;
			$data_pasien->tanggal_lahir = $request->tanggal_lahir_form_update;
			$data_pasien->alamat_ktp = $request->alamat_ktp_update;
			$data_pasien->nama_penjamin = $request->nama_penjamin_update;
			$data_pasien->nomer_penjamin = $request->nomer_penjamin_update;
			$data_pasien->tempat_lahir = $request->kota_update;	
			$data_pasien->kode_pos = $request->kode_pos_update;
			$data_pasien->provinsi = $request->provinsi_update;
			$data_pasien->kota = $request->kota_update;	
			$data_pasien->kecamatan = $request->kecamatans_update;
			$data_pasien->rw = $request->rw_update;
			$data_pasien->rt = $request->rt_update;	
			$data_pasien->kartu_identitas = $request->kartu_identitas_update;
			$data_pasien->nomer_identitas = $request->nomer_identitas_update;	
			//$data_pasien->save();
			if (!$data_pasien->save()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan data Registrasi'
				];
			}
		}
		
		$dateNow = Carbon::now();
		
		//////ENCOUNTER/////////
		$encounter = Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Encounter', [
			'resourceType'=>'Encounter',
			'identifier'=>[
				[
					'system'=>'http://sys-ids.kemkes.go.id/encounter/24027125-68be-4154-a573-79d6571679d5',
					'value'=>$resource_id
				]
			],
			'status'=>'arrived',
			'class'=>[
				'system'=>'http://terminology.hl7.org/CodeSystem/v3-ActCode',
				'code'=>'AMB',
				'display'=>'ambulatory'
			],
			'subject'=>[
				'reference'=>'Patient/'.$resource_id,
				'display'=>'Budi Santoso'
			],
			'participant'=>[
				[
					'type'=>[
						[
							'coding'=>[
								[
									'system'=>'http://terminology.hl7.org/CodeSystem/v3-ParticipationType',
									'code'=>'ATND',
									'display'=>'attender'
								]
							]
						]
					],
					'individual'=>[
						'reference'=>'Practitioner/N10000001',
						'display'=>'Dokter Bronsig'
					]
				]
			],
			'period'=>[
				'start'=>$dateNow
				//'start'=>$dateNow'T01:00:00+00:00'
			],
			'location'=>[
				[
					'location'=>[
						'reference'=>'Location/ef011065-38c9-46f8-9c35-d1fe68966a3e',
						'display'=>'Ruang 1A, Poliklinik Rawat Jalan'
					],
					'extension'=>[
						[
							'url'=>'https://fhir.kemkes.go.id/r4/StructureDefinition/ServiceClass',
							'extension'=>[
								[
									'url'=>'value',
									'valueCodeableConcept'=>[
										'coding'=>[
											[
												'system'=>'http://terminology.kemkes.go.id/CodeSystem/locationServiceClass-Outpatient',
												'code'=>'reguler',
												'display'=>'Kelas Reguler'
											]
										]
									]
								]
							]
						]
					]
				]
			],
			'statusHistory'=>[
				[
					'status'=>'arrived',
					'period'=>[
						'start'=>$dateNow
						//'start'=>$dateNow'T01:00:00+00:00'
					]
				]
			],
			'serviceProvider'=>[
				'reference'=>'Organization/24027125-68be-4154-a573-79d6571679d5'
			]
		]);
		$encounter_data = json_decode($encounter, true);
		$encounter_id = $encounter_data['id'];
		$countAntrian = DB::table('data_antrian')
		->where('id_jadwal', '=', $request->id_jadwal_update)
		->max('no_antrian');
		$generateAntrian = $countAntrian+1 ;
		$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
		$countPx = DB::table('data_pasien')
		->max('id_pasien');
		$generateidpx = $countPx ;
		$antrian = new Antrian;
		$antrian->id_encounter = $encounter_id;
		$antrian->id_jadwal = $request->id_jadwal_update;
		$antrian->id_pasien = $request->id_pasien_update;
		$antrian->keluhan_awal = "demam";
		$antrian->no_antrian = $nomerAntrian;
		//$antrian->save();
		if (!$antrian->save()) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => 'Gagal menyimpan data Registrasi'
			];
		}
		
		//RFID//
		/*$cekRfid = DB::table('m_rfid')
		->where('rfid', '=', $request->rf_id)
		->select('rfid')
		->count();
		if ($cekRfid == 1){
			$rfid = Rfid::find($request->rf_id);
			$rfid->status = "aktif";
			$rfid->save();
		}else{
			$msg = "Rfid belum terdaftar"
		}
		*/
		
		}//end foreach//
		
		//return $resource_id; 
		/*$postKirim = array(
		"data" => $response
		);*/
		if ($response) {
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
			//'token' => $token,
			//'id_ss_number' => $resource_id,
			'antrian' => $nomerAntrian,
			'encounter' => $encounter_data,
			//'encounter_id' => $encounter_id,
			//'date now' => $dateNow,
			'status' => $status,
			'response_data' => $response_data,
			//'rfid validator' => $msg,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
		
		} catch (\Exception $e) {
			// Handle any exceptions (e.g., 400 Bad Request)
			return response()->json(['error' => $e->getMessage()], 500);
		}
	}
	
	public function cekIhsNumber(Request $request) {
	try {
		
		
		$getIhsNumber = DB::table('data_pasien')
		->where('id_pasien', '=', 10)
		->select('satusehat_number')
		->get();
		
		foreach ($getIhsNumber as $key => $ch){
		$ihsNumber = $ch->satusehat_number;
			if ($ihsNumber === null){
				$result = "belum punya ihs number";
			}else{
				$result = $ihsNumber;
			}
		}
		
		
		if ($getIhsNumber) {
			DB::commit();
			return [
				'result' => TRUE,
				'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
				'ihs number' => $ihsNumber,
				'hasil' => $result,
			];
			} else {
			return [
				'result' => FALSE,
				'message' => 'Gagal Mengambil Data',
				'ihs number' => $ihsNumber,
				'hasil' => $result,
			];
		}
		
		} catch (\Exception $e) {
			// Handle any exceptions (e.g., 400 Bad Request)
			return response()->json(['error' => $e->getMessage()], 500);
		}
	}
	
	
	
	public function storePatientByMotherNik() {
		$getToken = DB::table('token')
			->where('id_token', '=', 1)
			->get();
				$response =Http::withToken('uL9AMapmTFKp3vc8VX1Xfw9kBDaf')->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Patient', [
				'resourceType'=> 'Patient',
			   'meta'=> [
				  'profile'=> [
					 'https://fhir.kemkes.go.id/r4/StructureDefinition/Patient'
				  ]
			   ],
			   'identifier'=> [
				  [
					 "use"=> "official",
					 "system"=> "https://fhir.kemkes.go.id/id/nik-ibu",
					 "value"=> "3578101601900002"
				  ]
			   ],
			   'active'=> true,
			   'name'=> [
				  [
					 'use'=> 'official',
					 'text'=> 'John Smith'
				  ]
			   ],
			   'telecom'=> [
				  [
					 'system'=> 'phone',
					 'value'=> '08123456789',
					 'use'=> 'mobile'
				  ],
				  [
					 'system'=> 'phone',
					 'value'=> '+622123456789',
					 'use'=> 'home'
				  ],
				  [
					 'system'=> 'email',
					 'value'=> 'john.smith@xyz.com',
					 'use'=> 'home'
				  ]
			   ],
			   'gender'=> 'female',
			   'birthDate'=> '1945-11-17',
			   'deceasedBoolean'=> false,
			   'address'=> [
				  [
					 'use'=> 'home',
					 'line'=> [
						'Gd. Prof. Dr. Sujudi Lt.5, Jl. H.R. Rasuna Said Blok X5 Kav. 4-9 Kuningan'
					 ],
					 'city'=> 'Jakarta',
					 'postalCode'=> '12950',
					 'country'=> 'ID',
					 'extension'=> [
						[
						   'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
						   'extension'=> [
							  [
								 'url'=> 'province',
								 'valueCode'=> '10'
							  ],
							  [
								 'url'=> 'city',
								 'valueCode'=> '1010'
							  ],
							  [
								 'url'=> 'district',
								 'valueCode'=> '1010101'
							  ],
							  [
								 'url'=> 'village',
								 'valueCode'=> '1010101101'
							  ],
							  [
								 'url'=> 'rt',
								 'valueCode'=> '2'
							  ],
							  [
								 'url'=> 'rw',
								 'valueCode'=> '2'
							  ]
						   ]
						]
					 ]
				  ]
			   ],
			   'maritalStatus'=> [
				  'coding'=> [
					 [
						'system'=> 'http://terminology.hl7.org/CodeSystem/v3-MaritalStatus',
						'code'=> 'M',
						'display'=> 'Married'
					 ]
				  ],
				  'text'=> 'Married'
			   ],
			   'multipleBirthInteger'=> 0,
			   'contact'=> [
				  [
					 'relationship'=> [
						[
						   'coding'=> [
							  [
								 'system'=> 'http://terminology.hl7.org/CodeSystem/v2-0131',
								 'code'=> 'C'
							  ]
						   ]
						]
					 ],
					 'name'=> [
						'use'=> 'official',
						'text'=> 'Jane Smith'
					 ],
					 'telecom'=> [
						[
						   'system'=> 'phone',
						   'value'=> '0690383372',
						   'use'=> 'mobile'
						]
					 ]
				  ]
			   ],
			   'communication'=> [
				  [
					 'language'=> [
						'coding'=> [
						   [
							  'system'=> 'urn=>ietf=>bcp=>47',
							  'code'=> 'id-ID',
							  'display'=> 'Indonesian'
						   ]
						],
						'text'=> 'Indonesian'
					 ],
					 'preferred'=> true
				  ]
			   ],
			   'extension'=> [
				  [
					 'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/birthPlace',
					 'valueAddress'=> [
						'city'=> 'Bandung',
						'country'=> 'ID'
					 ]
				  ],
				  [
					 'url'=> 'https=>//fhir.kemkes.go.id/r4/StructureDefinition/citizenshipStatus',
					 'valueCode'=> 'WNI'
				  ]
			   ]
			]);
		return $response->json(); 
	}
	
}
