<?php

namespace App\Http\Controllers;
use Carbon\Carbon;
	use DataTables;
	use App\Models\masterKategoriLab;
	use App\Models\masterItemLab;
	use App\Models\masterSubItemLab;
	use App\Models\masterSub2ItemLab;
	use App\Models\Registrasi;
	use App\Models\Rfid;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

class adminController extends Controller
{
	/////////////MASTER KATEGORI LAB/////////////
    public function getMasterKategoriLabSSProcessing(Request $request)
	{
		//to use parameter or variable sent from ajax view
		$params = $request->params;
	 
		$whereClause = $params['sac'];
	 
		$query = DB::table('m_kategori_lab')->orderBy('id_kategori_lab','DESC') ;
		
		return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('action', function($query){
                        $btn = '<a style="color:#fff;" class="btn btn-warning" onclick="openModalKategoriLab(\''.$query->id_kategori_lab.'\')"><i class="fas fa-pencil-alt"></i> Edit</a> I <a style="color:#fff;" class="btn btn-danger" onclick="deleteKategoriLab(\''.$query->id_kategori_lab.'\')"><i class="fas fa-trash"></i> Hapus</a>';
						
						return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
	}
	
	public function getMasterKategoriLab(Request $request) {
			
			$kategoriLab = DB::table('m_kategori_lab')
			->where('id_kategori_lab', '=', $request->id_kategori_lab)
			->get();
			if ($kategoriLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $kategoriLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function deleteMasterKategoriLab(Request $request) {
			DB::begintransaction();
			try {
				$delete = masterKategoriLab::find($request->id_kategori_lab);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function updateMasterKategoriLab(Request $request) {
			DB::begintransaction();
			try {
				$masterKategoriLab = masterKategoriLab::find($request->id_kategori_lab);
				$masterKategoriLab->kategori_lab = $request->kategori_lab;
				if (!$masterKategoriLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterKategoriLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function insertMasterKategoriLab(Request $request) {
			DB::begintransaction();
			try {
				$masterKategoriLab = new masterKategoriLab;
				$masterKategoriLab->kategori_lab = $request->kategori_lab;
				if (!$masterKategoriLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterKategoriLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	/////////////MASTER ITEM LAB/////////////
	public function getMasterItemLabSSProcessing(Request $request)
	{
		//to use parameter or variable sent from ajax view
		$params = $request->params;
	 
		$whereClause = $params['sac'];
	 
		$query = DB::table('m_item_lab')
		->join('m_kategori_lab', 'm_kategori_lab.id_kategori_lab', '=', 'm_item_lab.id_kategori_lab')
		->orderBy('id_item_lab','DESC') 
		->get();
		
		return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('action', function($query){
                        $btn = '<a style="color:#fff;" class="btn btn-warning" onclick="openModalItemLab(\''.$query->id_item_lab.'\')"><i class="fas fa-pencil-alt"></i> Edit</a> I <a style="color:#fff;" class="btn btn-danger" onclick="deleteItemLab(\''.$query->id_item_lab.'\')"><i class="fas fa-trash"></i> Hapus</a>';
						
						return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
	}
	
	public function insertMasterItemLab(Request $request) {
			DB::begintransaction();
			try {
				$masterItemLab = new masterItemLab;
				$masterItemLab->id_kategori_lab = $request->id_kategori_lab;
				$masterItemLab->item_lab = $request->item_lab;
				$masterItemLab->item_nilai_rujukan = $request->item_nilai_rujukan;
				$masterItemLab->item_satuan = $request->item_satuan;
				$masterItemLab->item_keterangan = $request->item_keterangan;
				$biaya = $request->harga_item_lab;
				$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
				$masterItemLab->harga_item_lab = $biayaReplace;
				if (!$masterItemLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterItemLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function getMasterItemLab(Request $request) {
			
			$itemLab = DB::table('m_item_lab')
			->where('id_item_lab', '=', $request->id_item_lab)
			->get();
			if ($itemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $itemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDataKategoriValue(Request $request) {
			$kategoriLab = DB::table('m_kategori_lab')
			->get();
			if ($kategoriLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $kategoriLab,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function updateMasterItemLab(Request $request) {
			DB::begintransaction();
			try {
				$masterItemLab = masterItemLab::find($request->id_item_lab);
				$masterItemLab->id_kategori_lab = $request->id_kategori_lab;
				$masterItemLab->item_lab = $request->item_lab;
				$masterItemLab->item_nilai_rujukan = $request->item_nilai_rujukan;
				$masterItemLab->item_satuan = $request->item_satuan;
				$masterItemLab->item_keterangan = $request->item_keterangan;
				$biaya = $request->harga_item_lab;
				$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
				$masterItemLab->harga_item_lab = $biayaReplace;
				if (!$masterItemLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterItemLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function deleteMasterItemLab(Request $request) {
			DB::begintransaction();
			try {
				$delete = masterItemLab::find($request->id_item_lab);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	/////////////MASTER SUB ITEM LAB/////////////
	public function getMasterSubItemLabSSProcessing(Request $request)
	{
		//to use parameter or variable sent from ajax view
		$params = $request->params;
	 
		$whereClause = $params['sac'];
	 
		$query = DB::table('m_subitem_lab')
		->join('m_item_lab', 'm_item_lab.id_item_lab', '=', 'm_subitem_lab.id_item_lab')
		->orderBy('id_sub_item','DESC') 
		->get();
		
		return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('action', function($query){
                        $btn = '<a style="color:#fff;" class="btn btn-warning" onclick="openModalSubItemLab(\''.$query->id_sub_item.'\')"><i class="fas fa-pencil-alt"></i> Edit</a> I <a style="color:#fff;" class="btn btn-danger" onclick="deleteSubItemLab(\''.$query->id_sub_item.'\')"><i class="fas fa-trash"></i> Hapus</a>';
						
						return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
	}
	
	public function getDataItemLabValue(Request $request) {
			
			$itemLab = DB::table('m_item_lab')
			->get();
			if ($itemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $itemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function insertMasterSubItemLab(Request $request) {
			DB::begintransaction();
			try {
				$masterSubItemLab = new masterSubItemLab;
				$masterSubItemLab->id_item_lab = $request->id_item_lab;
				$masterSubItemLab->sub_item = $request->sub_item;
				$masterSubItemLab->subitem_nilai_rujukan = $request->subitem_nilai_rujukan;
				$masterSubItemLab->subitem_satuan = $request->subitem_satuan;
				$masterSubItemLab->subitem_keterangan = $request->subitem_keterangan;
				
				if (!$masterSubItemLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterSubItemLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function getMasterSubItemLab(Request $request) {
			
			$subItemLab = DB::table('m_subitem_lab')
			->where('id_sub_item', '=', $request->id_sub_item)
			->get();
			if ($subItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $subItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDataItemLabValueEdit(Request $request) {
			
			$itemLab = DB::table('m_item_lab')
			->get();
			if ($itemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $itemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function updateMasterSubItemLab(Request $request) {
			DB::begintransaction();
			try {
				$masterSubItemLab = masterSubItemLab::find($request->id_sub_item);
				$masterSubItemLab->id_item_lab = $request->id_item_lab;
				$masterSubItemLab->sub_item = $request->sub_item;
				$masterSubItemLab->subitem_nilai_rujukan = $request->subitem_nilai_rujukan;
				$masterSubItemLab->subitem_satuan = $request->subitem_satuan;
				$masterSubItemLab->subitem_keterangan = $request->subitem_keterangan;
				if (!$masterSubItemLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterSubItemLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function deleteMasterSubItemLab(Request $request) {
			DB::begintransaction();
			try {
				$delete = masterSubItemLab::find($request->id_sub_item);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	/////////////MASTER SUB 2 ITEM LAB/////////////
	public function getMasterSub2ItemLabSSProcessing(Request $request)
	{
		//to use parameter or variable sent from ajax view
		$params = $request->params;
	 
		$whereClause = $params['sac'];
	 
		$query = DB::table('m_sub2item_lab')
		->join('m_subitem_lab', 'm_subitem_lab.id_sub_item', '=', 'm_sub2item_lab.id_sub_item')
		->orderBy('id_sub2_item_lab','DESC') 
		->get();
		
		return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('action', function($query){
                        $btn = '<a style="color:#fff;" class="btn btn-warning" onclick="openModalSub2ItemLab(\''.$query->id_sub2_item_lab.'\')"><i class="fas fa-pencil-alt"></i> Edit</a> I <a style="color:#fff;" class="btn btn-danger" onclick="deleteSub2ItemLab(\''.$query->id_sub2_item_lab.'\')"><i class="fas fa-trash"></i> Hapus</a>';
						
						return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
	}
	
	public function getDataSubItemLabValue(Request $request) {
			
			$subItemLab = DB::table('m_subitem_lab')
			->get();
			if ($subItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $subItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function insertMasterSub2ItemLab(Request $request) {
			DB::begintransaction();
			try {
				$masterSub2ItemLab = new masterSub2ItemLab;
				$masterSub2ItemLab->id_sub_item = $request->id_sub_item;
				$masterSub2ItemLab->sub2_item_lab = $request->sub2_item_lab;
				$masterSub2ItemLab->sub2item_nilai_rujukan = $request->sub2item_nilai_rujukan;
				$masterSub2ItemLab->sub2item_satuan = $request->sub2item_satuan;
				$masterSub2ItemLab->sub2item_keterangan = $request->sub2item_keterangan;
				
				if (!$masterSub2ItemLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterSub2ItemLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function getDataSub2ItemLabValueEdit(Request $request) {
			
			$subItemLab = DB::table('m_subitem_lab')
			->get();
			if ($subItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $subItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getMasterSub2ItemLab(Request $request) {
			
			$sub2ItemLab = DB::table('m_sub2item_lab')
			->where('id_sub2_item_lab', '=', $request->id_sub2_item_lab)
			->get();
			if ($sub2ItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $sub2ItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function updateMasterSub2ItemLab(Request $request) {
			DB::begintransaction();
			try {
				$masterSub2ItemLab = masterSub2ItemLab::find($request->id_sub2_item_lab);
				$masterSub2ItemLab->id_sub_item = $request->id_sub_item;
				$masterSub2ItemLab->sub2_item_lab = $request->sub2_item_lab;
				$masterSub2ItemLab->sub2item_nilai_rujukan = $request->sub2item_nilai_rujukan;
				$masterSub2ItemLab->sub2item_satuan = $request->sub2item_satuan;
				$masterSub2ItemLab->sub2item_keterangan = $request->sub2item_keterangan;
				if (!$masterSub2ItemLab->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data masterSub2ItemLab'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
	
	public function deleteMasterSub2ItemLab(Request $request) {
			DB::begintransaction();
			try {
				$delete = masterSub2ItemLab::find($request->id_sub2_item_lab);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	/////////////MASTER PROFILE PASIEN/////////////
	public function ss_processingAdmin(Request $request)
	{
		//to use parameter or variable sent from ajax view
		$params = $request->params;
	 
		$whereClause = $params['sac'];
	 
		$query = DB::table('data_pasien')->orderBy('nomer_rm','DESC') ;
		
		return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('action', function($query){
                        $btn = '<a style="width:50%;color:#fff;" class="btn btn-warning" onclick="editPasienModal(\''.$query->id_pasien.'\')"><i class="fas fa-pencil-alt"></i> Edit</a> I <a style="width:50%;color:#fff;" class="btn btn-success" onclick="editKartuModal(\''.$query->id_pasien.'\')"><i class="fas fa-card-alt"></i> Ganti Kartu</a>';
						
						return $btn;
                    })
					->addColumn('age', function($query){
                        return  \Carbon\Carbon::parse($query->tanggal_lahir)->diff(\Carbon\Carbon::now())->format('%y thn %m bln %d hr');
					})
                    ->rawColumns(['action'])
                    ->make(true);
	}
	
	public function getDataPasienModal(Request $request) {
			
			$dataPasien = DB::table('data_pasien')
			->where('id_pasien', '=', $request->id_pasien)
			->get();
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $dataPasien
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		
	public function updatePasienData(Request $request) {
			DB::begintransaction();
			try {
				$registrasi = Registrasi::find($request->id_pasien);
				//$registrasi->rf_id = $request->rf_id;
				$registrasi->nomer_rm = $request->nomer_rm;
				$registrasi->nama_pasien = $request->nama_pasien;
				$registrasi->tanggal_lahir = $request->tanggal_lahir;
				$registrasi->jenis_kelamin = $request->jenis_kelamin;
				$registrasi->kartu_identitas = $request->kartu_identitas;
				$registrasi->nomer_identitas = $request->nomer_identitas;
				$registrasi->alamat_ktp = $request->alamat_ktp;
				$registrasi->alamat_sekarang = $request->alamat_sekarang;
				$registrasi->no_telp = $request->no_telp;
				$registrasi->email = $request->email;
				$registrasi->pekerjaan = $request->pekerjaan;
				if (!$registrasi->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data registrasi'
					];
				}
				
				/*$rfid = Rfid::find($request->rf_id);
				$rfid->status = "aktif";
				$rfid->id_pasien = $request->id_pasien;
				$rfid->tanggal_register = Carbon::now();
				if (!$rfid->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Registrasi'
					];
				}*/
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function updateKartuData(Request $request) {
			DB::begintransaction();
			try {
				$registrasi = Registrasi::find($request->id_pasiens);
				$registrasi->rf_id = $request->rf_id;
				if (!$registrasi->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data registrasi'
					];
				}
				/*
				$rfid = Rfid::find($request->rf_id);
				$rfid->status = "aktif";
				$rfid->id_pasien = $request->id_pasien;
				$rfid->tanggal_register = Carbon::now();
				if (!$rfid->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Registrasi'
					];
				}*/
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbarui data ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
}
