<?php

namespace App\Http\Controllers;
	use Carbon\Carbon;
	use DataTables;
	use Illuminate\Http\Request;
	use Auth;
	use Illuminate\Support\Facades\DB;

class datatablePasienController extends Controller
{
    public function ss_processing_pasien(Request $request)
	{
		//to use parameter or variable sent from ajax view
		$params = $request->params;
	 
		$whereClause = $params['sac'];
	 
		$query = DB::table('data_pasien')->orderBy('nomer_rm','DESC') ;
		
		return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('action', function($query){
                        $btn = '<a style="width:50%;color:#fff;" class="btn btn-warning" onclick="rekamMedisPasien(\''.$query->id_pasien.'\')">Rekam Medis</a> I <a style="width:50%;color:#fff;" class="btn btn-info" onclick="transaksiPasien(\''.$query->id_pasien.'\')">Transaksi</a>';
						
						return $btn;
                    })
					->addColumn('age', function($query){
                        return  \Carbon\Carbon::parse($query->tanggal_lahir)->diff(\Carbon\Carbon::now())->format('%y thn %m bln %d hr');
					})
                    ->rawColumns(['action'])
                    ->make(true);
	}
}
