<?php
	
namespace App\Http\Controllers;
	use Carbon\Carbon;
	use DataTables;
	use Illuminate\Http\Request;
	use Auth;
	use App\Models\Registrasi;
	use App\Models\Rfid;
	use App\Models\Antrian;
	use App\Models\Transaksi;
	use App\Models\TindakanPasien;
	use App\Models\resepObat;
	use App\Models\dataPasien;
	use App\Models\masterPenyakitPasien;
	use App\Models\masterObat;
	use App\Models\masterTindakan;
	use App\Models\penyakitPasien;
	use App\Models\antrianRad;
	use App\Models\transaksiLab;
	use App\Models\dokterPerujuk;
	use App\Models\jadwalDokter;
	use Illuminate\Support\Facades\DB;

class poliController extends Controller
{
	////////////////////CONTROLLER FOR HOME////////////////////
    public function getJadwalDokter(Request $request) {
			$jadwalDokter = DB::table('data_dokter')
			->join('data_poli', 'data_poli.id_poli', '=', 'data_dokter.id_poli')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.id_dokter','data_dokter.nama_dokter','jadwal_poli.tanggal','jadwal_poli.id_jadwal','jadwal_poli.jam_buka','jadwal_poli.jam_tutup','data_poli.nama_poli','jadwal_poli.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('data_poli.id_poli', '=', $request->id_poli)
			->orderBy('jadwal_poli.id_jadwal','ASC')   
			->get();
			if ($jadwalDokter) {
				return [
                'message' => 'Berhasil Mengambil Data Jadwal',
                'status' => 1,
                'data' =>  $jadwalDokter
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDaftarPasien(Request $request) {
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_pasien.nomer_rm','data_pasien.sync_pasien','data_antrian.pemeriksaan_fisik','data_antrian.pemeriksaan_dokter','data_antrian.sync_antrian','data_antrian.no_antrian','data_antrian.id_antrian','data_antrian.status','data_antrian.confirmed')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('data_antrian.id_antrian','asc')
			->get();
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Daftar Pasien',
                'status' => 1,
                'data' =>  $dataPasien
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function countPasienRegister(Request $request) {
			
			$registered = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->count();
			if ($registered) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'registered' => $registered
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function countPasienDilayani(Request $request) {
			
			$servings = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_antrian.no_antrian')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 3 )
			->get();
			if ($servings) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'servings' => $servings
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function countPasienSudahDilayani(Request $request) {
			
			$served = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 4 )
			->count();
			if ($served) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'served' => $served
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function countStockKartu(Request $request) {
			$dataKartu = DB::table('stock_kartu')
			->sum('jumlah_kartu');
			$kartuTerpakai = DB::table('m_rfid')
			->where('status', '=', "aktif" )
			->count();
			$stockKartu = $dataKartu - $kartuTerpakai;
			if ($dataKartu) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'stockKartu' =>  $stockKartu
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function updateStatus(Request $request) {
			DB::begintransaction();
			try {
				$status = Antrian::find($request->id_antrian);
				$status->status = $request->status;
				if (!$status->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'status' => $status->status,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeJadwalDokter(Request $request) {
			DB::begintransaction();
			try {
				//Data jadwal
				$jadwal = new jadwalDokter;
				$jadwal->id_dokter = $request->id_dokter;
				$jadwal->jam_buka = $request->jam_buka;
				$jadwal->jam_tutup = $request->jam_tutup;
				$jadwal->tanggal = $request->tanggal;
				$jadwal->hari = $request->hari;
				
				if (!$jadwal->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data jadwal'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $jadwal
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data jadwal ke database. Memuat ulang halaman...',
                    'jadwal' => $jadwal
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
}	
