<?php

namespace App\Http\Controllers;
use Carbon\Carbon;
	use DataTables;
	use Illuminate\Http\Request;
	use Auth;
	use App\Models\Registrasi;
	use App\Models\Rfid;
	use App\Models\Antrian;
	use App\Models\Transaksi;
	use App\Models\TindakanPasien;
	use App\Models\resepObat;
	use App\Models\dataPasien;
	use App\Models\masterPenyakitPasien;
	use App\Models\masterObat;
	use App\Models\masterTindakan;
	use App\Models\penyakitPasien;
	use App\Models\antrianRad;
	use App\Models\transaksiLab;
	use App\Models\dokterPerujuk;
	use App\Models\jadwalDokter;
	use Illuminate\Support\Facades\DB;

class rekamMedisController extends Controller
{
    public function getRekamMedis (Request $request){
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian','data_antrian.tanggal_reg')
			->where('data_pasien.id_pasien', '=', $request->id_pasien)
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$pasien_name = $ch->nama_pasien;
				$pasien_id = $ch->id_pasien;
				$id_antrian = $ch->id_antrian;
				$tanggal_reg = $ch->tanggal_reg;
				$antrian = DB::table('data_antrian')
				->select('data_antrian.id_antrian')
				->where('data_antrian.id_antrian', '=', $id_antrian)
				->get();
				$dokter = DB::table('data_dokter')
				->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
				->join('data_antrian', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->select('data_dokter.nama_dokter')
				->where('data_antrian.id_antrian', '=', $id_antrian)
				->get();
				$childs_id=[];
				foreach ($antrian as $keys => $chs){
					$antrian_id = $chs->id_antrian;
					$keluhanUtama = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('keluhan_utama', 'data_antrian.id_antrian', '=', 'keluhan_utama.id_antrian')
					->select('keluhan_utama.free_text_ku')
					->where('keluhan_utama.id_antrian', '=', $antrian_id)
					->get();
					$pemeriksaanFisik = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('pemeriksaan_fisik_pasien', 'data_antrian.id_antrian', '=', 'pemeriksaan_fisik_pasien.id_antrian')
					->select('pemeriksaan_fisik_pasien.valueSistol','pemeriksaan_fisik_pasien.valueDiastole','pemeriksaan_fisik_pasien.valueSuhu','pemeriksaan_fisik_pasien.valueBerat')
					->where('pemeriksaan_fisik_pasien.id_antrian', '=', $antrian_id)
					->get();
					$childs_id[$keys] =[
					'keluhanUtama'=>$keluhanUtama,
					'pemeriksaanFisik'=>$pemeriksaanFisik,
					]; 
				}
				$child_id[$key] =[
				'antrian'=>$id_antrian,
				'tanggal_reg'=>$tanggal_reg,
				'dokter'=>$dokter,
				'rm'=>$childs_id,
				];
			}
			
			
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'pasien'=>$pasien_name,
				'data' => $child_id
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
	public function getdataPasienRm(Request $request) {
			$dataPasien = DB::table('data_pasien')
			->where('id_pasien', '=', $request->id_pasien)
			->get();
			
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataPasien
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
}
