<?php

namespace App\Http\Controllers;
	use Carbon\Carbon;
	use DataTables;
	use Illuminate\Http\Request;
	use Auth;
	use App\Models\Registrasi;
	use App\Models\Rfid;
	use App\Models\Antrian;
	use App\Models\Transaksi;
	use App\Models\TindakanPasien;
	use App\Models\resepObat;
	use App\Models\dataPasien;
	use App\Models\masterPenyakitPasien;
	use App\Models\masterObat;
	use App\Models\masterTindakan;
	use App\Models\penyakitPasien;
	use App\Models\antrianRad;
	use App\Models\transaksiLab;
	use App\Models\dokterPerujuk;
	use App\Models\jadwalDokter;
	use Illuminate\Support\Facades\DB;

class transaksiController extends Controller
{
   public function getDataTransaksiFrontInvoice(Request $request) {
			$antrian = DB::table('data_antrian')
			->select('id_antrian')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			$child_id=[];
			foreach ($antrian as $key => $ch){
				$id_antrian = $ch->id_antrian;
				$theraphy = DB::table('data_transaksi')
				->where('id_antrian', '=', $id_antrian)
				->where('jenis_transaksi', '=', 'obat')
				//->whereIn('jenis_transaksi', ['jasa dokter', 'obat'])
				->sum('nominal');
				$transaksi = DB::table('data_transaksi')
				->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
				->where('id_antrian', '=', $id_antrian)
				->whereIn('transaksi', ['Jasa Dokter dan Tindakan', 'Pendaftaran'])
				->get();
				$child_id[$key] =[
				'antrian'=>$id_antrian,
				'theraphy'=>$theraphy,
				'transaksi'=>$transaksi,
				]; 
			}
			$detailTheraphy = DB::table('data_transaksi')
				->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
				->where('id_antrian', '=', $id_antrian)
				//->whereIn('jenis_transaksi', ['jasa dokter', 'tindakan'])
				->where('jenis_transaksi', '=', 'obat')
				->get();
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_antrian.no_antrian','data_antrian.tanggal_reg','data_antrian.anamnesa','data_antrian.keluhan_awal','data_pasien.nama_pasien','data_pasien.tanggal_lahir','data_pasien.jenis_kelamin','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.alamat_ktp','data_pasien.no_telp','data_pasien.email')
			->where('data_antrian.id_antrian', '=', $request->id_antrian)
			->get();
			$totalNominal = DB::table('data_transaksi')
			->where('id_antrian', '=', $request->id_antrian)
			->sum('nominal');
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($antrian) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $child_id,
				'detail' =>  $detailTheraphy,
				'pasien' =>  $dataPasien,
				'total' =>  $totalNominal,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
//////////////////////////////////////////////////////////////////	
		 public function getDataTransaksiFront(Request $request) {
			$antrian = DB::table('data_antrian')
			->select('id_antrian')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			$child_id=[];
			foreach ($antrian as $key => $ch){
				$id_antrian = $ch->id_antrian;
				$theraphy = DB::table('data_transaksi')
				->where('id_antrian', '=', $id_antrian)
				->where('jenis_transaksi', '=', 'obat')
				//->whereIn('jenis_transaksi', ['jasa dokter', 'obat'])
				->sum('nominal');
				$transaksi = DB::table('data_transaksi')
				->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
				->where('id_antrian', '=', $id_antrian)
				->whereIn('transaksi', ['Jasa Dokter dan Tindakan', 'Pendaftaran'])
				->get();
				$child_id[$key] =[
				'antrian'=>$id_antrian,
				'theraphy'=>$theraphy,
				'transaksi'=>$transaksi,
				]; 
			}
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($antrian) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $child_id,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		 public function getDetailTransaksi(Request $request) {
			$detailTheraphy = DB::table('data_transaksi')
				->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
				->where('id_antrian', '=', $request->id_antrian)
				//->whereIn('jenis_transaksi', ['jasa dokter', 'tindakan'])
				->where('jenis_transaksi', '=', 'obat')
				->get();
			if ($detailTheraphy) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'detail' =>  $detailTheraphy
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		 public function getDataPasienTransaksi(Request $request) {
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_antrian.no_antrian','data_antrian.anamnesa','data_antrian.keluhan_awal','data_pasien.nama_pasien','data_pasien.tanggal_lahir','data_pasien.jenis_kelamin','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.alamat_sekarang','data_pasien.no_telp','data_pasien.email')
			->where('data_antrian.id_antrian', '=', $request->id_antrian)
			->get();
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'pasien' =>  $dataPasien
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataTotalTransaksi(Request $request) {
			$totalNominal = DB::table('data_transaksi')
			->where('id_antrian', '=', $request->id_antrian)
			->sum('nominal');
			if ($totalNominal) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'total' =>  $totalNominal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
//////////////////////////////////////////////////////////////////
		
		public function storeTransaksi(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
			$transaksi = new Transaksi;
				$transaksi->id_antrian = $request->id_antrian;
				$transaksi->jenis_transaksi = $request->transaksi;
				$transaksi->transaksi = "Jasa Dokter dan Tindakan";
				$biaya = $request->biaya;
				$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
				$diskon = $request->diskon;
				$nominalDiskon = $biayaReplace * ($diskon / 100);
				$transaksi->diskon = $nominalDiskon;
				$finalDiskon = $biayaReplace - $nominalDiskon;
				$qty = $request->qty;
				$transaksi->qty = $qty;
				$grandTotal = $finalDiskon * $qty;
				$transaksi->nominal = $grandTotal;
				$transaksi->jenis_pembayaran = $request->jenis_pembayaran;
				
				if (!$transaksi->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $transaksi
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $transaksi
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeTransaksiPendaftaran(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
			$transaksi = new Transaksi;
				$transaksi->id_antrian = $request->id_antrian;
				$transaksi->transaksi = $request->transaksi;
				$transaksi->jenis_transaksi = $request->jenis_transaksi;
				$transaksi->nominal = $request->biaya;
				$transaksi->jenis_pembayaran = $request->jenis_pembayaran;
				
				if (!$transaksi->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $transaksi
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $transaksi
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function updateStatusPembayaran(Request $request) {
			DB::begintransaction();
			try {
				$status = Transaksi::find($request->id_trx);
				$status->jenis_pembayaran = $request->jenis_pembayaran;
				if (!$status->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'status' => $status->status,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function deleteTransaksi(Request $request) {
			DB::begintransaction();
			try {
				$delete = Transaksi::find($request->id_trx);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
//////////////////////////////////REVISI/////////////////////////
 public function getDataRevisiTransaksi() {
			$dataTransaksi = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('data_transaksi', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter','data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.tanggal_reg','data_transaksi.id_trx','data_transaksi.jenis_transaksi','data_transaksi.nominal','data_transaksi.nominal_rev','data_transaksi.status')
			->where('data_transaksi.status', '=', 2)
			->get();
			if ($dataTransaksi) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $dataTransaksi
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
public function getItemRevisiTransaksi(Request $request) {
			$dataTransaksi = DB::table('data_transaksi')
			//->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_transaksi.id_trx','data_transaksi.jenis_transaksi','data_transaksi.nominal','data_transaksi.nominal_rev','data_transaksi.status')
			->where('data_transaksi.id_trx', '=', $request->id_trx)
			->get();
			if ($dataTransaksi) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $dataTransaksi
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		
    public function updateRevisiTransaksi(Request $request) {
			DB::begintransaction();
			try {
				$status = Transaksi::find($request->id_trx);
				$status->status = 3;
				$status->nominal = $request->nominal;
				if (!$status->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'status' => $status->status,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function updateReqRevisiTransaksi(Request $request) {
			DB::begintransaction();
			try {
				$status = Transaksi::find($request->id_trx);
				$status->status = 2;
				$status->nominal_rev = $request->nominal_rev;
				$status->jenis_pembayaran = $request->jenis_pembayaran;
				if (!$status->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'status' => $status->status,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
}
