<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});



Route::post('update-token', 'App\Http\Controllers\HomeController@updateToken');
Route::post('registrasi-pasien-baru', 'App\Http\Controllers\HomeController@storePatientByNikTest');
Route::post('update-pasien-baru', 'App\Http\Controllers\HomeController@storePatientByNikUpdate');

Route::post('get-stetoschope', 'App\Http\Controllers\satuSehatController@getStetoschope');
Route::post('get-data-pemeriksaan-stetoschope', 'App\Http\Controllers\satuSehatController@getPemeriksaanStetoschope');

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('checkDuplicate', 'App\Http\Controllers\satuSehatController@checkDuplicate');
Route::post('checkDuplicateAntrian', 'App\Http\Controllers\satuSehatController@checkDuplicateAntrian');
Route::post('checkRfid', 'App\Http\Controllers\satuSehatController@checkRfid');
Route::post('syncronizeTest2', 'App\Http\Controllers\satuSehatController@syncronizeTest2');
Route::post('select-icd-10', 'App\Http\Controllers\satuSehatController@selectDataICD10');
Route::post('select-icd-9', 'App\Http\Controllers\satuSehatController@selectDataICD9');
Route::post('getKeluhanPrimmer', 'App\Http\Controllers\satuSehatController@getKeluhanPrimmer');
Route::post('getKeluhanSekunder', 'App\Http\Controllers\satuSehatController@getKeluhanSekunder');
Route::post('insert-keluhan-sekunder', 'App\Http\Controllers\satuSehatController@insertKeluhanSekunder');
Route::post('insert-keluhan-primer', 'App\Http\Controllers\satuSehatController@insertKeluhanPrimer');
Route::post('delete-keluhan-primer', 'App\Http\Controllers\satuSehatController@deleteKeluhanPrimer');
Route::post('delete-keluhan-sekunder', 'App\Http\Controllers\satuSehatController@deleteKeluhanSekunder');

Route::post('insert-status-lokalis', 'App\Http\Controllers\satuSehatController@insertStatusLokalis');
Route::post('update-status-lokalis', 'App\Http\Controllers\satuSehatController@updateStatusLokalis');
Route::post('get-status-lokalis', 'App\Http\Controllers\satuSehatController@getStatusLokalis');



Route::post('select-allergy', 'App\Http\Controllers\satuSehatController@selectDataAllergy');
Route::post('select-allergy-manifest', 'App\Http\Controllers\satuSehatController@selectManifestAllergy');
Route::post('getAllergyPasien', 'App\Http\Controllers\satuSehatController@getAllergyPasien');
Route::post('insert-allergy-pasien', 'App\Http\Controllers\satuSehatController@insertAllergyPasien');
Route::post('delete-allergy-pasien', 'App\Http\Controllers\satuSehatController@deleteAllergyPasien');
Route::post('getPemeriksaanFisikPasien', 'App\Http\Controllers\satuSehatController@getPemeriksaanFisikPasien');
Route::post('delete-pemeriksaan-fisik', 'App\Http\Controllers\satuSehatController@deletePemeriksaanFisik');
Route::post('insert-pemeriksaan-fisik', 'App\Http\Controllers\satuSehatController@insertPemeriksaanFisik');
Route::post('insert-pemeriksaan-fisik-dokter', 'App\Http\Controllers\satuSehatController@insertPemeriksaanFisikDokter');
Route::post('getKesadaranPasien', 'App\Http\Controllers\satuSehatController@getKesadaranPasien');
Route::post('delete-tingkat-kesadaran', 'App\Http\Controllers\satuSehatController@deleteKesadaranPasien');
Route::post('insert-tingkat-kesadaran', 'App\Http\Controllers\satuSehatController@insertKesadaranPasien');
Route::post('select-observation', 'App\Http\Controllers\satuSehatController@selectObservationInterpretation');
Route::post('get-informasi-pemeriksaan', 'App\Http\Controllers\satuSehatController@getInformasiPemeriksaan');
Route::post('get-tabel-pemeriksaan', 'App\Http\Controllers\satuSehatController@getTabelPemeriksaan');

Route::post('select-bodysite', 'App\Http\Controllers\satuSehatController@selectDataBodySite');
Route::post('select-keluhan-utama', 'App\Http\Controllers\satuSehatController@selectDataKeluhanUtama');
Route::post('insert-keluhan-utama', 'App\Http\Controllers\satuSehatController@insertKeluhanUtama');
Route::post('getKeluhanUtama', 'App\Http\Controllers\satuSehatController@getKeluhanUtama');
Route::post('delete-keluhan-utama', 'App\Http\Controllers\satuSehatController@deleteKeluhanUtama');
Route::post('select-daftar-obat', 'App\Http\Controllers\satuSehatController@selectDaftarObat');
Route::post('get-kandungan-obat', 'App\Http\Controllers\satuSehatController@getKandunganObat');
Route::post('select-resep-denominator', 'App\Http\Controllers\satuSehatController@selectResepDenominator');
Route::post('select-code-resep', 'App\Http\Controllers\satuSehatController@selectCodeResep');
Route::post('select-metode-resep', 'App\Http\Controllers\satuSehatController@selectMetodeResep');
Route::post('get-resep-obat', 'App\Http\Controllers\satuSehatController@getResepObat');
Route::post('get-resep-aturan', 'App\Http\Controllers\satuSehatController@getResepAturan');
Route::post('get-resep-obat-nonracikan', 'App\Http\Controllers\satuSehatController@getResepObatNonRacikan');
Route::post('get-resep-obat-nonracikan-edit', 'App\Http\Controllers\satuSehatController@getResepObatNonRacikanEdit');
Route::post('edit-resep-nonracikan', 'App\Http\Controllers\satuSehatController@editResepObatNonRacikan');
Route::post('edit-resep-racikan', 'App\Http\Controllers\satuSehatController@editResepObatRacikan');
Route::post('update-resep-nonracikan', 'App\Http\Controllers\satuSehatController@updateResepObatNonRacikan');
Route::post('update-resep-racikan', 'App\Http\Controllers\satuSehatController@updateResepObatRacikan');
Route::post('update-status-nonracikan', 'App\Http\Controllers\satuSehatController@updateStatusObatNonRacikan');
Route::post('delete-resep-nonracikan', 'App\Http\Controllers\satuSehatController@deleteResepObatNonRacikan');
Route::post('delete-resep-racikan', 'App\Http\Controllers\satuSehatController@deleteResepObatRacikan');
Route::post('get-resep-obat-final', 'App\Http\Controllers\satuSehatController@getResepObatFinal');
Route::post('insert-resep-nonracikan', 'App\Http\Controllers\satuSehatController@insertResepNonRacikan');
Route::post('insert-resep-racikan', 'App\Http\Controllers\satuSehatController@insertResepRacikan');
Route::post('insert-aturan-racikan', 'App\Http\Controllers\satuSehatController@insertAturanRacikan');
Route::post('update-aturan-racikan', 'App\Http\Controllers\satuSehatController@updateAturanRacikan');
Route::post('insert-tipe-resep', 'App\Http\Controllers\satuSehatController@insertResepType');
Route::post('delete-tipe-resep', 'App\Http\Controllers\satuSehatController@deleteReseptype');

Route::post('insert-soap-pasien', 'App\Http\Controllers\satuSehatController@insertSoapPasien');
Route::post('update-soap-pasien', 'App\Http\Controllers\satuSehatController@updateSoapPasien');
Route::post('get-soap-pasien', 'App\Http\Controllers\satuSehatController@getSoapPasien');
Route::post('delete-soap-pasien', 'App\Http\Controllers\satuSehatController@deleteSoapPasien');


Route::post('insert-tindakan-pasien', 'App\Http\Controllers\satuSehatController@insertTindakanPasien');
Route::post('get-tindakan-pasien', 'App\Http\Controllers\satuSehatController@getTindakanPasien');
Route::post('delete-tindakan-pasien', 'App\Http\Controllers\satuSehatController@deleteTindakanPasien');

Route::post('get-service-order', 'App\Http\Controllers\satuSehatController@selectServiceOrder');
Route::post('insert-service-order', 'App\Http\Controllers\satuSehatController@insertServiceOrder');

Route::post('get-dokter-instruksi', 'App\Http\Controllers\satuSehatController@getDokterInstruksi');
Route::post('insert-kontrol-pasien', 'App\Http\Controllers\satuSehatController@insertKontrolPasien');
Route::post('get-kontrol-pasien', 'App\Http\Controllers\satuSehatController@getKontrolPasien');
Route::post('get-history-kunjungan', 'App\Http\Controllers\satuSehatController@getHistoryKunjungan');
Route::post('get-history-data', 'App\Http\Controllers\satuSehatController@getDatahistory');

Route::post('get-pasien-actual', 'App\Http\Controllers\satuSehatController@getPasienActual');
Route::post('resume-transaksi', 'App\Http\Controllers\satuSehatController@resumeTransaksiByMonth');
Route::post('resume-transaksi-day', 'App\Http\Controllers\satuSehatController@resumeTransaksiByDay');
Route::post('resume-transaksi-day-admin', 'App\Http\Controllers\satuSehatController@resumeTransaksiByDayAdmin');
Route::post('resume-transaksi-month-admin', 'App\Http\Controllers\satuSehatController@resumeTransaksiByMonthAdmin');
Route::post('get-resume-transaksis', 'App\Http\Controllers\satuSehatController@resumeTransaksi');
Route::post('update-status-jadwal', 'App\Http\Controllers\satuSehatController@updateStatusJadwal');

Route::post('get-jadwal-poli', 'App\Http\Controllers\satuSehatController@getDaftarJadwal');
Route::post('edit-jadwal-poli', 'App\Http\Controllers\satuSehatController@editDaftarJadwal');
Route::post('update-jadwal-poli', 'App\Http\Controllers\satuSehatController@updateJadwalPoli');
Route::post('update-status-pemeriksaan-fisik', 'App\Http\Controllers\satuSehatController@updateStatusPemeriksaanFisik');
Route::post('get-daftar-pasien-reservasi', 'App\Http\Controllers\satuSehatController@getPasienReservasi');
Route::post('get-jadwal-dokter-reservasi', 'App\Http\Controllers\satuSehatController@getDokterReservasi');
Route::post('checkin-reservasi', 'App\Http\Controllers\satuSehatController@checkin');
Route::post('insert-reservasi-pasien', 'App\Http\Controllers\satuSehatController@insertReservasiPasien');
Route::post('count-reservasi-pasien', 'App\Http\Controllers\satuSehatController@countReservasi');
Route::post('get-poli', 'App\Http\Controllers\satuSehatController@getPoli');
Route::post('get-poli-reservasi', 'App\Http\Controllers\satuSehatController@getPoliReservasi');
Route::post('get-poli-reservasi-dokter', 'App\Http\Controllers\satuSehatController@getPoliReservasiDokter');


Route::post('get-pasien-panggil', 'App\Http\Controllers\satuSehatController@getPasienPanggil');
//Route::post('update-status-jadwal', 'App\Http\Controllers\serviceController@updateStatusJadwalPoli');
Route::post('get-data-dokter-poli', 'App\Http\Controllers\serviceController@getDataDokterPoli');
Route::post('get-data-dokter', 'App\Http\Controllers\serviceController@showDataDokter');
Route::post('get-data-perujuk', 'App\Http\Controllers\serviceController@showDataPerujuk');
Route::post('get-data-pasien', 'App\Http\Controllers\serviceController@showDataPasien');
Route::post('get-data-pasien-display', 'App\Http\Controllers\serviceController@showDataPasienDisplay');
Route::post('get-data-tindakan', 'App\Http\Controllers\serviceController@getDataTindakan');
Route::post('get-detail-tindakan', 'App\Http\Controllers\serviceController@getDetailTindakan');
Route::post('get-data-obat', 'App\Http\Controllers\serviceController@getDataObat');
Route::post('get-detail-obat', 'App\Http\Controllers\serviceController@getDetailObat');
Route::post('get-data-penyakit', 'App\Http\Controllers\serviceController@getDataPenyakit');
Route::post('get-detail-penyakit', 'App\Http\Controllers\serviceController@getDetailPenyakit');
Route::post('count-registered', 'App\Http\Controllers\serviceController@counting');
Route::post('save-register', 'App\Http\Controllers\serviceController@storeRegister');
Route::post('save-register-poli', 'App\Http\Controllers\serviceController@storeFormPoli');
Route::post('save-register-lab', 'App\Http\Controllers\serviceController@storeRegisterLab');
Route::post('save-register-radiologi', 'App\Http\Controllers\serviceController@storeRegisterRad');
Route::post('save-pendaftaran-radiologi', 'App\Http\Controllers\serviceController@storeFormRad');
Route::post('update-anamnesa', 'App\Http\Controllers\serviceController@updateAnamnesa');
Route::post('get-data-anamnesa', 'App\Http\Controllers\serviceController@getDataAnamnesa');



Route::post('update-konfirmasi', 'App\Http\Controllers\serviceController@updateKonfirmasi');

Route::post('insert-dokter-perujuk', 'App\Http\Controllers\serviceController@storeDataPerujuk');
Route::post('insert-transaksi-tindakan', 'App\Http\Controllers\serviceController@storeTransaksiTindakan');
Route::post('insert-transaksi-obat', 'App\Http\Controllers\serviceController@storeTransaksiObat');
Route::post('insert-transaksi-penyakit', 'App\Http\Controllers\serviceController@storeTransaksiPenyakit');
Route::post('insert-master-penyakit', 'App\Http\Controllers\serviceController@storeMasterPenyakit');
Route::post('insert-master-obat', 'App\Http\Controllers\serviceController@storeMasterObat');
Route::post('insert-master-tindakan', 'App\Http\Controllers\serviceController@storeMasterTindakan');
Route::post('get-data-transaksi', 'App\Http\Controllers\serviceController@getDataTransaksi');
Route::post('get-data-transaksi-pasien', 'App\Http\Controllers\serviceController@getDataTransaksiPasien');

Route::post('get-data-transaksi-frontLab', 'App\Http\Controllers\serviceController@getDataTransaksiFrontLab');
Route::post('get-data-transaksi-lab', 'App\Http\Controllers\serviceController@getDataTransaksiLab');
Route::post('get-data-transaksi-penyakit', 'App\Http\Controllers\serviceController@getDataTransaksiPenyakit');
Route::post('get-data-rm', 'App\Http\Controllers\serviceController@getRekamMedis');
Route::post('get-nomor-rm', 'App\Http\Controllers\serviceController@getNomorRm');
Route::post('get-last-antrian', 'App\Http\Controllers\serviceController@getLastAntrian');

Route::post('delete-transaksi-penyakit', 'App\Http\Controllers\serviceController@deleteTransaksiPenyakit');
Route::post('get-transaksi-dokter', 'App\Http\Controllers\serviceController@getTransaksiDokter');
Route::post('get-transaksi-dokter-kirim', 'App\Http\Controllers\serviceController@getTransaksiDokterKirim');
Route::post('get-transaksi-all', 'App\Http\Controllers\serviceController@getTransaksiAll');
Route::post('get-transaksi-alll', 'App\Http\Controllers\serviceController@getTransaksiAlll');
Route::post('get-transaksi-dokter-perMonth', 'App\Http\Controllers\serviceController@getTransaksiDokterPerMonth');
Route::post('get-transaksi-khusus', 'App\Http\Controllers\serviceController@getTransaksiAllkhusus');
Route::post('get-jam-praktek', 'App\Http\Controllers\serviceController@getJamPraktek');
Route::post('get-resume-transaksi', 'App\Http\Controllers\serviceController@resumeTransaksi');
Route::post('get-stock-kartu', 'App\Http\Controllers\serviceController@getStockKartu');
Route::post('get-jadwal-radiologi', 'App\Http\Controllers\serviceController@getJadwalRad');
Route::post('select-pasien', 'App\Http\Controllers\serviceController@selectDataPasien');
Route::post('select-penyakit', 'App\Http\Controllers\serviceController@selectDataPenyakit');
Route::post('data-pasien-datatable','App\Http\Controllers\serviceController@ss_processing');
Route::post('count-transaksi','App\Http\Controllers\serviceController@countTransaksiPasien');
Route::post('durasi-praktek','App\Http\Controllers\serviceController@getDurasiPraktek');
////////////////////ROUTE FOR LABORATORIUM////////////////////
//Laboratorium
Route::post('save-jadwal-lab','App\Http\Controllers\LaboratoriumController@storeJadwalLab');
Route::post('update-status-lab', 'App\Http\Controllers\LaboratoriumController@updateStatusLab');
Route::post('get-data-pasien-lab', 'App\Http\Controllers\LaboratoriumController@showDataPasienLab');
Route::post('insert-transaksi-lab', 'App\Http\Controllers\LaboratoriumController@storeTransaksiLab');
Route::post('delete-transaksi-lab', 'App\Http\Controllers\LaboratoriumController@deleteTransaksiLab');
Route::post('delete-hasil-lab', 'App\Http\Controllers\LaboratoriumController@deleteHasilLab');
Route::post('get-data-lab', 'App\Http\Controllers\LaboratoriumController@getDataLab');
Route::post('get-detail-lab', 'App\Http\Controllers\LaboratoriumController@getDetailLab');
Route::post('get-jadwal-lab', 'App\Http\Controllers\LaboratoriumController@getJadwalLab');
Route::post('save-pendaftaran-lab', 'App\Http\Controllers\LaboratoriumController@storeFormLab');
Route::post('get-data-orderan-lab', 'App\Http\Controllers\LaboratoriumController@getOrderan');
Route::post('get-data-pemeriksaan-lab', 'App\Http\Controllers\LaboratoriumController@getDataPemeriksaanLab');
Route::post('get-detail-pemeriksaan-lab', 'App\Http\Controllers\LaboratoriumController@getDetailPemeriksaanLab');
Route::post('insert-hasil-pemeriksaan-lab', 'App\Http\Controllers\LaboratoriumController@insertHasilPemeriksaanLab');
Route::post('get-data-hasil-pemeriksaan-lab', 'App\Http\Controllers\LaboratoriumController@getDatahasilLab');
Route::post('cetak-hasil-lab', 'App\Http\Controllers\LaboratoriumController@getHasilLab');
Route::post('get-kategori-lab', 'App\Http\Controllers\LaboratoriumController@getDataKategoriLab');
Route::post('get-item-lab', 'App\Http\Controllers\LaboratoriumController@getDataItemLab');
Route::post('get-detail-item-lab', 'App\Http\Controllers\LaboratoriumController@getDetailItemLab');
Route::post('get-subitem-lab', 'App\Http\Controllers\LaboratoriumController@getDataSubItemLab');
Route::post('get-detail-subitem-lab', 'App\Http\Controllers\LaboratoriumController@getDetailSubItemLab');
Route::post('get-sub2item-lab', 'App\Http\Controllers\LaboratoriumController@getDataSub2ItemLab');
Route::post('get-detail-sub2item-lab', 'App\Http\Controllers\LaboratoriumController@getDetailSub2ItemLab');
Route::post('insert-item-lab', 'App\Http\Controllers\LaboratoriumController@insertItemLab');
Route::post('insert-subitem-lab', 'App\Http\Controllers\LaboratoriumController@insertSubItemLab');
Route::post('insert-sub2item-lab', 'App\Http\Controllers\LaboratoriumController@insertSub2ItemLab');
Route::post('get-data-label', 'App\Http\Controllers\LaboratoriumController@getDataLabel');

Route::post('get-data-delete', 'App\Http\Controllers\LaboratoriumController@getDataDelete');

////////////////////ROUTE FOR POLI////////////////////
//Halaman Home 
Route::post('get-jadwal-dokter', 'App\Http\Controllers\poliController@getJadwalDokter');
Route::post('get-daftar-pasien-poli', 'App\Http\Controllers\poliController@getDaftarPasien');
Route::post('count-pasien-register-poli', 'App\Http\Controllers\poliController@countPasienRegister');
Route::post('count-pasien-servings-poli', 'App\Http\Controllers\poliController@countPasienDilayani');
Route::post('count-pasien-served-poli', 'App\Http\Controllers\poliController@countPasienSudahDilayani');
Route::post('count-stock-kartu', 'App\Http\Controllers\poliController@countStockKartu');
Route::post('update-status', 'App\Http\Controllers\poliController@updateStatus');
//Halaman Data Pasien 
Route::post('get-pasien-datatable_poli','App\Http\Controllers\datatablePasienController@ss_processing_pasien');
//Halaman Transaksi Front Office
Route::post('get-data-transaksi-front-invoice', 'App\Http\Controllers\transaksiController@getDataTransaksiFrontInvoice');
Route::post('get-data-pasien-transaksi', 'App\Http\Controllers\transaksiController@getDataPasienTransaksi');
Route::post('get-data-total-transaksi', 'App\Http\Controllers\transaksiController@getDataTotalTransaksi');
Route::post('get-data-transaksi-front', 'App\Http\Controllers\transaksiController@getDataTransaksiFront');
Route::post('get-detail-transaksi-front', 'App\Http\Controllers\transaksiController@getDetailTransaksi');
Route::post('insert-transaksi', 'App\Http\Controllers\transaksiController@storeTransaksi');
Route::post('insert-transaksi-pendaftaran', 'App\Http\Controllers\transaksiController@storeTransaksiPendaftaran');
Route::post('update-status-pembayaran', 'App\Http\Controllers\transaksiController@updateStatusPembayaran');
Route::post('delete-transaksi', 'App\Http\Controllers\transaksiController@deleteTransaksi');
Route::post('get-data-transaksi-revisi', 'App\Http\Controllers\transaksiController@getDataRevisiTransaksi');
Route::post('get-item-transaksi-revisi', 'App\Http\Controllers\transaksiController@getItemRevisiTransaksi');
Route::post('update-revisi-transaksi', 'App\Http\Controllers\transaksiController@updateRevisiTransaksi');
Route::post('request-revisi-transaksi', 'App\Http\Controllers\transaksiController@updateReqRevisiTransaksi');
//Halaman buat jadwal poli
Route::post('save-jadwal','App\Http\Controllers\poliController@storeJadwalDokter');

////////////////////ROUTE FOR ADMIN////////////////////
//Halaman buat master kategori lab
Route::post('get-master-kategori-lab', 'App\Http\Controllers\adminController@getMasterKategoriLabSSProcessing');
Route::post('get-master-kategori-modal', 'App\Http\Controllers\adminController@getMasterKategoriLab');
Route::post('delete-master-kategori-lab', 'App\Http\Controllers\adminController@deleteMasterKategoriLab');
Route::post('update-master-kategori-lab', 'App\Http\Controllers\adminController@updateMasterKategoriLab');
Route::post('insert-master-kategori-lab', 'App\Http\Controllers\adminController@insertMasterKategoriLab');
//Halaman buat master kategori lab
Route::post('get-master-item-lab', 'App\Http\Controllers\adminController@getMasterItemLabSSProcessing');
Route::post('insert-master-item-lab', 'App\Http\Controllers\adminController@insertMasterItemLab');
Route::post('update-master-item-lab', 'App\Http\Controllers\adminController@updateMasterItemLab');
Route::post('delete-master-item-lab', 'App\Http\Controllers\adminController@deleteMasterItemLab');
Route::post('get-master-item-modal', 'App\Http\Controllers\adminController@getMasterItemLab');
Route::post('get-kategori-item-value', 'App\Http\Controllers\adminController@getDataKategoriValue');
//Halaman buat master sub kategori lab
Route::post('get-master-subitem-lab', 'App\Http\Controllers\adminController@getMasterSubItemLabSSProcessing');
Route::post('get-item-lab-value', 'App\Http\Controllers\adminController@getDataItemLabValue');
Route::post('get-item-lab-value-edit', 'App\Http\Controllers\adminController@getDataItemLabValueEdit');
Route::post('get-master-subitem-modal', 'App\Http\Controllers\adminController@getMasterSubItemLab');
Route::post('insert-master-subitem-lab', 'App\Http\Controllers\adminController@insertMasterSubItemLab');
Route::post('update-master-subitem-lab', 'App\Http\Controllers\adminController@updateMasterSubItemLab');
Route::post('delete-master-subitem-lab', 'App\Http\Controllers\adminController@deleteMasterSubItemLab');
//Halaman buat master sub 2 kategori lab
Route::post('get-master-sub2item-lab', 'App\Http\Controllers\adminController@getMasterSub2ItemLabSSProcessing');
Route::post('get-subitem-lab-value', 'App\Http\Controllers\adminController@getDataSubItemLabValue');
Route::post('insert-master-sub2item-lab', 'App\Http\Controllers\adminController@insertMasterSub2ItemLab');
Route::post('get-subitem-lab-value-edit', 'App\Http\Controllers\adminController@getDataSub2ItemLabValueEdit');
Route::post('get-master-sub2item-modal', 'App\Http\Controllers\adminController@getMasterSub2ItemLab');
Route::post('update-master-sub2item-lab', 'App\Http\Controllers\adminController@updateMasterSub2ItemLab');
Route::post('delete-master-sub2item-lab', 'App\Http\Controllers\adminController@deleteMasterSub2ItemLab');
//Halaman buat edit profil
Route::post('data-pasien-admin','App\Http\Controllers\adminController@ss_processingAdmin');
Route::post('get-pasien-modal', 'App\Http\Controllers\adminController@getDataPasienModal');
Route::post('update-pasien-data', 'App\Http\Controllers\adminController@updatePasienData');
Route::post('update-kartu-data', 'App\Http\Controllers\adminController@updateKartuData');
////////////////////ROUTE FOR DOKTER////////////////////
//Rekam Medis
Route::post('get-rekam-medis', 'App\Http\Controllers\rekamMedisController@getRekamMedis');
Route::post('get-pasien-rm', 'App\Http\Controllers\rekamMedisController@getdataPasienRm');


//Route Halaman Register
Route::post('register', 'UserController@register');

// Route Halaman Login
Route::post('login', 'App\Http\Controllers\loginController@login');

//Route Halaman Profil
Route::post('get-data-siswa', 'DataSiswaController@getDataSiswa')->middleware('jwt.verify');

//Route get NIK
Route::post('extract-nik', 'App\Http\Controllers\HomeController@checkNIN');

//contoh
Route::post('get-jadwal-peserta', 'JadwalPesertaController@getJadwalPeserta')->middleware('jwt.verify');
Route::get('bookall', 'App\Http\Controllers\serviceController@bookAuth')->middleware('jwt.verify');
Route::get('user', 'UserController@getAuthenticatedUser')->middleware('jwt.verify');
