<?php

namespace App\Http\Controllers;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\hasilPemeriksaanLab;
use App\Models\nilaiHasilLab;
use App\Models\nilaiItemLab;
use App\Models\nilaiSubItemLab;
use App\Models\nilaiSub2ItemLab;
use App\Models\antrianLab;
use App\Models\Registrasi;
use App\Models\transaksiLab;
use App\Models\jadwalLab;

class LaboratoriumController extends Controller
{
	 public function storeJadwalLab(Request $request) {
			DB::begintransaction();
			try {
				//Data jadwal
				$jadwal = new jadwalLab;
				$jadwal->id_dokter = $request->id_dokter;
				$jadwal->jam_buka = $request->jam_buka;
				$jadwal->jam_tutup = $request->jam_tutup;
				$jadwal->tanggal = $request->tanggal;
				
				if (!$jadwal->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data jadwal'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $jadwal
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data jadwal ke database. Memuat ulang halaman...',
                    'jadwal' => $jadwal
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function getDataLabel(Request $request) {
		$dataPasien = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->join('jadwal_lab', 'jadwal_lab.id_jadwal_lab', '=', 'data_antrian_lab.id_jadwal_lab')
			->select('data_pasien.nama_pasien','data_pasien.nomer_rm','data_pasien.nomer_lab','data_pasien.tanggal_lahir','data_antrian_lab.no_antrian','data_antrian_lab.id_antrian_lab','data_antrian_lab.status','data_antrian_lab.confirmed')
			->where('data_antrian_lab.id_antrian_lab', '=', $request->id_antrian_lab)
			->get();
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataPasien,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function updateStatusLab(Request $request) {
			DB::begintransaction();
			try {
				$status = antrianLab::find($request->id_antrian_lab);
				$status->status = $request->status;
				if (!$status->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'status' => $status->status,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
	
	public function showDataPasienLab() {
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->join('jadwal_lab', 'jadwal_lab.id_jadwal_lab', '=', 'data_antrian_lab.id_jadwal_lab')
			->select('data_pasien.nama_pasien','data_antrian_lab.no_antrian','data_antrian_lab.id_antrian_lab','data_antrian_lab.status','data_antrian_lab.confirmed')
			->where('jadwal_lab.tanggal', '=', DB::raw('curdate()'))
			->orderBy('data_antrian_lab.id_antrian_lab','asc')
			->get();
			$dataPasienPanggil = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->join('jadwal_lab', 'jadwal_lab.id_jadwal_lab', '=', 'data_antrian_lab.id_jadwal_lab')
			->select('data_pasien.nama_pasien','data_pasien.pekerjaan','data_pasien.jenis_kelamin','data_pasien.tanggal_lahir','data_antrian_lab.no_antrian','data_antrian_lab.id_antrian_lab','data_antrian_lab.status','data_antrian_lab.confirmed')
			->where('jadwal_lab.tanggal', '=', DB::raw('curdate()'))
			->where('data_antrian_lab.status', '=', 3)
			->orderBy('data_antrian_lab.id_antrian_lab','asc')
			->get();
			$dataTransaksi = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->join('data_transaksi_lab', 'data_antrian_lab.id_antrian_lab', '=', 'data_transaksi_lab.id_antrian_lab')
			->join('jadwal_lab', 'jadwal_lab.id_jadwal_lab', '=', 'data_antrian_lab.id_jadwal_lab')
			->select('data_transaksi_lab.transaksi','data_antrian_lab.id_antrian_lab')
			->where('jadwal_lab.tanggal', '=', DB::raw('curdate()'))
			->where('data_antrian_lab.status', '=', 3)
			->orderBy('data_antrian_lab.id_antrian_lab','asc')
			->get();
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataPasien,
				'dataTransaksi' =>  $dataTransaksi,
				'dataPasienPanggil' =>  $dataPasienPanggil
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function getDataLab() {
			$dataLab = DB::table('m_item_lab')
			->select('id_item_lab','item_lab')
			->get();
			if ($dataLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDetailLab(Request $request) {
			$detailLab = DB::table('m_item_lab')
			->select('id_item_lab','item_lab','harga_item_lab')
			->where('id_item_lab', '=', $request->id_item_lab)
			->get();
			if ($detailLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $detailLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function storeTransaksiLab(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				$transaksi = new transaksiLab;
				$transaksi->id_antrian_lab = $request->id_antrian_lab;
				$transaksi->transaksi = $request->transaksi;
				$biaya = $request->biaya;
				$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
				$diskon = $request->diskon;
				$nominalDiskon = $biayaReplace * ($diskon / 100);
				$transaksi->diskon = $nominalDiskon;
				$finalDiskon = $biayaReplace - $nominalDiskon;
				$transaksi->nominal = $finalDiskon;
				$transaksi->jenis_pembayaran = $request->jenis_pembayaran;
				
				if (!$transaksi->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $transaksi
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $transaksi
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function deleteTransaksiLab(Request $request) {
			DB::begintransaction();
			try {
				$delete = transaksiLab::find($request->id_trx_lab);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
	public function getDataDelete(Request $request) {
			$detailLab = DB::table('nilai_hasil_lab')
				->join('nilai_item', 'nilai_hasil_lab.id_hasil_lab', '=', 'nilai_item.id_hasil_lab')
				->join('nilai_subitem', 'nilai_item.id_nilai_item', '=', 'nilai_item.id_nilai_item')
				->join('nilai_sub2item', 'nilai_subitem.id_nilai_subitem', '=', 'nilai_sub2item.id_nilai_subitem')
				->select('nilai_item.id_hasil_lab','nilai_item.id_nilai_item','nilai_subitem.id_nilai_subitem','nilai_sub2item.id_nilai_sub2item')
				->where('nilai_hasil_lab.id_hasil_lab', '=', $request->idHasilLab)
				->first();
			if ($detailLab) {
				return [
                'message' => 'Berhasil Mengambil Datata',
                'status' => 1,
                'data' =>  $detailLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function deleteHasilLab(Request $request) {
	
		
		DB::begintransaction();
			try {
				$getHasil = DB::table('nilai_hasil_lab')
				->join('nilai_item', 'nilai_hasil_lab.id_hasil_lab', '=', 'nilai_item.id_hasil_lab')
				->join('nilai_subitem', 'nilai_item.id_nilai_item', '=', 'nilai_item.id_nilai_item')
				->join('nilai_sub2item', 'nilai_subitem.id_nilai_subitem', '=', 'nilai_sub2item.id_nilai_subitem')
				->select('nilai_hasil_lab.id_hasil_lab','nilai_item.id_nilai_item','nilai_subitem.id_nilai_subitem','nilai_sub2item.id_nilai_sub2item')
				->where('nilai_hasil_lab.id_hasil_lab', '=', $request->idHasilLab)
				->get();
				foreach ($getHasil as $key => $id){
					$idHasilLab = $id->id_hasil_lab;
					$idNilaiItem = $id->id_nilai_item;
					$idNilaiSubItem = $id->id_nilai_subitem;
					DB::table('nilai_hasil_lab')->where('id_hasil_lab', $idHasilLab)->delete();
					DB::table('nilai_item')->where('id_nilai_item', $idNilaiItem)->delete();
					DB::table('nilai_subitem')->where('id_nilai_item', $idNilaiItem)->delete();
					DB::table('nilai_sub2item')->where('id_nilai_subitem', $idNilaiSubItem)->delete();
				}
				
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
	}
	
	public function getJadwalLab() {
			$getJadwal = DB::table('jadwal_lab')
				->select('id_jadwal_lab')
				->where('jadwal_lab.tanggal', '=', DB::raw('curdate()'))
				->first();
			
			if ($getJadwal) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $getJadwal,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function storeFormLab(Request $request) {
		DB::begintransaction();
			try {
				//$currDate = currdate();
				$countAntrian = DB::table('data_antrian_lab')
				->join('jadwal_lab', 'jadwal_lab.id_jadwal_lab', '=', 'data_antrian_lab.id_jadwal_lab')
				->select('id_antrian_lab')
				->where('jadwal_lab.tanggal', '=', DB::raw('curdate()'))
				->where('jadwal_lab.id_jadwal_lab', '=', $request->id_jadwal_lab)
				->count();
				$generateAntrian = $countAntrian+1 ;
				$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
				//Data Antrian
				$antrian = new antrianLab;
				$antrian->id_jadwal_lab = $request->id_jadwal_lab;
				$antrian->id_pasien = $request->id_pasien;
				$antrian->no_antrian = $nomerAntrian;
				$antrian->perujuk = $request->getDataDokter2_div;
				
				if (!$antrian->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Antrian'
					];
				}
				$idAntrianLab = DB::table('data_antrian_lab')->max('id_antrian_lab');
				$cekIdLab = DB::table('data_pasien')
				->where('id_pasien', '=', $request->id_pasien)
				->select('nomer_lab','id_pasien')
				->first();
				$idLaborat = $cekIdLab->nomer_lab;
				//$idPasien = $request->id_pasien;
				
				$countIdLab = DB::table('data_pasien')
				->max('nomer_lab');
				$generateIdLab = $countIdLab+1 ;
				$nomerIdLab = str_pad($generateIdLab,3,'0',STR_PAD_LEFT);
				
				if($idLaborat == 0){
				$idLab = Registrasi::find($request->id_pasien);
				$idLab->nomer_lab = $nomerIdLab;
				$idLab->save();
				}
				
				$postKirim = array(
				"client_id" => "01631",
				"data" => $antrian
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
					'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
					'antrian' => $nomerAntrian,
					'idAntrianLab' => $idAntrianLab
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
	
    public function getDataPemeriksaanLab() {
		$dataPemeriksaanLab = DB::table('m_pemeriksaan_lab')
		->select('id_pl','nama_pemeriksaan')
		->get();
		if ($dataPemeriksaanLab) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $dataPemeriksaanLab
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
		
	public function insertHasilPemeriksaanLab(Request $request) {
			DB::begintransaction();
			try {
				//Data hasilPemeriksaanLab
				$hasilPemeriksaanLab = new hasilPemeriksaanLab;
				$hasilPemeriksaanLab->id_pl = $request->id_pl;
				$hasilPemeriksaanLab->id_pasien = $request->id_pasien;
				$hasilPemeriksaanLab->nilai = $request->nilai;
				$hasilPemeriksaanLab->keterangan = $request->keterangan;
				
				if (!$hasilPemeriksaanLab->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data hasilPemeriksaanLab'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $hasilPemeriksaanLab
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data hasilPemeriksaanLab ke database. Memuat ulang halaman...',
                    'hasilPemeriksaanLab' => $hasilPemeriksaanLab
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function getDatahasilLab(Request $request) {
			
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->select('data_pasien.nama_pasien','data_pasien.tanggal_lahir','data_pasien.jenis_kelamin','data_pasien.nomer_rm','data_pasien.alamat_sekarang','data_pasien.no_telp','data_pasien.nomer_lab','data_antrian_lab.perujuk')
			->where('data_antrian_lab.id_antrian_lab', '=', $request->id_antrian_lab)
			->get();
			
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'pasien' =>  $dataPasien,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getHasilLab (Request $request){
			$pasien = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->join('nilai_hasil_lab', 'data_antrian_lab.id_antrian_lab', '=', 'data_antrian_lab.id_antrian_lab')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian_lab.id_antrian_lab','nilai_hasil_lab.id_hasil_lab','nilai_hasil_lab.kategori_lab')
			->where('data_antrian_lab.id_antrian_lab', '=', $request->id_antrian_lab)
			//->groupBy('data_pasien.id_pasien')
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$pasien_name = $ch->nama_pasien;
				$pasien_id = $ch->id_pasien;
				$kategoriLab = $ch->kategori_lab;
				$id_antrian = $ch->id_antrian_lab;
				$hasilLab_id = $ch->id_hasil_lab;
				$nilaiHasilLab = DB::table('nilai_item')
					->join('nilai_hasil_lab', 'nilai_hasil_lab.id_hasil_lab', '=', 'nilai_item.id_hasil_lab')
					->select('nilai_item.id_nilai_item','nilai_item.item_pemeriksaan','nilai_item.hasil_item','nilai_item.nilai_rujukan_item','nilai_item.satuan_item','nilai_item.keterangan_item')
					->where('nilai_item.id_hasil_lab', '=', $hasilLab_id)
					->get();
				$childs_id=[];
				foreach ($nilaiHasilLab as $keys => $chs){
					$itemPemeriksaan = $chs->item_pemeriksaan;
					$hasilItem = $chs->hasil_item;
					$nilaiRujukanItem = $chs->nilai_rujukan_item;
					$satuanItem = $chs->satuan_item;
					$keteranganItem = $chs->keterangan_item;
					$idNilaiItem = $chs->id_nilai_item;
					$nilaiSubHasilLab = DB::table('nilai_subitem')
					->join('nilai_item', 'nilai_item.id_nilai_item', '=', 'nilai_subitem.id_nilai_item')
					->select('nilai_subitem.id_nilai_subitem','nilai_subitem.subitem_pemeriksaan','nilai_subitem.hasil_subitem','nilai_subitem.nilai_rujukan_subitem','nilai_subitem.satuan_subitem','nilai_subitem.keterangan_subitem')
					->where('nilai_subitem.id_nilai_item', '=', $idNilaiItem)
					->get();
					$childss_id=[];
					foreach ($nilaiSubHasilLab as $keys => $chss){
						$subItemPemeriksaan = $chss->subitem_pemeriksaan;
						$hasilSubItem = $chss->hasil_subitem;
						$nilaiRujukanSubItem = $chss->nilai_rujukan_subitem;
						$satuanSubItem = $chss->satuan_subitem;
						$keteranganSubItem = $chss->keterangan_subitem;
						$idNilaiSubItem = $chss->id_nilai_subitem;
						$nilaiSub2HasilLab = DB::table('nilai_sub2item')
						->join('nilai_subitem', 'nilai_subitem.id_nilai_subitem', '=', 'nilai_sub2item.id_nilai_subitem')
						->select('nilai_sub2item.id_nilai_sub2item','nilai_sub2item.sub2item_pemeriksaan','nilai_sub2item.hasil_sub2item','nilai_sub2item.nilai_rujukan_sub2item','nilai_sub2item.satuan_sub2item','nilai_sub2item.keterangan_sub2item')
						->where('nilai_sub2item.id_nilai_subitem', '=', $idNilaiSubItem)
						->get();
						$childsss_id=[];
						foreach ($nilaiSub2HasilLab as $keys => $chsss){
							$sub2ItemPemeriksaan = $chsss->sub2item_pemeriksaan;
							$hasilSub2Item = $chsss->hasil_sub2item;
							$nilaiRujukanSub2Item = $chsss->nilai_rujukan_sub2item;
							$satuanSub2Item = $chsss->satuan_sub2item;
							$keteranganSub2Item = $chsss->keterangan_sub2item;
							$idNilaiSub2Item = $chsss->id_nilai_sub2item;
							
							$childsss_id[$keys] =[
							'Sub2ItemPeriksa'=>$sub2ItemPemeriksaan,
							'hasilSub2Item'=>$hasilSub2Item,
							'nilaiRujukanSub2Item'=>$nilaiRujukanSub2Item,
							'satuanSub2Item'=>$satuanSub2Item,
							'keteranganSub2Item'=>$keteranganSub2Item,
							]; 
						}
						$childss_id[$keys] =[
						'SubItemPeriksa'=>$subItemPemeriksaan,
						'hasilSubItem'=>$hasilSubItem,
						'nilaiRujukanSubItem'=>$nilaiRujukanSubItem,
						'satuanSubItem'=>$satuanSubItem,
						'keteranganSubItem'=>$keteranganSubItem,
						'sub2Nilai'=>$childsss_id,
						]; 
					}
					$childs_id[$keys] =[
					'itemPeriksa'=>$itemPemeriksaan,
					'hasilItem'=>$hasilItem,
					'nilaiRujukanItem'=>$nilaiRujukanItem,
					'satuanItem'=>$satuanItem,
					'keteranganItem'=>$keteranganItem,
					'subNilai'=>$childss_id,
					]; 
				}
				$child_id[$key] =[
				'kategori'=>$kategoriLab,
				'idHasilLab'=>$hasilLab_id,
				'nilai'=>$childs_id,
				];
			}
		if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'pasien' =>  $pasien,
				'data' => $child_id
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}	
	}
	
	public function getOrderan(Request $request) {
			
			$orderanLab = DB::table('data_transaksi_lab')
			->where('data_transaksi_lab.id_antrian_lab', '=', $request->id_antrian_lab)
			->get();
			if ($orderanLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $orderanLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function getDataKategoriLab(Request $request) {
			
			$kategoriLab = DB::table('m_kategori_lab')
			->get();
			if ($kategoriLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $kategoriLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDataItemLab(Request $request) {
			
			$itemLab = DB::table('m_item_lab')
			->where('m_item_lab.id_kategori_lab', '=', $request->id_kategori_lab)
			->get();
			if ($itemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $itemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDetailItemLab(Request $request) {
			$detailItemLab = DB::table('m_item_lab')
			->join('m_kategori_lab', 'm_kategori_lab.id_kategori_lab', '=', 'm_item_lab.id_kategori_lab')
			->where('id_item_lab', '=', $request->id_item_lab)
			->get();
			if ($detailItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $detailItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDataSubItemLab(Request $request) {
			
			$SubItemLab = DB::table('m_subitem_lab')
			->where('m_subitem_lab.id_item_lab', '=', $request->id_item_lab)
			->get();
			if ($SubItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'data' =>  $SubItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDetailSubItemLab(Request $request) {
			$detailSubItemLab = DB::table('m_subitem_lab')
			->where('id_sub_item', '=', $request->id_sub_item)
			->get();
			if ($detailSubItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $detailSubItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDataSub2ItemLab(Request $request) {
		
		$Sub2ItemLab = DB::table('m_sub2item_lab')
		->where('m_sub2item_lab.id_sub_item', '=', $request->id_sub_item)
		->get();
		if ($Sub2ItemLab) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $Sub2ItemLab
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function getDetailSub2ItemLab(Request $request) {
			$detailSub2ItemLab = DB::table('m_sub2item_lab')
			->where('id_sub2_item_lab', '=', $request->id_sub2_item_lab)
			->get();
			if ($detailSub2ItemLab) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $detailSub2ItemLab
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function insertItemLab(Request $request) {
			DB::begintransaction();
			try { 
				//Data hasilPemeriksaanLab
				$hasilPemeriksaanLab = new hasilPemeriksaanLab;
				$hasilPemeriksaanLab->id_antrian_lab = $request->id_antrian_lab;
				$hasilPemeriksaanLab->kategori_lab = $request->kategori_lab;
				if (!$hasilPemeriksaanLab->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data hasilPemeriksaanLab'
					];
				}
				$id = DB::table('nilai_hasil_lab')->max('id_hasil_lab');
				$nilaiItemLab = new nilaiItemLab;
				$nilaiItemLab->id_hasil_lab = $id;
				$nilaiItemLab->item_pemeriksaan = $request->item_pemeriksaan;
				$nilaiItemLab->hasil_item = $request->hasil_item;
				$nilaiItemLab->nilai_rujukan_item = $request->nilai_rujukan_item;
				$nilaiItemLab->satuan_item = $request->satuan_item;
				$nilaiItemLab->keterangan_item = $request->keterangan_item;
				$idNilaiItem = DB::table('nilai_item')->max('id_nilai_item');
				if (!$nilaiItemLab->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data hasilPemeriksaanLab'
					];
				}
				
				$postKirim = array(
                "data" => $hasilPemeriksaanLab
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data hasilPemeriksaanLab ke database. Memuat ulang halaman...',
                    'hasilPemeriksaanLab' => $hasilPemeriksaanLab,
					'idNilaiItem' => $idNilaiItem
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
	
	public function insertSubItemLab(Request $request) {
			DB::begintransaction();
			try { 
				$nilaiSubItemLab = new nilaiSubItemLab;
				$nilaiSubItemLab->id_nilai_item = $request->id_nilai_item;
				$nilaiSubItemLab->subitem_pemeriksaan = $request->subitem_pemeriksaan;
				$nilaiSubItemLab->hasil_subitem = $request->hasil_subitem;
				$nilaiSubItemLab->nilai_rujukan_subitem = $request->nilai_rujukan_subitem;
				$nilaiSubItemLab->satuan_subitem = $request->satuan_subitem;
				$nilaiSubItemLab->keterangan_subitem = $request->keterangan_subitem;
				$idNilaiSubItem = DB::table('nilai_subitem')->max('id_nilai_subitem');
				if (!$nilaiSubItemLab->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data nilaiSubItemLab'
					];
				}
				
				$postKirim = array(
                "data" => $nilaiSubItemLab
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data hasilPemeriksaanLab ke database. Memuat ulang halaman...',
                    'nilaiSubItemLab' => $nilaiSubItemLab,
					'idNilaiSubItem' => $idNilaiSubItem
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
	public function insertSub2ItemLab(Request $request) {
			DB::begintransaction();
			try { 
				$nilaiSub2ItemLab = new nilaiSub2ItemLab;
				$nilaiSub2ItemLab->id_nilai_subitem = $request->id_nilai_subitem;
				$nilaiSub2ItemLab->sub2item_pemeriksaan = $request->sub2item_pemeriksaan;
				$nilaiSub2ItemLab->hasil_sub2item = $request->hasil_sub2item;
				$nilaiSub2ItemLab->nilai_rujukan_sub2item = $request->nilai_rujukan_sub2item;
				$nilaiSub2ItemLab->satuan_sub2item = $request->satuan_sub2item;
				$nilaiSub2ItemLab->keterangan_sub2item = $request->keterangan_sub2item;
				if (!$nilaiSub2ItemLab->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data nilaiSub2ItemLab'
					];
				}
				
				$postKirim = array(
                "data" => $nilaiSub2ItemLab
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data hasilPemeriksaanLab ke database. Memuat ulang halaman...',
                    
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
}
