<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Token;
use GuzzleHttp\Client;
use App\Models\dataPasien;
use App\Models\Antrian;
use App\Models\Registrasi;
use App\Models\icd10;
use App\Models\icd9;
use App\Models\bodySite;
use App\Models\keluhanSekunder;
use App\Models\keluhanPrimer;
use App\Models\mAllergy;
use App\Models\manifestAllergy;
use App\Models\keluhanUtama;
use App\Models\observationInterpretation;
use App\Models\daftarObat;
use App\Models\resepDenominator;
use App\Models\codeResep;
use App\Models\metodeResep;
use App\Models\keluhanUtamaPasien;
use App\Models\statusLokalis;
use App\Models\resepObat;
use App\Models\resepType;
use App\Models\resepAturan;
use App\Models\tindakanPasien;
use App\Models\serviceOrder;
use App\Models\Transaksi;
use App\Models\kontrolPasien;
use App\Models\jadwalDokter;
use App\Models\Rfid;
//use Illuminate\Support\Facades\Storage;
//use Kangyasin\KTPNIKConvert\NikConvert;
//use thiagoalessio\TesseractOCR\TesseractOCR;
//use Donyahmd\KtpNikParser\NikParser;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class satuSehatController extends Controller
{
	//syncronize user-encounter V1 (berhasil 28-04-24)
	public function syncronizeTest(Request $request) {
	DB::begintransaction();
	try {
			$users = DB::table('data_pasien')->whereNull('satusehat_number')->where('id_pasien', '=', 6)->select('satusehat_number')->first();
			if ($users) {
				/*$data_pasien = dataPasien::find(6);
				$data_pasien->satusehat_number = "P00997975389";
				$data_pasien->save();
				
				$antrian = Antrian::find(5);
				$antrian->id_encounter = "121212hksadhahdh234";
				$antrian->save();
				DB::commit();
				return response()->json(['message' => 'kosong'], 409);*/
				//$response_data = json_decode($response, true);
				//$status = $response_data['success'];
				//token = DB::table('token')->where('id_token', '=', 1)->select('token')->get();
				$getToken = DB::table('token')
				->join('data_pasien', 'token.id_token', '=', 'data_pasien.id_token')
				->where('id_pasien', '=', 6)
				->get();
				//join dengan tabel antrian
				foreach ($getToken as $key => $ch){
				$token = $ch->token;
				$response =Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Patient', [
					'resourceType'=> 'Patient',
					'meta'=> [
					  'profile'=> [
						 'https://fhir.kemkes.go.id/r4/StructureDefinition/Patient'
					  ]
				   ],
				   'identifier'=> [
					  [
						 'use'=> 'official',
						 'system'=> 'https://fhir.kemkes.go.id/id/nik',
						 'value'=> $ch->nomer_identitas,
						 //'value'=> '3578101601900002'
					  ]
				   ],
				   'active'=> true,
				   'name'=> [
					  [
						 'use'=> 'official',
						 'text'=> $ch->nama_pasien,
						 //'text'=> 'sutoyo'
					  ]
				   ],
				   'telecom'=> [
					  [
						 'system'=> 'phone',
						 'value'=> $ch->no_telp,
						 //'value'=> '085566554556',
						 'use'=> 'mobile'
					  ],
					  [
						 'system'=> 'phone',
						 'value'=> '+622123456789',
						 'use'=> 'home'
					  ],
					  [
						 'system'=> 'email',
						 'value'=> $ch->email,
						 //'value'=> 'email@email.com',
						 'use'=> 'home'
					  ]
					   ],
					   'gender'=> $ch->jenis_kelamin,
					   //'gender'=> 'male',
					   'birthDate'=> $ch->tanggal_lahir,
					   //'birthDate'=> '1990-01-16',
					   'deceasedBoolean'=> false,
					   'address'=> [
						  [
							 'use'=> 'home',
							 'line'=> [
								$ch->alamat_ktp
								//'jalan lebak rejo 6'
							 ],
							'city'=> $ch->kota,
							 //'city'=> 'surabaya',
							 'postalCode'=> $ch->kode_pos,
							 //'postalCode'=> '60134',
							 'country'=> 'ID',
							 'extension'=> [
								[
								   'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/administrativeCode',
								   'extension'=> [
									  [
										 'url'=> 'province',
										 //'valueCode'=> $ch->provinsi
										 'valueCode'=> '10'
									  ],
									  [
										 'url'=> 'city',
										 //'valueCode'=> $ch->kota
										 'valueCode'=> '1010'
									  ],
									  [
										 'url'=> 'district',
										 //'valueCode'=> $ch->kecamatan
										 'valueCode'=> '101010'
									  ],
									  [
										 'url'=> 'village',
										 'valueCode'=> '1010101101'
									  ],
									  [
										 'url'=> 'rt',
										 'valueCode'=> $ch->rt
										 //'valueCode'=> '04'
									  ],
									  [
										 'url'=> 'rw',
										 'valueCode'=> $ch->rw
										 //'valueCode'=> '04'
									  ]
								   ]
								]
							 ]
						  ]
					   ],
					   'maritalStatus'=> [
						  'coding'=> [
							 [
								'system'=> 'http://terminology.hl7.org/CodeSystem/v3-MaritalStatus',
								'code'=> 'M',
								'display'=> 'Married'
							 ]
						  ],
						  'text'=> 'Married'
					   ],
					   'multipleBirthInteger'=> 0,
					   'contact'=> [
						  [
							 'relationship'=> [
								[
								   'coding'=> [
									  [
										 'system'=> 'http://terminology.hl7.org/CodeSystem/v2-0131',
										 'code'=> 'C'
									  ]
								   ]
								]
							 ],
							 'name'=> [
								'use'=> 'official',
								'text'=> $ch->nama_penjamin
								//'text'=> 'Ardhi'
							 ],
							 'telecom'=> [
								[
								   'system'=> 'phone',
								   'value'=> $ch->nomer_penjamin,
								   //'value'=> '08566554556654',
								   'use'=> 'mobile'
								]
							 ]
						  ]
					   ],
					   'communication'=> [
						  [
							 'language'=> [
								'coding'=> [
								   [
									  'system'=> 'urn=>ietf=>bcp=>47',
									  'code'=> 'id-ID',
									  'display'=> 'Indonesian'
								   ]
								],
								'text'=> 'Indonesian'
							 ],
							 'preferred'=> true
						  ]
					   ],
					   'extension'=> [
						  [
							 'url'=> 'https://fhir.kemkes.go.id/r4/StructureDefinition/birthPlace',
							 'valueAddress'=> [
								'city'=> $ch->kota,
								//'city'=> 'surabaya',
								'country'=> 'ID'
							 ]
						  ],
						  [
							 'url'=> 'https=>//fhir.kemkes.go.id/r4/StructureDefinition/citizenshipStatus',
							 'valueCode'=> 'WNI'
						  ]
					   ]
					]);
					$response_data = json_decode($response, true);
					$status = $response_data['success'];
					//$status = "false";
					if ($status == "true"){
						$resource_id = $response_data['data']['patient_id'];
						$data_pasien = dataPasien::find(6);
						$data_pasien->satusehat_number = $resource_id;
						$data_pasien->save();
						
						$antrian = Antrian::find(5);
						$antrian->id_encounter = "121212hksadhahdh234";
						$antrian->save();
						
						DB::commit();
						return response()->json([
						'message' => 'kosong',
						'token' => $token
						], 409);
					}else{
						$resource_id = $response_data['data']['resourceID'];
						$data_pasien = dataPasien::find(6);
						$data_pasien->satusehat_number = $resource_id;
						$data_pasien->save();
						
						//$dateNow = Carbon::now();
						//date now ambil dari coloumn tanggal_reg pada tabel data_antrian
						$dateNow = '2024-04-05T01:00:00+00:00';
		
						//////ENCOUNTER/////////
						$encounter = Http::withToken($token)->post('https://api-satusehat-stg.dto.kemkes.go.id/fhir-r4/v1/Encounter', [
							'resourceType'=>'Encounter',
							'identifier'=>[
								[
									'system'=>'http://sys-ids.kemkes.go.id/encounter/24027125-68be-4154-a573-79d6571679d5',
									'value'=>$resource_id
								]
							],
							'status'=>'arrived',
							'class'=>[
								'system'=>'http://terminology.hl7.org/CodeSystem/v3-ActCode',
								'code'=>'AMB',
								'display'=>'ambulatory'
							],
							'subject'=>[
								'reference'=>'Patient/'.$resource_id,
								'display'=>'Budi Santoso'
							],
							'participant'=>[
								[
									'type'=>[
										[
											'coding'=>[
												[
													'system'=>'http://terminology.hl7.org/CodeSystem/v3-ParticipationType',
													'code'=>'ATND',
													'display'=>'attender'
												]
											]
										]
									],
									'individual'=>[
										'reference'=>'Practitioner/N10000001',
										'display'=>'Dokter Bronsig'
									]
								]
							],
							'period'=>[
								'start'=>$dateNow
								//'start'=>$dateNow'T01:00:00+00:00'
							],
							'location'=>[
								[
									'location'=>[
										'reference'=>'Location/ef011065-38c9-46f8-9c35-d1fe68966a3e',
										'display'=>'Ruang 1A, Poliklinik Rawat Jalan'
									],
									'extension'=>[
										[
											'url'=>'https://fhir.kemkes.go.id/r4/StructureDefinition/ServiceClass',
											'extension'=>[
												[
													'url'=>'value',
													'valueCodeableConcept'=>[
														'coding'=>[
															[
																'system'=>'http://terminology.kemkes.go.id/CodeSystem/locationServiceClass-Outpatient',
																'code'=>'reguler',
																'display'=>'Kelas Reguler'
															]
														]
													]
												]
											]
										]
									]
								]
							],
							'statusHistory'=>[
								[
									'status'=>'arrived',
									'period'=>[
										'start'=>$dateNow
										//'start'=>$dateNow'T01:00:00+00:00'
									]
								]
							],
							'serviceProvider'=>[
								'reference'=>'Organization/24027125-68be-4154-a573-79d6571679d5'
							]
						]);
						$encounter_data = json_decode($encounter, true);
						$encounter_id = $encounter_data['id'];
						
						$antrian = Antrian::find(5);
						//$antrian->id_encounter = "121212hksadhahdh234";
						$antrian->id_encounter = $encounter_id;
						$antrian->save();
						
						DB::commit();
						return response()->json([
						'message' => 'satu sehat number kosong',
						'token' => $token
						], 409);
					}
				}//End foreach Token
			} else {
				return response()->json(['message' => 'satu sehat number  sudah ada'], 409);
			}
		
		
		
		} catch (\Exception $e) {
			DB::rollback();
			return response()->json([
			'error' => $e->getMessage(),
			'errors' => $response_data,
			'token' => $encounter_data,
			], 500);
		}
	}
	
	public function syncronizeTest2(Request $request) {
	DB::begintransaction();
	try {
			$users = DB::table('data_pasien')->whereNull('satusehat_number')->where('id_pasien', '=', 6)->select('satusehat_number')->first();
			if ($users) {
				$getToken = DB::table('token')
				->join('data_pasien', 'token.id_token', '=', 'data_pasien.id_token')
				->where('id_pasien', '=', $request->id_pasien)
				->get();
				//join dengan tabel antrian
				foreach ($getToken as $key => $ch){
				$token = $ch->token;
					$status = "false";
					if ($status == "true"){
						$resource_id = "";
						$data_pasien = dataPasien::find($request->id_pasien);
						$data_pasien->satusehat_number = "P00997975389";
						$data_pasien->sync_pasien = 2;
						$data_pasien->save();
						
						$antrian = Antrian::find($request->id_antrian);
						$antrian->id_encounter = "762857fd-e6bf-429e-be84-6663a58b38d4";
						$antrian->sync_antrian = 2;
						$antrian->save();
						
						DB::commit();
						return response()->json([
						'message' => 'kosong',
						'token' => $token
						], 409);
					}else{
						$data_pasien = dataPasien::find($request->id_pasien);
						$data_pasien->satusehat_number = "P00997975389";
						$data_pasien->sync_pasien = 2;
						$data_pasien->save();
						
						$dateNow = '2024-04-05T01:00:00+00:00';
		
						$antrian = Antrian::find($request->id_antrian);
						$antrian->id_encounter = "762857fd-e6bf-429e-be84-6663a58b38d4";
						$antrian->sync_antrian = 2;
						$antrian->save();
						
						DB::commit();
						return response()->json([
						'message' => 'satu sehat number kosong',
						//'token' => $token
						], 409);
					}
				}//End foreach Token
			} else {
				return response()->json(['message' => 'satu sehat number  sudah ada'], 409);
			}
		
		
		
		} catch (\Exception $e) {
			DB::rollback();
			return response()->json([
			'error' => $e->getMessage(),
			'errors' => $response_data,
			'token' => $encounter_data,
			], 500);
		}
	}
	
	public function checkRfid(Request $request)
    {
	DB::begintransaction();
	try {
		$cekRfid = DB::table('m_rfid')
		->where('rf_id', '=', $request->rf_id)
		->where('status', '=', "aktif")
		->get();
		$cekRfidRegis = DB::table('m_rfid')
		->where('rf_id', '=', $request->rf_id)
		->where('status', '=', "available")
		->count();
		if ($cekRfid) {
            return response()->json(['message' => 'rfid sudah digunakan'], 409);
        /*} else if ($cekRfidRegis == 0 ) {
            return response()->json(['message' => 'rfid tidak terdaftar'], 409);*/
        } else {
			 return response()->json(['message' => 'rfid bisa digunakan'], 200);
			/*$rfid = Rfid::find($request->rf_id);
			$rfid->status = "aktif";
			$rfid->id_pasien = $id;
			$rfid->tanggal_register = Carbon::now();*/
			
		DB::commit();
			return response()->json([
			'result' => TRUE,
			'message' => 'rfid tersedia, berhasil insert data ke database.....',
			], 200);
        }
	}catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'pesan' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
    }
	
	public function checkDuplicate(Request $request)
    {
	DB::begintransaction();
	try {
        // Ganti 'data_field' dengan nama field yang ingin dicek
        //$dataField = $request->input('data_field');
		$cekRfid = DB::table('m_rfid')
		->where('rf_id', '=', $request->rf_id)
		->where('status', '=', "aktif")
		->count();
		$cekRfidRegis = DB::table('m_rfid')
		->where('rf_id', '=', $request->rf_id)
		->where('status', '=', "available")
		->count();
		
		$namaPasien = $request->nama_pasien;
		$nik = $request->nomer_identitas;
		
		$data_pasien = new dataPasien;
		$data_pasien->nama_pasien = $request->nama_pasien;
		$data_pasien->no_telp = $request->no_telp;
		$data_pasien->email = $request->email;
		$data_pasien->nomer_rm = $request->nomer_rm;
		$data_pasien->jenis_kelamin = $request->gender;
		$data_pasien->tanggal_lahir = $request->tanggal_lahir_form;
		$data_pasien->alamat_ktp = $request->alamat_ktp;
		$data_pasien->nama_penjamin = $request->nama_penjamin;
		$data_pasien->nomer_penjamin = $request->nomer_penjamin;
		$data_pasien->tempat_lahir = $request->kota;	
		$data_pasien->kode_pos = $request->kode_pos;
		$data_pasien->provinsi = $request->provinsi;
		$data_pasien->kota = $request->kota;	
		$data_pasien->kecamatan = $request->kecamatans;
		$data_pasien->rw = $request->rw;
		$data_pasien->rt = $request->rt;	
		$data_pasien->kartu_identitas = $request->kartu_identitas;
		$data_pasien->nomer_identitas = $nik;	
		
		
        // Cek apakah data sudah ada di database
        //$duplicateName = dataPasien::where('nama_pasien', $namaPasien)->exists();
		$duplicateNik = dataPasien::where('nomer_identitas', $nik)->exists();

        if ($duplicateNik) {
            return response()->json(['message' => 'nik sudah digunakan'], 409);
        } else if ($cekRfid == 1 ) {
            return response()->json(['message' => 'Kartu sudah digunakan, silahkan ganti dengan yang lain'], 409);
        } else if ($cekRfidRegis == 0 ) {
            return response()->json(['message' => 'rfid tidak terdaftar'], 409);
        } else {
			$data_pasien->save();
			$countAntrian = DB::table('data_antrian')
			->where('id_jadwal', '=', $request->id_jadwal)
			->max('no_antrian');
			$generateAntrian = $countAntrian+1 ;
			$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
			$countPx = DB::table('data_pasien')
			->max('id_pasien');
			$generateidpx = $countPx ;
			$id = DB::table('data_pasien')->max('id_pasien');
			$antrian = new Antrian;
			//$antrian->id_encounter = $encounter_id;
			$antrian->id_jadwal = $request->id_jadwal;
			$antrian->id_pasien = $id;
			$antrian->keluhan_awal = "demam";
			$antrian->no_antrian = $nomerAntrian;
			$antrian->save();
			$id_antrian = DB::table('data_antrian')->where('id_jadwal', '=', $request->id_jadwal)->max('id_antrian');
			
			$rfid = Rfid::find($request->rf_id);
			$rfid->status = "aktif";
			$rfid->id_pasien = $id;
			$rfid->tanggal_register = Carbon::now();
			$rfid->save();
            DB::commit();
			return response()->json([
			'result' => TRUE,
			'message' => 'pasien dan nik tersedia, berhasil insert data ke database.....',
			'antrian' => $nomerAntrian,
			'id_antrian' => $id_antrian
			], 200);
        }
	}catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'pesan' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
    }
	
	public function checkDuplicateAntrian(Request $request)
    {
	DB::begintransaction();
	try {
			$nik = $request->nomer_identitas_update;
			
			$data_pasien = dataPasien::find($request->id_pasien_update);
			$data_pasien->nama_pasien = $request->nama_pasien_update;
			$data_pasien->no_telp = $request->no_telp_update;
			$data_pasien->email = $request->email_update;
			//$registrasi->nomer_rm = $request->nomer_rm_update;
			$data_pasien->jenis_kelamin = $request->gender_update;
			$data_pasien->tanggal_lahir = $request->tanggal_lahir_form_update;
			$data_pasien->alamat_ktp = $request->alamat_ktp_update;
			$data_pasien->nama_penjamin = $request->nama_penjamin_update;
			$data_pasien->nomer_penjamin = $request->nomer_penjamin_update;
			$data_pasien->tempat_lahir = $request->kota_update;	
			$data_pasien->kode_pos = $request->kode_pos_update;
			$data_pasien->provinsi = $request->provinsi_update;
			$data_pasien->kota = $request->kota_update;	
			$data_pasien->kecamatan = $request->kecamatans_update;
			$data_pasien->rw = $request->rw_update;
			$data_pasien->rt = $request->rt_update;	
			$data_pasien->kartu_identitas = $request->kartu_identitas_update;
			$data_pasien->nomer_identitas = $nik;	
		
			$dateNow = Carbon::now()->format('Y-m-d');
			$cekTanggalPendaftaran = DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.id_pasien', '=', $request->id_pasien_update)
				->where('jadwal_poli.tanggal', '=', $dateNow)
				->exists();
			$duplicateNik = DB::table('data_pasien')
			->where('nomer_identitas', '=', $nik)
			->select('nomer_identitas')
			->count();

			if ($duplicateNik > 1) {
				return response()->json(['message' => 'nik sudah digunakan'], 409);
			} else if ($cekTanggalPendaftaran) {
				return response()->json(['message' => 'pasien sudah terdaftar pada jadwal yang sama'], 409);
			} else {
				$data_pasien->save();
				$countAntrian = DB::table('data_antrian')
				->where('id_jadwal', '=', $request->id_jadwal_update)
				->max('no_antrian');
				$generateAntrian = $countAntrian+1 ;
				$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
				$countPx = DB::table('data_pasien')
				->max('id_pasien');
				$generateidpx = $countPx ;
				$id = DB::table('data_pasien')->max('id_pasien');
				$antrian = new Antrian;
				//$antrian->id_encounter = $encounter_id;
				$antrian->id_jadwal = $request->id_jadwal_update;
				$antrian->id_pasien = $request->id_pasien_update;
				$antrian->keluhan_awal = "demam";
				$antrian->no_antrian = $nomerAntrian;
				$antrian->save();
				$id_antrian = DB::table('data_antrian')->where('id_jadwal', '=', $request->id_jadwal_update)->max('id_antrian');
				DB::commit();
				return response()->json([
				'result' => TRUE,
				'message' => 'pasien dan nik tersedia, berhasil insert data ke database.....',
				'antrian' => $nomerAntrian,
				'id' => $id_antrian
				], 200);
			}
		}catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'pesan' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function coba(Request $request)
    {
	DB::begintransaction();
	try {
		
			$nik = 3578101601900003;
			$data_pasien = new dataPasien;
			$data_pasien->nama_pasien = "Supardi";
			$duplicateNik = dataPasien::where('nomer_identitas', $nik)->exists();
			 if ($duplicateNik) {
				return response()->json(['message' => 'nik sudah terdaftar'], 409);
			} else {
				$data_pasien->save();
				$id = DB::table('data_pasien')->max('id_pasien');
				$antrian = new Antrian;
				$antrian->id_pasien = $id;
				$antrian->keluhan_awal = "demam";
				$antrian->id_jadwal = 1741;
				$antrian->no_antrian = 002;
				$antrian->save();
				DB::commit();
				return response()->json(['message' => 'berhasil insert data ke database.....'], 200);
			}
					
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'pesan' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	//////////KELUHAN PRIMER DAN SEKUNDER//////////////////////////////
	
	public function selectDataICD10(Request $request){

		  $search = $request->search;

		  if($search == ''){
			 $dataPasien = icd10::orderby('code','asc')
			 ->select('id_icd10','code','str','sab')
			 ->limit(5)
			 ->get();
		  }else{
			 $dataPasien = icd10::orderby('code','asc')
			 ->select('id_icd10','code','str','sab')
			 ->where('code', 'like', '%' .$search . '%')
			 ->orWhere('str', 'like', '%' .$search . '%')
			 ->limit(5)
			 ->get();
		  }

		  $response = array();
		  foreach($dataPasien as $pasien){
			 $response[] = array(
				  $gabungan = $pasien['code']." - ".$pasien['str']." - ".$pasien['sab'],
				  
				  "id"=>$pasien->id_icd10,
				  "code"=>$pasien->code,
				  "str"=>$pasien->str,
				  "text"=>$gabungan
			 );
		  }

		  return response()->json($response);
	    }
		
		public function getKeluhanPrimmer(Request $request) {
			$keluhanPrimer = DB::table('keluhan_primer')
				->select('id_antrian','code','str','id_keluhan_primer')
				//->where('id_antrian', '=', $request->id_antrian)
				->where('id_antrian', '=', $request->id_antrian)
				->get();
			
			if ($keluhanPrimer) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $keluhanPrimer,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getKeluhanSekunder(Request $request) {
			$keluhanSekunder = DB::table('keluhan_sekunder')
				->select('id_antrian','code','str','id_keluhan_sekunder')
				->where('id_antrian', '=', $request->id_antrian)
				//->where('id_antrian', '=', 5)
				->get();
			
			if ($keluhanSekunder) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $keluhanSekunder,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function insertKeluhanSekunder(Request $request)
    {
	DB::begintransaction();
	try {
			$keluhanSekunder = new keluhanSekunder;
			$keluhanSekunder->id_antrian = $request->id_antrian;
			$keluhanSekunder->code = $request->code_sekunder;
			$keluhanSekunder->str = $request->str_sekunder;
			$keluhanSekunder->save();
			DB::commit();
			return response()->json(['message' => 'berhasil insert data ke database.....'], 200);
					
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function insertKeluhanPrimer(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();
			$duplicateKeluhanPrimer = DB::table('keluhan_primer')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'keluhan_primer.id_antrian')
			->where('keluhan_primer.id_antrian', '=', $request->id_antrian)
			//->where('keluhan_primer.id_antrian', '=', 5)
			->select('id_antrian')
			->count();

			if ($duplicateKeluhanPrimer > 0) {
				return response()->json(['message' => 'keluhan primer tidak boleh lebih dari satu'], 409);
			} else {
				$keluhanPrimer = new keluhanPrimer;
				$keluhanPrimer->id_antrian = $request->id_antrian;
				$keluhanPrimer->code = $request->code_primer;
				$keluhanPrimer->str = $request->str_primer;
				$keluhanPrimer->free_text_kp = $request->free_text_kp;
				$keluhanPrimer->save();
				DB::commit();
				return response()->json(['message' => 'berhasil insert data ke database.....'], 200);
			}
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteKeluhanPrimer(Request $request) {
		DB::begintransaction();
		try {
			$delete = keluhanPrimer::find($request->id_keluhan_primer);
			if (!$delete->delete()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan delete transaksi'
				];
			}
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteKeluhanSekunder(Request $request) {
		DB::begintransaction();
		try {
			$delete = keluhanSekunder::find($request->id_keluhan_sekunder);
			$delete->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	//////////INFORMASI PEMERIKSAAN//////////////////////////////
	
	public function getInformasiPemeriksaan(Request $request) {
		$informasiPemeriksaan = DB::table('data_antrian')
		->join('tingkat_kesadaran_pasien', 'data_antrian.id_antrian', '=', 'tingkat_kesadaran_pasien.id_antrian')
		->join('m_tingkat_kesadaran', 'tingkat_kesadaran_pasien.id_tingkat_kesadaran', '=', 'm_tingkat_kesadaran.id_tingkat_kesadaran')
		//->join('bmi_pasien', 'data_antrian.id_antrian', '=', 'bmi_pasien.id_antrian')
		->join('pemeriksaan_fisik_pasien', 'data_antrian.id_antrian', '=', 'pemeriksaan_fisik_pasien.id_antrian')
		->where('data_antrian.id_antrian', '=', $request->id_antrian)
		->get();
		
		if ($informasiPemeriksaan) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $informasiPemeriksaan,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function getTabelPemeriksaan(Request $request) {
		$getTabelPemeriksaan = DB::table('data_antrian')
		->join('pemeriksaan_fisik_pasien', 'data_antrian.id_antrian', '=', 'pemeriksaan_fisik_pasien.id_antrian')
		->where('data_antrian.id_antrian', '=', $request->id_antrian)
		->get();
		
		if ($getTabelPemeriksaan) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $getTabelPemeriksaan,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}

	public function insertPemeriksaanFisik(Request $request)
    {
	DB::begintransaction();
	try {
				DB::table('pemeriksaan_fisik_pasien')->insert([
					'id_antrian' => $request->id_antrian,
					'valueHR' => $request->valueHR,
					'valueRR' => $request->	valueRR,
					'valueBerat' => $request->valueBerat,
					'valueTinggi' => $request->valueTinggi,
					'valueSistol' => $request->valueSistol,
					'valueDiastole' => $request->valueDiastole,
					'valueSuhu' => $request->valueSuhu,
				]);
				DB::commit();
				return response()->json(['message' => 'berhasil insert Pemeriksaan ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function insertPemeriksaanFisikDokter(Request $request)
    {
	DB::begintransaction();
	try {
				DB::table('pemeriksaan_fisik_pasien')->insert([
					'id_antrian' => $request->id_antrian,
					'valueHR' => $request->valueHR,
					'valueRR' => $request->	valueRR,
					'valueBerat' => $request->valueBerat,
					'valueTinggi' => $request->valueTinggi,
					'valueSistol' => $request->valueSistol,
					'valueDiastole' => $request->valueDiastole,
					'valueSuhu' => $request->valueSuhu,
				]);
				DB::table('tingkat_kesadaran_pasien')->insert([
					'id_antrian' => $request->id_antrian,
					'id_tingkat_kesadaran' => $request->kesadaran,
				]);
				DB::commit();
				return response()->json(['message' => 'berhasil insert Pemeriksaan ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}

	public function deletePemeriksaanFisik(Request $request) {
		DB::begintransaction();
		try {
			$deletePemeriksaanFisik = DB::table("pemeriksaan_fisik_pasien")->where("id_pemeriksaan_fisik", $request->id_pemeriksaan_fisik)->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	//////////ALLERGY//////////////////////////////
	
	public function selectDataAllergy(Request $request){

		  $search = $request->search;

		  if($search == ''){
			 $dataPasien = mAllergy::orderby('code','asc')
			 ->select('id_allergy','code','display')
			 ->limit(5)
			 ->get();
		  }else{
			 $dataPasien = mAllergy::orderby('code','asc')
			 ->select('id_allergy','code','display')
			 ->where('code', 'like', '%' .$search . '%')
			 ->orWhere('display', 'like', '%' .$search . '%')
			 ->limit(5)
			 ->get();
		  }

		  $response = array();
		  foreach($dataPasien as $pasien){
			 $response[] = array(
				  $gabungan = $pasien['code']." - ".$pasien['display'],
				  
				  "id"=>$pasien->id_allergy,
				  "code"=>$pasien->code,
				  "display"=>$pasien->display,
				  "text"=>$gabungan
			 );
		  }

		  return response()->json($response);
	    }
		
	public function selectManifestAllergy(Request $request){

		  $search = $request->search;

		  if($search == ''){
			 $dataPasien = manifestAllergy::orderby('code_manifest_allergy','asc')
			 ->select('id_manifest_allergy','code_manifest_allergy','display_manifest_allergy')
			 ->limit(5)
			 ->get();
		  }else{
			 $dataPasien = manifestAllergy::orderby('code_manifest_allergy','asc')
			 ->select('id_manifest_allergy','code_manifest_allergy','display_manifest_allergy')
			 ->where('code_manifest_allergy', 'like', '%' .$search . '%')
			 ->orWhere('display_manifest_allergy', 'like', '%' .$search . '%')
			 ->limit(5)
			 ->get();
		  }

		  $response = array();
		  foreach($dataPasien as $pasien){
			 $response[] = array(
				  $gabungan = $pasien['code_manifest_allergy']." - ".$pasien['display_manifest_allergy'],
				  
				  "id"=>$pasien->id_manifest_allergy,
				  "code"=>$pasien->code_manifest_allergy,
				  "display"=>$pasien->display_manifest_allergy,
				  "text"=>$gabungan
			 );
		  }

		  return response()->json($response);
	    }
		
	public function getAllergyPasien(Request $request) {
		$allergyPasien = DB::table('allergy_pasien')
		->join('m_allergy', 'm_allergy.id_allergy', '=', 'allergy_pasien.id_allergy')
		->join('m_manifest_allergy', 'm_manifest_allergy.id_manifest_allergy', '=', 'allergy_pasien.id_manifest_allergy')
		//->select('id_antrian','code','display','id_allergy_pasien','category_allergy','text_allergy')
		->where('id_antrian', '=', $request->id_antrian)
		//->where('id_antrian', '=', 5)
		->get();
		
		if ($allergyPasien) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $allergyPasien,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function insertAllergyPasien(Request $request)
    {
	DB::begintransaction();
	try {
				DB::table('allergy_pasien')->insert([
					'id_antrian' => $request->id_antrian,
					'id_allergy' => $request->id_allergy,
					'id_manifest_allergy' => $request->	id_manifest_allergy,
					'category_allergy' => $request->category_allergy,
					'text_allergy' => $request->text_allergy,
					'type_allergy' => $request->type_allergy,
					'criticality' => $request->criticality,
					'severity' => $request->severity,
				]);
				DB::commit();
				return response()->json(['message' => 'berhasil insert Alergi ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteAllergyPasien(Request $request) {
		DB::begintransaction();
		try {
			
			$deleteAllergy = DB::table("allergy_pasien")->where("id_allergy_pasien", $request->id_allergy_pasien)->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete Allergy. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getPemeriksaanFisikPasien(Request $request) {
		$pemeriksaanFisikPasien = DB::table('pemeriksaan_fisik_pasien')
		->where('id_antrian', '=', $request->id_antrian)
		->get();
		
		if ($pemeriksaanFisikPasien) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $pemeriksaanFisikPasien,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function getKesadaranPasien(Request $request) {
		$kesadaranPasien = DB::table('tingkat_kesadaran_pasien')
		->join('m_tingkat_kesadaran', 'm_tingkat_kesadaran.id_tingkat_kesadaran', '=', 'tingkat_kesadaran_pasien.id_tingkat_kesadaran')
		->where('id_antrian', '=', $request->id_antrian)
		->get();
		
		if ($kesadaranPasien) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $kesadaranPasien,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}

	public function insertKesadaranPasien(Request $request)
    {
	DB::begintransaction();
	try {
				DB::table('tingkat_kesadaran_pasien')->insert([
					'id_antrian' => $request->id_antrian,
					'id_tingkat_kesadaran' => $request->id_tingkat_kesadaran,
				]);
				DB::commit();
				return response()->json(['message' => 'berhasil insert Pemeriksaan ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}

	public function deleteKesadaranPasien(Request $request) {
		DB::begintransaction();
		try {
			$deletePemeriksaanFisik = DB::table("tingkat_kesadaran_pasien")->where("id_kesadaran", $request->id_kesadaran)->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete Pemeriksaan. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function selectObservationInterpretation(Request $request){

		  $search = $request->search;

		  if($search == ''){
			 $dataPasien = observationInterpretation::orderby('code_oi','asc')
			 ->limit(5)
			 ->get();
		  }else{
			 $dataPasien = observationInterpretation::orderby('code_oi','asc')
			 ->where('code_oi', 'like', '%' .$search . '%')
			 ->orWhere('display_oi', 'like', '%' .$search . '%')
			 ->limit(5)
			 ->get();
		  }

		  $response = array();
		  foreach($dataPasien as $pasien){
			 $response[] = array(
				  $gabungan = $pasien['display_oi'],
				  
				  "id"=>$pasien->id_oi,
				  "code"=>$pasien->code_oi,
				  "display"=>$pasien->display_oi,
				  "keterangan"=>$pasien->keterangan_oi,
				  "text"=>$gabungan
			 );
		  }

		  return response()->json($response);
	    }
		
	public function selectDataICD9(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = icd9::orderby('code','asc')
		 ->select('id_icd9','code','str','sab')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = icd9::orderby('code','asc')
		 ->select('id_icd9','code','str','sab')
		 ->where('code', 'like', '%' .$search . '%')
		 ->orWhere('str', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['code']." - ".$pasien['str']." - ".$pasien['sab'],
			  
			  "id"=>$pasien->id_icd9,
			  "code"=>$pasien->code,
			  "str"=>$pasien->str,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
	
	public function selectDataBodySite(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = bodySite::orderby('code_bodysite','asc')
		 ->select('id_bodysite','code_bodysite','display_bodysite')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = bodySite::orderby('code_bodysite','asc')
		 ->select('id_bodysite','code_bodysite','display_bodysite')
		 ->where('code_bodysite', 'like', '%' .$search . '%')
		 ->orWhere('display_bodysite', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['code_bodysite']." - ".$pasien['display_bodysite'],
			  
			  "id"=>$pasien->id_bodysite,
			  "code"=>$pasien->code_bodysite,
			  "display"=>$pasien->display_bodysite,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
	
	public function selectDataKeluhanUtama(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = keluhanUtama::orderby('code_ku','asc')
		 ->select('id_ku','code_ku','display_ku','keterangan_ku')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = keluhanUtama::orderby('code_ku','asc')
		 ->select('id_ku','code_ku','display_ku','keterangan_ku')
		 ->where('display_ku', 'like', '%' .$search . '%')
		 ->orWhere('keterangan_ku', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['display_ku']." - ".$pasien['keterangan_ku'],
			  
			  "id"=>$pasien->id_ku,
			  "code"=>$pasien->code_ku,
			  "display"=>$pasien->display_ku,
			  "keterangan"=>$pasien->keterangan_ku,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
	
	public function insertSoapPasien(Request $request)
    {
	DB::begintransaction();
	try {
			$duplicateSoap = DB::table('soap_pasien')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'soap_pasien.id_antrian')
			->where('soap_pasien.id_antrian', '=', $request->id_antrian)
			->select('id_antrian')
			->count();

			if ($duplicateSoap > 0) {
				return response()->json(['message' => 'Soap tidak boleh lebih dari satu'], 409);
			} else {
				DB::table('soap_pasien')->insert([
					'id_antrian' => $request->id_antrian,
					'subjective' => $request->subjective,
					'objective' => $request->objective,
					'assestmen' => $request->assestmen,
					'planning' => $request->planning,
					'instruksi' => $request->instruksi,
				]);
				$status = Antrian::find($request->id_antrian);
				$status->pemeriksaan_dokter = "selesai";
				$status->save();
				DB::commit();
				return response()->json(['message' => 'berhasil insert Soap ke database.....'], 200);
			}
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function updateSoapPasien(Request $request)
    {
	DB::begintransaction();
	try {
			
			$updateSoap = DB::table('soap_pasien')
            ->where('id_soap', $request->id_soap)
            ->update([
				'subjective' => $request->subjective,
				'objective' => $request->objective,
				'assestmen' => $request->assestmen,
				'planning' => $request->planning,
				'instruksi' => $request->instruksi,
			]);
			DB::commit();
			return response()->json(['message' => 'Berhasil update SOAP.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteSoapPasien(Request $request) {
		DB::begintransaction();
		try {
			
			$deleteSoap = DB::table("soap_pasien")->where("id_soap", $request->id_soap)->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete Soap. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getSoapPasien(Request $request) {
			$SoapPasien = DB::table('soap_pasien')
				->where('id_antrian', '=', $request->id_antrian)
				->get();
			
			if ($SoapPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $SoapPasien,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function insertKeluhanUtama(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();
			$duplicateKeluhanUtama = DB::table('keluhan_utama')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'keluhan_utama.id_antrian')
			->where('keluhan_utama.id_antrian', '=', $request->id_antrian)
			//->where('keluhan_primer.id_antrian', '=', 5)
			->select('id_antrian')
			->count();

			if ($duplicateKeluhanUtama > 0) {
				return response()->json(['message' => 'keluhan Utama tidak boleh lebih dari satu'], 409);
			} else {
				$keluhanUtamaPasien = new keluhanUtamaPasien;
				$keluhanUtamaPasien->id_antrian = $request->id_antrian;
				$keluhanUtamaPasien->kode_ku = $request->kode_ku;
				$keluhanUtamaPasien->display_ku = $request->display_ku;
				$keluhanUtamaPasien->keterangan_ku = $request->keterangan_ku;
				//$keluhanUtamaPasien->free_text_ku = $request->free_text_ku;
				$keluhanUtamaPasien->save();
				DB::commit();
				return response()->json(['message' => 'berhasil insert keluhan utama ke database.....'], 200);
			}
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteKeluhanUtama(Request $request) {
		DB::begintransaction();
		try {
			$delete = keluhanUtamaPasien::find($request->id_keluhan_utama);
			if (!$delete->delete()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan delete transaksi'
				];
			}
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getKeluhanUtama(Request $request) {
			$keluhanUtama = DB::table('keluhan_utama')
				//->select('id_antrian','code','str','id_keluhan_primer')
				//->where('id_antrian', '=', $request->id_antrian)
				->where('id_antrian', '=', $request->id_antrian)
				->get();
			
			if ($keluhanUtama) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $keluhanUtama,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function selectDaftarObat(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = daftarObat::orderby('id_po','asc')
		 ->select('id_po','produk_obat','kode_sediaan','sediaan')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = daftarObat::orderby('id_po','asc')
		 ->select('id_po','produk_obat','kode_sediaan','sediaan')
		 ->where('produk_obat', 'like', '%' .$search . '%')
		 ->orWhere('sediaan', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['produk_obat']." - ".$pasien['kode_sediaan']." - ".$pasien['sediaan'],
			  
			  "id"=>$pasien->id_po,
			  "code"=>$pasien->kode_sediaan,
			  "sediaan"=>$pasien->sediaan,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
	
	public function getKandunganObat(Request $request) {
		$kandunganObat = DB::table('m_kandunganobat')
		->where('id_po', '=', $request->id_po)
		->get();
		
		if ($kandunganObat) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $kandunganObat,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function selectResepDenominator(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = resepDenominator::orderby('id_rd','asc')
		 ->select('id_rd','code_rd','display_rd')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = resepDenominator::orderby('id_rd','asc')
		->select('id_rd','code_rd','display_rd')
		 ->where('code_rd', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['code_rd']." - ".$pasien['display_rd'],
			  
			  "id"=>$pasien->id_rd,
			  "code"=>$pasien->code_rd,
			  "display"=>$pasien->display_rd,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
	
	public function selectCodeResep(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = codeResep::orderby('id_cr','asc')
		// ->select('id_rd','code_rd','display_rd')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = codeResep::orderby('id_cr','asc')
		//->select('id_rd','code_rd','display_rd')
		 ->where('code_cr', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['code_cr'],
			  
			  "id"=>$pasien->id_cr,
			  "discription"=>$pasien->discription,
			  "freq"=>$pasien->frequency,
			  "period"=>$pasien->period,
			  "periodunit"=>$pasien->periodunit,
			  "when"=>$pasien->when,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
	
	public function selectMetodeResep(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = metodeResep::orderby('id_mr','asc')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = metodeResep::orderby('id_mr','asc')
		 ->where('code_cr', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['keterangan_mr'],
			  
			  "id"=>$pasien->id_mr,
			  "code"=>$pasien->code_mr,
			  "display"=>$pasien->display_mr,
			  "keterangan"=>$pasien->keterangan_mr,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
	
	public function insertStatusLokalis(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();
			$duplicateStatusLokalis = DB::table('status_lokalis_pasien')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'status_lokalis_pasien.id_antrian')
			->where('status_lokalis_pasien.id_antrian', '=', $request->id_antrian)
			//->where('keluhan_primer.id_antrian', '=', 5)
			->select('id_antrian')
			->count();

			if ($duplicateStatusLokalis == 1) {
				return response()->json(['message' => 'Status Lokalis tidak boleh lebih dari satu'], 409);
			} else {
				$statusLokalisPasien = new statusLokalis;
				$statusLokalisPasien->id_antrian = $request->id_antrian;
				$statusLokalisPasien->kepala = $request->kepala;
				$statusLokalisPasien->mata = $request->mata;
				$statusLokalisPasien->tht = $request->tht;
				$statusLokalisPasien->thorax = $request->thorax;
				$statusLokalisPasien->abdomen = $request->abdomen;
				$statusLokalisPasien->extremitas = $request->extremitas;
				$statusLokalisPasien->genitalia = $request->genitalia;
				$statusLokalisPasien->keterangan_kepala = $request->ketkepala;
				$statusLokalisPasien->keterangan_mata = $request->ketmata;
				$statusLokalisPasien->keterangan_tht = $request->kettht;
				$statusLokalisPasien->keterangan_thorax = $request->ketthorax;
				$statusLokalisPasien->keterangan_abdomen = $request->ketabdomen;
				$statusLokalisPasien->keterangan_extremitas = $request->ketextremitas;
				$statusLokalisPasien->keterangan_genitalia = $request->ketgenitalia;
				$statusLokalisPasien->status = 1;
				$statusLokalisPasien->save();
				DB::commit();
				return response()->json(['message' => 'berhasil insert Status Lokalis ke database.....'], 200);
			}
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}

	public function getStatusLokalis(Request $request) {
			$statusLokalis = DB::table('status_lokalis_pasien')
				//->select('id_antrian','code','str','id_keluhan_primer')
				//->where('id_antrian', '=', $request->id_antrian)
				->where('id_antrian', '=', $request->id_antrian)
				->get();
			
			if ($statusLokalis) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $statusLokalis,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function updateStatusLokalis(Request $request)
    {
	DB::begintransaction();
	try {
			$statusLokalisPasien = statusLokalis::find($request->id_lp);
			$statusLokalisPasien->id_antrian = $request->id_antrian;
			$statusLokalisPasien->kepala = $request->kepala;
			$statusLokalisPasien->mata = $request->mata;
			$statusLokalisPasien->tht = $request->tht;
			$statusLokalisPasien->thorax = $request->thorax;
			$statusLokalisPasien->abdomen = $request->abdomen;
			$statusLokalisPasien->extremitas = $request->extremitas;
			$statusLokalisPasien->genitalia = $request->genitalia;
			$statusLokalisPasien->keterangan_kepala = $request->ketkepala;
			$statusLokalisPasien->keterangan_mata = $request->ketmata;
			$statusLokalisPasien->keterangan_tht = $request->kettht;
			$statusLokalisPasien->keterangan_thorax = $request->ketthorax;
			$statusLokalisPasien->keterangan_abdomen = $request->ketabdomen;
			$statusLokalisPasien->keterangan_extremitas = $request->ketextremitas;
			$statusLokalisPasien->keterangan_genitalia = $request->ketgenitalia;
			$statusLokalisPasien->save();
			DB::commit();
			return response()->json(['message' => 'berhasil update Status Lokalis ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function insertResepNonRacikan(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();$request->jenisObat;
			
			$resepType = new resepType;
			$resepType->id_antrian = $request->id_antrian;
			$resepType->jenis_obat = $request->jenisObat;
			$resepType->status = 1;
			$resepType->save();
			
			$id = DB::table('resep_type')
			->where('id_antrian', '=', $request->id_antrian)
			->max('id_rt');
			
			$resepObat = new resepObat;
			$resepObat->id_rt = $id;
			$resepObat->obat = $request->namaObat;
			$resepObat->save();
			
			$aturanpakai = new resepAturan;
			$aturanpakai->id_rt = $id;
			$aturanpakai->siklus_ra = $request->siklusNonRacikan;
			$aturanpakai->dosis_ra = $request->dosisNonRacikan;
			$aturanpakai->jumlah = $request->jumlahNonRacikan;
			$aturanpakai->keterangan = $request->keteranganNonRacikan;
			$aturanpakai->save();
			
			DB::commit();
			return response()->json([
			'message' => 'Berhasil...',
			'id' => $id,
			], 200);
			
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function insertReseptype(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();$request->jenisObat;
			$resepType = new resepType;
			$resepType->id_antrian = $request->id_antrian;
			$resepType->jenis_obat = $request->jenisObat;
			$resepType->save();
			$id = DB::table('resep_type')
			->where('id_antrian', '=', $request->id_antrian)
			->max('id_rt');
			DB::commit();
			return response()->json([
			'message' => 'Berhasil, silahkan lanjutkan ke pemilihan obat...',
			'id' => $id,
			], 200);
			
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteReseptype(Request $request) {
		DB::begintransaction();
		try {
			//$deleteType = resepType::find($request->id_rt);
			//$deleteType->delete();
			
			//$deleteObat = resepObat::find($request->id_rt);
			//$deleteObat->delete();
			
			$deleteType = DB::table("resep_type")->where("id_rt", $request->id_rt)->delete();
			$deleteObat = DB::table("resep_obat")->where("id_rt", $request->id_rt)->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function insertResepRacikan(Request $request)
    {
	DB::begintransaction();
	try {
			$id = DB::table('resep_type')
			->where('id_antrian', '=', $request->id_antrian)
			->max('id_rt');
			
			$resepObat = new resepObat;
			$resepObat->id_rt = $request->id_rt;
			$resepObat->obat = $request->namaObatRacikan;
			$resepObat->dosis = $request->dosisRacikan;
			$resepObat->unit = $request->unitRacikan;
			$resepObat->save();
			DB::commit();
			return response()->json(['message' => 'berhasil insert Obat Racikan ke database.....'], 200);
			
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function insertAturanRacikan(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();$request->jenisObat;
			$id = DB::table('resep_type')
			->where('id_antrian', '=', $request->id_antrian)
			->max('id_rt');
			
			$duplicateAturanPakai = DB::table('resep_aturan')
			->where('id_rt', '=', $id)
			->select('id_rt')
			->count();

			if ($duplicateAturanPakai > 0) {
				return response()->json(['message' => 'Oops Aturan pakai hanya boleh satu !!!'], 409);
			} else {
				$aturanpakai = new resepAturan;
				$aturanpakai->id_rt = $request->id_rt;
				$aturanpakai->siklus_ra = $request->siklusRacikan;
				$aturanpakai->dosis_ra = $request->dosisRacikan2;
				$aturanpakai->dtd = $request->kategoriRacikan;
				$aturanpakai->unit_ra = $request->unitRacikan2;
				$aturanpakai->jumlah = $request->jumlahRacikan;
				$aturanpakai->keterangan = $request->keteranganRacikan;
				$aturanpakai->save();
				
				$status = resepType::find($id);
				$status->status = 2;
				$status->save();
				
				DB::commit();
				return response()->json(['message' => 'berhasil insert Aturan Pakai....'], 200);
			}
			
		} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function updateAturanRacikan(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();$request->jenisObat;
			
				$aturanpakai = resepAturan::find($request->id_ra);
				$aturanpakai->siklus_ra = $request->siklusRacikanEdit;
				$aturanpakai->dosis_ra = $request->dosisRacikan2Edit;
				$aturanpakai->dtd = $request->kategoriRacikanEdit;
				$aturanpakai->unit_ra = $request->unitRacikan2Edit;
				$aturanpakai->jumlah = $request->jumlahRacikanEdit;
				$aturanpakai->keterangan = $request->keteranganRacikanEdit;
				$aturanpakai->save();
				
				$status = resepType::find($request->id_rt);
				$status->status = 2;
				$status->save();
				
				DB::commit();
				return response()->json(['message' => 'berhasil Update Aturan Pakai.....'], 200);
			
		} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getResepObat(Request $request) {
			$resepObat = DB::table('resep_obat')
			->join('resep_type', 'resep_type.id_rt', '=', 'resep_obat.id_rt')
			->where('resep_type.id_rt', '=', $request->id_rt)
			->where('jenis_obat', '=', "Racikan")
			//->where('status', '=', 1)
			->get();
			
			if ($resepObat) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $resepObat,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function getResepAturan(Request $request) {
			$resepAturan = DB::table('resep_aturan')
			->where('resep_aturan.id_rt', '=', $request->id_rt)
			->get();
			
			if ($resepAturan) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $resepAturan,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}

	public function getResepObatNonRacikan(Request $request) {
		$resepObat = DB::table('resep_obat')
		->join('resep_type', 'resep_type.id_rt', '=', 'resep_obat.id_rt')
		->join('resep_aturan', 'resep_type.id_rt', '=', 'resep_aturan.id_rt')
		->where('resep_type.id_rt', '=', $request->id_rt)
		->where('jenis_obat', '=', "Non Racikan")
		//->where('status', '=', 1)
		->get();
		
		if ($resepObat) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $resepObat,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function getResepObatNonRacikanEdit(Request $request) {
		$resepObat = DB::table('resep_obat')
		->join('resep_type', 'resep_type.id_rt', '=', 'resep_obat.id_rt')
		->join('resep_aturan', 'resep_type.id_rt', '=', 'resep_aturan.id_rt')
		->where('resep_type.id_rt', '=', $request->id_rt)
		->where('jenis_obat', '=', "Non Racikan")
		//->where('status', '=', 2)
		->get();
		
		if ($resepObat) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $resepObat,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function editResepObatNonRacikan(Request $request) {
		$resepObat = DB::table('resep_obat')
		->join('resep_type', 'resep_type.id_rt', '=', 'resep_obat.id_rt')
		->join('resep_aturan', 'resep_type.id_rt', '=', 'resep_aturan.id_rt')
		->where('resep_obat.id_ro', '=', $request->id_ro)
		->get();
		
		if ($resepObat) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $resepObat,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function editResepObatRacikan(Request $request) {
		$resepObat = DB::table('resep_obat')
		->join('resep_type', 'resep_type.id_rt', '=', 'resep_obat.id_rt')
		->where('resep_obat.id_ro', '=', $request->id_ro)
		->get();
		
		if ($resepObat) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $resepObat,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function updateResepObatNonRacikan(Request $request)
    {
	DB::begintransaction();
	try {
			
			$resepObat = resepObat::find($request->idRo);
			$resepObat->obat = $request->namaObat;
			$resepObat->save();
			
			$resepAturan = resepAturan::find($request->idRa);
			$resepAturan->siklus_ra = $request->siklusNonRacikan;
			$resepAturan->dosis_ra = $request->dosisNonRacikan;
			$resepAturan->jumlah = $request->jumlahNonRacikan;
			$resepAturan->keterangan = $request->keteranganNonRacikan;
			$resepAturan->save();
			DB::commit();
			return response()->json(['message' => 'Berhasil update obat.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function updateResepObatRacikan(Request $request)
    {
	DB::begintransaction();
	try {
			
			$resepObat = resepObat::find($request->idRo);
			$resepObat->obat = $request->namaObatRacikan;
			$resepObat->dosis = $request->dosisRacikan;
			$resepObat->unit = $request->unitRacikan;
			$resepObat->save();
			
			DB::commit();
			return response()->json(['message' => 'Berhasil update obat.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteResepObatNonRacikan(Request $request) {
		DB::begintransaction();
		try {
			//$deleteType = resepType::find($request->id_rt);
			//$deleteType->delete();
			$deleteType = DB::table("resep_type")->where("id_rt", $request->id_rt)->delete();
			$deleteObat = DB::table("resep_obat")->where("id_rt", $request->id_rt)->delete();
			$deleteAturan = DB::table("resep_aturan")->where("id_rt", $request->id_rt)->delete();
			
			//$deleteObat = resepObat::find($request->id_rt);
			//$deleteObat->delete();
			
			//$deleteAturan = resepAturan::find($request->id_rt);
			//$deleteAturan->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteResepObatRacikan(Request $request) {
		DB::begintransaction();
		try {
			$delete = resepObat::find($request->id_ro);
			if (!$delete->delete()) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => 'Gagal menyimpan delete transaksi'
				];
			}
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function updateStatusObatNonRacikan(Request $request)
    {
	DB::begintransaction();
	try {
			
			$resepObat =resepType::where(['id_antrian'=>$request->id_antrian,'jenis_obat'=>'Non Racikan'])
			->update(['status'=>2]);
			DB::commit();
			return response()->json(['message' => 'Berhasil update status.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
		
	public function getResepObatFinal(Request $request) {
			$resepType = DB::table('resep_type')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			
			$child_id=[];
			foreach ($resepType as $key => $ch){
				$id_rt = $ch->id_rt;
				$jenis = $ch->jenis_obat;
				$resepObat = DB::table('resep_obat')
				->where('id_rt', '=', $id_rt)
				->get();
				$aturanPakai = DB::table('resep_aturan')
				->where('id_rt', '=', $id_rt)
				->get();
				$child_id[$key] =[
				'data'=>$resepObat,
				'jenis'=>$jenis,
				'aturanPakai'=>$aturanPakai,
				'id'=>$id_rt,
				]; 
			}
			
			if ($resepType) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                //'resepObat' =>  $child_id,
				//'resepAturan' =>  $childs_id,
				'data' =>  $child_id
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function insertTindakanPasien(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();
			$tindakanPasien = new tindakanPasien;
			$tindakanPasien->id_antrian = $request->id_antrian;
			$tindakanPasien->tindakan = $request->tindakan;
			$tindakanPasien->icd_tindakan = $request->icd_tindakan;
			$tindakanPasien->reason = $request->reason;
			$tindakanPasien->icd_reason = $request->icd_reason;
			$tindakanPasien->catatan_tindakan = $request->catatan_tindakan;
			$tindakanPasien->save();
			DB::commit();
			return response()->json(['message' => 'berhasil insert tindakan ke database.....'], 200);
			
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function deleteTindakanPasien(Request $request) {
		DB::begintransaction();
		try {
			$deleteTindakan = DB::table("tindakan_pasien")->where("id_tindakan", $request->id_tindakan)->delete();
			
			DB::commit();
			return [
			'result' => TRUE,
			'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
			];
			} catch (Exception $e) {
			DB::rollback();
			return [
			'result' => FALSE,
			'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getTindakanPasien(Request $request) {
			$tindakanPasien = DB::table('tindakan_pasien')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			
			if ($tindakanPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $tindakanPasien,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}

		
	public function selectServiceOrder(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = serviceOrder::orderby('id_service','asc')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = serviceOrder::orderby('id_service','asc')
		 ->where('jenis_service', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['jenis_service']." - ".$pasien['biaya'],
			  
			  "id"=>$pasien->id_service,
			  "service"=>$pasien->jenis_service,
			  "biaya"=>$pasien->biaya,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
		
	public function insertServiceOrder(Request $request)
    {
	DB::begintransaction();
	try {
			//$dateNow = Carbon::now();
			$transaksiTindakan = new Transaksi;
			$transaksiTindakan->id_antrian = $request->id_antrian;
			$transaksiTindakan->jenis_transaksi = $request->transaksi;
			$transaksiTindakan->transaksi = "Jasa Dokter dan Tindakan";
			$biaya = $request->biaya;
			$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
			$diskon = $request->diskon;
			$nominalDiskon = $biayaReplace * ($diskon / 100);
			$transaksiTindakan->diskon = $nominalDiskon;
			$finalDiskon = $biayaReplace - $nominalDiskon;
			$qty = $request->qty;
			$transaksiTindakan->qty = $qty;
			$grandTotal = $finalDiskon * $qty;
			$transaksiTindakan->nominal = $grandTotal;
			$transaksiTindakan->jenis_pembayaran = $request->jenis_pembayaran;
			$transaksiTindakan->save();
			DB::commit();
			return response()->json(['message' => 'berhasil insert transaksi ke database.....'], 200);
			
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getDokterInstruksi(Request $request) {
			$dataDokter = DB::table('data_dokter')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->join('data_antrian', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_dokter.nama_dokter', 'data_dokter.id_dokter')
			->where('data_antrian.id_antrian', '=', $request->id_antrian)
			->get();
			
			if ($dataDokter) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataDokter,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function insertKontrolPasien(Request $request)
		{
		DB::begintransaction();
		try {
				//$dateNow = Carbon::now();
				$kontrolPasien = new kontrolPasien;
				$kontrolPasien->id_antrian = $request->id_antrian;
				$kontrolPasien->kontrol_ke = $request->kontrol_ke;
				$kontrolPasien->tanggal_kontrol = $request->tanggal_kontrol;
				$kontrolPasien->kontak_darurat = $request->kontak_darurat;
				$kontrolPasien->save();
				DB::commit();
				return response()->json(['message' => 'berhasil insert Kontrol ke database.....'], 200);
				
				
				} catch (Exception $e) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function getKontrolPasien(Request $request) {
			$dataKontrol = DB::table('kontrol_pasien')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			
			if ($dataKontrol) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataKontrol,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	/*public function getHistoryKunjungan(Request $request) {
			$historyKunjungan = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_antrian.tanggal_reg')
			->where('data_antrian.id_pasien', '=', $request->id_pasien)
			->orderBy('data_antrian.tanggal_reg','DESC')   
			->get();
			
			if ($historyKunjungan) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $historyKunjungan,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}*/
		
	public function getHistoryKunjungan(Request $request){

	  $search = $request->search;

	  if($search == ''){
		 $dataPasien = Antrian::orderby('tanggal_reg','asc')
		 ->join('data_pasien', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
		 ->where('data_antrian.id_pasien', '=', $request->id_pasien)
		 ->select('data_antrian.id_pasien','data_antrian.tanggal_reg')
		 ->limit(5)
		 ->get();
	  }else{
		 $dataPasien = Antrian::orderby('tanggal_reg','asc')
		 ->join('data_pasien', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
		 ->select('data_antrian.id_pasien','data_antrian.tanggal_reg')
		 ->where('data_antrian.id_pasien', '=', $request->id_pasien)
		 ->where('data_antrian.tanggal_reg', 'like', '%' .$search . '%')
		 ->limit(5)
		 ->get();
	  }

	  $response = array();
	  foreach($dataPasien as $pasien){
		 $response[] = array(
			  $gabungan = $pasien['tanggal_reg'],
			  
			  "id"=>$pasien->id_pasien,
			  "tanggal"=>$pasien->tanggal_reg,
			  "text"=>$gabungan
		 );
	  }

	  return response()->json($response);
	}
		
	public function getDatahistory(Request $request) {
		$keluhanUtama = DB::table('keluhan_utama')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'keluhan_utama.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$allergyPasien = DB::table('allergy_pasien')
		->join('m_allergy', 'm_allergy.id_allergy', '=', 'allergy_pasien.id_allergy')
		->join('m_manifest_allergy', 'm_manifest_allergy.id_manifest_allergy', '=', 'allergy_pasien.id_manifest_allergy')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'allergy_pasien.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$kesadaranPasien = DB::table('tingkat_kesadaran_pasien')
		->join('m_tingkat_kesadaran', 'm_tingkat_kesadaran.id_tingkat_kesadaran', '=', 'tingkat_kesadaran_pasien.id_tingkat_kesadaran')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'tingkat_kesadaran_pasien.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$pemeriksaanFisikPasien = DB::table('pemeriksaan_fisik_pasien')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'pemeriksaan_fisik_pasien.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$statusLokalisPasien = DB::table('status_lokalis_pasien')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'status_lokalis_pasien.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$historyKeluhanPrimer = DB::table('keluhan_primer')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'keluhan_primer.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$historyKeluhanSekunder = DB::table('keluhan_sekunder')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'keluhan_sekunder.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$resepType = DB::table('resep_type')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'resep_type.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$child_id=[];
		foreach ($resepType as $key => $ch){
			$id_rt = $ch->id_rt;
			$jenis = $ch->jenis_obat;
			$resepObat = DB::table('resep_obat')
			->where('id_rt', '=', $id_rt)
			->get();
			$aturanPakai = DB::table('resep_aturan')
			->where('id_rt', '=', $id_rt)
			->get();
			$child_id[$key] =[
			'data'=>$resepObat,
			'jenis'=>$jenis,
			'aturanPakai'=>$aturanPakai,
			'id'=>$id_rt,
			]; 
		}
		$historyTindakan = DB::table('tindakan_pasien')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'tindakan_pasien.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$historyTransaksi = DB::table('data_transaksi')
		->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		$historyKontrol = DB::table('kontrol_pasien')
		->join('data_antrian', 'data_antrian.id_antrian', '=', 'kontrol_pasien.id_antrian')
		->where('data_antrian.id_pasien', '=', $request->id_pasien)
		->where('data_antrian.tanggal_reg', '=', $request->tanggal_kunjungan)
		->get();
		
		if ($keluhanUtama) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $child_id,
			'keluhanUtama' =>  $keluhanUtama,
			'allergyPasien' =>  $allergyPasien,
			'kesadaranPasien' =>  $kesadaranPasien,
			'pemeriksaanFisikPasien' =>  $pemeriksaanFisikPasien,
			'statusLokalisPasien' =>  $statusLokalisPasien,
			'historyKeluhanPrimer' =>  $historyKeluhanPrimer,
			'historyKeluhanSekunder' =>  $historyKeluhanSekunder,
			'historyTindakan' =>  $historyTindakan,
			'historyTransaksi' =>  $historyTransaksi,
			'historyKontrol' =>  $historyKontrol,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
		
	public function getPasienActual(Request $request) {
		$dataPasien = DB::table('data_pasien')
		->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
		->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
		->select('data_pasien.nama_pasien','data_pasien.nomer_rm','data_antrian.no_antrian','data_antrian.id_antrian','data_antrian.status','data_antrian.confirmed')
		->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
		//->where('jadwal_poli.tanggal', '=', "2022-01-05")
		->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
		->orderBy('data_antrian.id_antrian','asc')
		->get();
		
		if ($dataPasien) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $dataPasien,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function resumeTransaksiByMonth(Request $request) {
			$monthNow = $request->monthNow;
			$yearNow = $request->yearNow;
			$dokter = DB::table('data_dokter')
			->select('data_dokter.nama_dokter','data_dokter.id_dokter')
			->where('id_dokter', '=', $request->id_dokter)
			//->groupBy('data_dokter.id_dokter')
			->get();
			$child_id=[];
			foreach ($dokter as $key => $ch){
				$namaDokter = $ch->nama_dokter;
				$idDokter = $ch->id_dokter;
				$jadwal = DB::table('jadwal_poli')
				->select('tanggal','jam_buka','id_jadwal','status')
				->where('id_dokter', '=', $idDokter)
				->whereMonth('tanggal', '=', $monthNow)
				->whereYear('tanggal', '=', $yearNow)
				//->groupBy('tanggal')
				->get();
				$jumlahPasienGrandTotal =  DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
				->whereYear('jadwal_poli.tanggal', '=', $yearNow)
				->count();
				$GrandTotal = DB::table('data_transaksi')
				->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
				->whereYear('jadwal_poli.tanggal', '=', $yearNow)
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->sum('data_transaksi.nominal');
				$pendapatanKlinik = $GrandTotal*(30/100);
				$pendapatanDokter = $GrandTotal-$pendapatanKlinik;
					$childs_id=[];
					foreach ($jadwal as $keys => $chs){
						$idJadwal = $chs->id_jadwal;
						$status = $chs->status;
						$tanggal = $chs->tanggal;
						$jamBuka = $chs->jam_buka;
						/*$jumlahPasienTotal =  DB::table('data_pasien')
						->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
						->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
						->where('data_antrian.status', '=', 4)
						//->where('jadwal_poli.id_jadwal', '=', $idJadwal)
						->where('jadwal_poli.id_dokter', '=', $idDokter)
						//->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
						//->whereYear('jadwal_poli.tanggal', '=', $yearNow)
						->count();*/
						$jumlahPasienTotal =  DB::table('data_antrian')
						->where('data_antrian.status', '=', 4)
						->where('data_antrian.id_jadwal', '=', $idJadwal)
						->count();
						$subTotal = DB::table('data_transaksi')
						->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
						->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
						->where('data_antrian.status', '=', 4)
						->where('jadwal_poli.id_jadwal', '=', $idJadwal)
						->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
						->sum('data_transaksi.nominal');
						$tigaPuluhPersen = $subTotal*(30/100);
						$JasaDanKonsultasiBersih = $subTotal-$tigaPuluhPersen;
						
						$childs_id[$keys] =[
						'idJadwal'=>$idJadwal,
						'status'=>$status,
						'tanggal'=>$tanggal,
						'jamBuka'=>$jamBuka,
						'jumlahPasienTotal'=>$jumlahPasienTotal,
						'subTotal'=>$subTotal,
						'pendapatanDokter' => $JasaDanKonsultasiBersih,
						'pendapatanKlinik' => $tigaPuluhPersen,
						]; 
					}
				$child_id[$key] =[
				'dokter'=>$namaDokter,
				'jumlahPasienGrandTotal'=>$jumlahPasienGrandTotal,
				'GrandTotal'=>$GrandTotal,
				'pendapatanDokter'=>$pendapatanDokter,
				'pendapatanKlinik'=>$pendapatanKlinik,
				'jadwal'=>$childs_id,
				]; 
			}
			if ($dokter) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function resumeTransaksiByMonthAdmin(Request $request) {
			$monthNow = $request->monthNow;
			$yearNow = $request->yearNow;
			$dokter = DB::table('data_dokter')
			->join('jadwal_poli', 'jadwal_poli.id_dokter', '=', 'data_dokter.id_dokter')
			->select('jadwal_poli.id_dokter','data_dokter.nama_dokter')
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			//->where('id_dokter', '=', 15)
			->groupBy('jadwal_poli.id_dokter')
			->get();
			$child_id=[];
			foreach ($dokter as $key => $ch){
				$namaDokter = $ch->nama_dokter;
				$idDokter = $ch->id_dokter;
				$jadwal = DB::table('jadwal_poli')
				->select('tanggal','jam_buka','id_jadwal','status')
				->where('id_dokter', '=', $idDokter)
				->whereMonth('tanggal', '=', $monthNow)
				->whereYear('tanggal', '=', $yearNow)
				//->groupBy('tanggal')
				->get();
				$jumlahPasienGrandTotal =  DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
				->whereYear('jadwal_poli.tanggal', '=', $yearNow)
				->count();
				$GrandTotal = DB::table('data_transaksi')
				->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
				->whereYear('jadwal_poli.tanggal', '=', $yearNow)
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->sum('data_transaksi.nominal');
				$pendapatanKlinik = $GrandTotal*(30/100);
				$pendapatanDokter = $GrandTotal-$pendapatanKlinik;
					$childs_id=[];
					foreach ($jadwal as $keys => $chs){
						$idJadwal = $chs->id_jadwal;
						$status = $chs->status;
						$tanggal = $chs->tanggal;
						$jamBuka = $chs->jam_buka;
						/*$jumlahPasienTotal =  DB::table('data_pasien')
						->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
						->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
						->where('data_antrian.status', '=', 4)
						//->where('jadwal_poli.id_jadwal', '=', $idJadwal)
						->where('jadwal_poli.id_dokter', '=', $idDokter)
						//->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
						//->whereYear('jadwal_poli.tanggal', '=', $yearNow)
						->count();*/
						$jumlahPasienTotal =  DB::table('data_antrian')
						->where('data_antrian.status', '=', 4)
						->where('data_antrian.id_jadwal', '=', $idJadwal)
						->count();
						$subTotal = DB::table('data_transaksi')
						->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
						->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
						->where('data_antrian.status', '=', 4)
						->where('jadwal_poli.id_jadwal', '=', $idJadwal)
						->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
						->sum('data_transaksi.nominal');
						$tigaPuluhPersen = $subTotal*(30/100);
						$JasaDanKonsultasiBersih = $subTotal-$tigaPuluhPersen;
						
						$childs_id[$keys] =[
						'idJadwal'=>$idJadwal,
						'status'=>$status,
						'tanggal'=>$tanggal,
						'jamBuka'=>$jamBuka,
						'jumlahPasienTotal'=>$jumlahPasienTotal,
						'subTotal'=>$subTotal,
						'pendapatanDokter' => $JasaDanKonsultasiBersih,
						'pendapatanKlinik' => $tigaPuluhPersen,
						]; 
					}
				$child_id[$key] =[
				'dokter'=>$namaDokter,
				'jumlahPasienGrandTotal'=>$jumlahPasienGrandTotal,
				'GrandTotal'=>$GrandTotal,
				'pendapatanDokter'=>$pendapatanDokter,
				'pendapatanKlinik'=>$pendapatanKlinik,
				'jadwal'=>$childs_id,
				]; 
			}
			if ($dokter) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function resumeTransaksiByDay(Request $request) {
			$dateNow = Carbon::now()->format('Y-m-d');
			$dokter = DB::table('data_dokter')
			->select('data_dokter.nama_dokter','data_dokter.id_dokter')
			->where('id_dokter', '=', $request->id_dokter)
			//->groupBy('data_dokter.id_dokter')
			->get();
			$child_id=[];
			foreach ($dokter as $key => $ch){
				$namaDokter = $ch->nama_dokter;
				$idDokter = $ch->id_dokter;
				$jadwal = DB::table('jadwal_poli')
				->select('tanggal','jam_buka','id_jadwal','status')
				->where('id_dokter', '=', $idDokter)
				->where('tanggal', '=', $dateNow)
				//->groupBy('tanggal')
				->get();
				$jumlahPasienGrandTotal =  DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->where('jadwal_poli.tanggal', '=', $dateNow)
				->count();
				$GrandTotal = DB::table('data_transaksi')
				->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->where('jadwal_poli.tanggal', '=', $dateNow)
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->sum('data_transaksi.nominal');
				$pendapatanKlinik = $GrandTotal*(30/100);
				$pendapatanDokter = $GrandTotal-$pendapatanKlinik;
					$childs_id=[];
					foreach ($jadwal as $keys => $chs){
						$idJadwal = $chs->id_jadwal;
						$status = $chs->status;
						$tanggal = $chs->tanggal;
						$jamBuka = $chs->jam_buka;
						$jumlahPasienTotal =  DB::table('data_antrian')
						//->where('data_antrian.status', '=', 4)
						->where('data_antrian.id_jadwal', '=', $idJadwal)
						->count();
						$subTotal = DB::table('data_transaksi')
						->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
						->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
						->where('data_antrian.status', '=', 4)
						->where('jadwal_poli.id_jadwal', '=', $idJadwal)
						->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
						->sum('data_transaksi.nominal');
						$tigaPuluhPersen = $subTotal*(30/100);
						$JasaDanKonsultasiBersih = $subTotal-$tigaPuluhPersen;
						
						$childs_id[$keys] =[
						'status'=>$status,
						'idJadwal'=>$idJadwal,
						'tanggal'=>$tanggal,
						'jamBuka'=>$jamBuka,
						'jumlahPasienTotal'=>$jumlahPasienTotal,
						'subTotal'=>$subTotal,
						'pendapatanDokter' => $JasaDanKonsultasiBersih,
						'pendapatanKlinik' => $tigaPuluhPersen,
						]; 
					}
				$child_id[$key] =[
				'dokter'=>$namaDokter,
				'jumlahPasienGrandTotal'=>$jumlahPasienGrandTotal,
				'GrandTotal'=>$GrandTotal,
				'pendapatanDokter'=>$pendapatanDokter,
				'pendapatanKlinik'=>$pendapatanKlinik,
				'jadwal'=>$childs_id,
				]; 
			}
			if ($dokter) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
	public function resumeTransaksiByDayAdmin(Request $request) {
			$dateNow = Carbon::now()->format('Y-m-d');
			$dokter = DB::table('data_dokter')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter','data_dokter.id_dokter')
			->where('jadwal_poli.tanggal', '=', $dateNow)
			//->where('id_dokter', '=', 15)
			//->groupBy('data_dokter.id_dokter')
			->get();
			$child_id=[];
			foreach ($dokter as $key => $ch){
				$namaDokter = $ch->nama_dokter;
				$idDokter = $ch->id_dokter;
				$jadwal = DB::table('jadwal_poli')
				->select('tanggal','jam_buka','id_jadwal','status')
				->where('id_dokter', '=', $idDokter)
				->where('tanggal', '=', $dateNow)
				//->groupBy('tanggal')
				->get();
				$jumlahPasienGrandTotal =  DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->where('jadwal_poli.tanggal', '=', $dateNow)
				->count();
				$GrandTotal = DB::table('data_transaksi')
				->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->where('jadwal_poli.tanggal', '=', $dateNow)
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->sum('data_transaksi.nominal');
				$pendapatanKlinik = $GrandTotal*(30/100);
				$pendapatanDokter = $GrandTotal-$pendapatanKlinik;
					$childs_id=[];
					foreach ($jadwal as $keys => $chs){
						$idJadwal = $chs->id_jadwal;
						$status = $chs->status;
						$tanggal = $chs->tanggal;
						$jamBuka = $chs->jam_buka;
						$jumlahPasienTotal =  DB::table('data_antrian')
						//->where('data_antrian.status', '=', 4)
						->where('data_antrian.id_jadwal', '=', $idJadwal)
						->count();
						$subTotal = DB::table('data_transaksi')
						->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
						->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
						->where('data_antrian.status', '=', 4)
						->where('jadwal_poli.id_jadwal', '=', $idJadwal)
						->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
						->sum('data_transaksi.nominal');
						$tigaPuluhPersen = $subTotal*(30/100);
						$JasaDanKonsultasiBersih = $subTotal-$tigaPuluhPersen;
						
						$childs_id[$keys] =[
						'status'=>$status,
						'idJadwal'=>$idJadwal,
						'tanggal'=>$tanggal,
						'jamBuka'=>$jamBuka,
						'jumlahPasienTotal'=>$jumlahPasienTotal,
						'subTotal'=>$subTotal,
						'pendapatanDokter' => $JasaDanKonsultasiBersih,
						'pendapatanKlinik' => $tigaPuluhPersen,
						]; 
					}
				$child_id[$key] =[
				'dokter'=>$namaDokter,
				'jumlahPasienGrandTotal'=>$jumlahPasienGrandTotal,
				'GrandTotal'=>$GrandTotal,
				'pendapatanDokter'=>$pendapatanDokter,
				'pendapatanKlinik'=>$pendapatanKlinik,
				'jadwal'=>$childs_id,
				]; 
			}
			if ($dokter) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
	public function resumeTransaksi(Request $request) {
			$monthNow = $request->monthNow;
			$yearNow = $request->yearNow;
			$dokter = DB::table('data_dokter')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter','data_dokter.id_dokter')
			->groupBy('data_dokter.id_dokter')
			->get();
			$child_id=[];
			foreach ($dokter as $key => $ch){
				$namaDokter = $ch->nama_dokter;
				$idDokter = $ch->id_dokter;
				$jumlahPasienTotal =  DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				//->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
				->whereYear('jadwal_poli.tanggal', '=', $yearNow)
				->count();
				$sumKonsul = DB::table('data_transaksi')
				->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
				->whereYear('jadwal_poli.tanggal', '=', $yearNow)
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->sum('data_transaksi.nominal');
				$tigaPuluhPersen = $sumKonsul*(30/100);
				$JasaDanKonsultasiBersih = $sumKonsul-$tigaPuluhPersen;
				$child_id[$key] =[
				'dokter'=>$namaDokter,
				'totalKonsul'=>$sumKonsul,
				'jumlahPasien' => $jumlahPasienTotal,
				'pendapatanDokter' => $JasaDanKonsultasiBersih,
				'pendapatanKlinik' => $tigaPuluhPersen,
				]; 
			}
			if ($dokter) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
	public function updateStatusJadwal(Request $request)
    {
	DB::begintransaction();
	try {
			$jadwalDokter = jadwalDokter::find($request->id_jadwal);
			$jadwalDokter->status = $request->status;
			$jadwalDokter->save();
			DB::commit();
			return response()->json(['message' => 'berhasil update Status Lokalis ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getPasienPanggil(Request $request) {
			$dataPasienPanggil = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->join('keluhan_utama', 'data_antrian.id_antrian', '=', 'keluhan_utama.id_antrian')
			//->select('data_pasien.id_pasien','data_pasien.nama_pasien','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.jenis_kelamin','data_pasien.tanggal_lahir','data_antrian.no_antrian','data_antrian.id_antrian','data_antrian.status','data_antrian.confirmed','data_antrian.keluhan_awal','data_antrian.anamnesa')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 3)
			->orderBy('data_antrian.id_antrian','asc')
			->get();
			
			/*$child_id=[];
			foreach ($dataPasienPanggil as $key => $ch){
				$nama = $ch->nama_pasien;
				$kelamin = $ch->jenis_kelamin;
				$tanggalLahir = $ch->tanggal_lahir;
				$rm = $ch->nomer_rm;
				//$keluhanKu = $ch->keterangan_ku;
				//$freeTextKu = = $ch->free_text_ku;
			
				$child_id[$key] =[
				'nama'=>$nama,
				'kelamin'=>$kelamin,
				'tanggalLahir'=>$tanggalLahir,
				'rm'=>$rm,
				//'keluhanKu'=>$keluhanKu,
				//'freeTextKu'=>$freeTextKu,
				]; 
			}*/
			
			if ($dataPasienPanggil) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				//'data' =>  $child_id,
				'data' => $dataPasienPanggil,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getDaftarJadwal(Request $request)
    {	$currentMonth = $request->currentMonth;
		$currentYear = $request->currentYear;
		$jadwal = DB::table('jadwal_poli')
		->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
		->whereMonth('tanggal', '=', $currentMonth)
		->whereYear('tanggal', '=', $currentYear)
		->where('jadwal_poli.id_dokter', '=', $request->id_dokter) 
		->orderBy('jadwal_poli.id_jadwal','DESC')   
		//->limit(5)
		->get();
		if ($jadwal) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' => $jadwal,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
           
    }
	
	public function editDaftarJadwal(Request $request)
    {	$jadwal = DB::table('jadwal_poli')
		->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
		->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal) 
		->get();
		if ($jadwal) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' => $jadwal,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
           
    }
	
	public function updateJadwalPoli(Request $request)
    {
	DB::begintransaction();
	try {
			$jadwalPoli = jadwalDokter::find($request->id_jadwal);
			$jadwalPoli->id_dokter = $request->id_dokter;
			$jadwalPoli->tanggal = $request->tanggal;
			$jadwalPoli->hari = $request->hari;
			$jadwalPoli->jam_buka = $request->jam_buka;
			$jadwalPoli->jam_tutup = $request->jam_tutup;
			$jadwalPoli->save();
			DB::commit();
			return response()->json(['message' => 'berhasil update ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function updateStatusPemeriksaanFisik(Request $request)
    {
	DB::begintransaction();
	try {
			$jadwalPoli = Antrian::find($request->id_antrian);
			$jadwalPoli->pemeriksaan_fisik = "sudah diperiksa";
			$jadwalPoli->save();
			DB::commit();
			return response()->json(['message' => 'berhasil update pemeriksaan ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function getPasienReservasi(Request $request)
    {	//$currentMonth = $request->currentMonth;
		//$currentYear = $request->currentYear;
		$reservasi = DB::table('data_reservasi')
		->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_reservasi.id_jadwal')
		->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
		//->whereMonth('tanggal', '=', $currentMonth)
		//->whereYear('tanggal', '=', $currentYear)
		//->orderBy('jadwal_poli.id_jadwal','DESC')   
		//->limit(5)
		->get();
		if ($reservasi) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' => $reservasi,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
           
    }
	
	public function getDokterReservasi(Request $request)
    {	$reservasi = DB::table('jadwal_poli')
		->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
		->join('data_poli', 'data_poli.id_poli', '=', 'data_dokter.id_poli')
		->where('jadwal_poli.tanggal', '=', $request->filterTanggal)
		->where('data_poli.id_poli', '=', $request->id_poli)
		->orderBy('jadwal_poli.id_jadwal','ASC')  
		->get();
		if ($reservasi) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' => $reservasi,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
           
    }
	
	public function checkIn(Request $request)
    {
	DB::begintransaction();
	try {
			
			$checkIn = DB::table('data_reservasi')
            ->where('id_reservasi', $request->id_reservasi)
            ->update(['checkin' => "check"]);
			DB::commit();
			return response()->json(['message' => 'Berhasil update status.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function insertReservasiPasien(Request $request)
    {
	DB::begintransaction();
	try {
				DB::table('data_reservasi')->insert([
					'id_jadwal' => $request->id_jadwal,
					'nama_pasien' => $request->nama_pasien,
					'nik' => $request->	nik,
					'no_rm' => $request->no_rm,
					'no_telp' => $request->no_telp,
				]);
				DB::commit();
				return response()->json(['message' => 'berhasil insert Reservasi ke database.....'], 200);
			
			} catch (Exception $e) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
			];
		}
	}
	
	public function countReservasi(Request $request) {
			$dataReservasi = DB::table('data_reservasi')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_reservasi.id_jadwal')
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->count();
			if ($dataReservasi) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataReservasi
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getPoli(Request $request) {
			$getPoli = DB::table('data_poli')
			->join('data_dokter', 'data_dokter.id_poli', '=', 'data_poli.id_poli')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->groupBy('data_poli.id_poli')
			->get();
			
			if ($getPoli) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $getPoli,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
	
	public function getPoliReservasi(Request $request) {
			$getPoli = DB::table('data_poli')
			->join('data_dokter', 'data_dokter.id_poli', '=', 'data_poli.id_poli')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->where('jadwal_poli.tanggal', '=', $request->filterTanggal)
			->groupBy('data_poli.id_poli')
			->get();
			
			if ($getPoli) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $getPoli,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
	public function getPoliReservasiDokter(Request $request) {
			$getPoli = DB::table('data_poli')
			->join('data_dokter', 'data_dokter.id_poli', '=', 'data_poli.id_poli')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->where('jadwal_poli.tanggal', '=', $request->filterTanggal)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->groupBy('data_poli.id_poli')
			->get();
			
			if ($getPoli) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $getPoli,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getStetoschope(Request $request) {
			$dataStetoschope = DB::table('m_stetoschope')
			->join('data_poli', 'data_poli.id_poli', '=', 'm_stetoschope.id_poli')
			->where('data_poli.id_poli', '=', $request->id_poli)
			->get();
			/*$idDokter = DB::table('data_dokter')
			->where('id_dokter', '=', $request->id_dokter)
			->get();*/
			if ($dataStetoschope) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataStetoschope,
				//'id' =>  $idDokter
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getPemeriksaanStetoschope(Request $request) {
			$dataPemeriksaanStetoschope = DB::table('m_stetoschope')
			->join('pemeriksaan_stethoscope', 'm_stetoschope.id_stetoschope', '=', 'pemeriksaan_stethoscope.id_stetoschope')
			->where('pemeriksaan_stethoscope.id_antrian', '=', $request->id_antrian)
			->where('pemeriksaan_stethoscope.id_stetoschope', '=', $request->id_stetoschope)
			->get();
			if ($dataPemeriksaanStetoschope) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataPemeriksaanStetoschope,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
}
