<?php

namespace App\Http\Controllers;
	use Carbon\Carbon;
	use DataTables;
	use Illuminate\Http\Request;
	use Auth;
	use App\Models\Registrasi;
	use App\Models\Rfid;
	use App\Models\Antrian;
	use App\Models\Transaksi;
	use App\Models\TindakanPasien;
	use App\Models\resepObat;
	use App\Models\dataPasien;
	use App\Models\masterPenyakitPasien;
	use App\Models\masterObat;
	use App\Models\masterTindakan;
	use App\Models\penyakitPasien;
	use App\Models\antrianRad;
	use App\Models\transaksiLab;
	use App\Models\dokterPerujuk;
	use App\Models\jadwalDokter;
	use Illuminate\Support\Facades\DB;

class serviceController extends Controller
{
    public function storeJadwalDokter(Request $request) {
			DB::begintransaction();
			try {
				//Data jadwal
				$jadwal = new jadwalDokter;
				$jadwal->id_dokter = $request->id_dokter;
				$jadwal->jam_buka = $request->jam_buka;
				$jadwal->jam_tutup = $request->jam_tutup;
				$jadwal->tanggal = $request->tanggal;
				
				if (!$jadwal->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data jadwal'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $jadwal
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data jadwal ke database. Memuat ulang halaman...',
                    'jadwal' => $jadwal
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
	
	public function getDatatablePasien(Request $request)
    {
       // if ($request->ajax()) {
            $data = DB::table('data_pasien')
			->select('nama_pasien','nomer_rm','alamat_ktp','no_telp')
			->orderBy('nomer_rm','DESC')   
			->get();
            return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function($row){
   
                           $btn = '<a href="javascript:void(0)" class="edit btn btn-primary btn-sm">View</a>';
     
                            return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
        //}
       // return view('users');
    }
	
	public function ss_processing(Request $request)
	{
		//to use parameter or variable sent from ajax view
		$params = $request->params;
	 
		$whereClause = $params['sac'];
	 
		$query = DB::table('data_pasien')->orderBy('nomer_rm','DESC') ;
		//$age = \Carbon\Carbon::parse($query->tanggal_lahir)->diff(\Carbon\Carbon::now())->format('%y years, %m months and %d days');
		
		return Datatables::of($query)
                    ->addIndexColumn()
                    ->addColumn('action', function($query){
                        $btn = '<a style="width:50%;color:#fff;" class="btn btn-warning" >Edit Profil</a> I <a style="width:50%;color:#fff;" class="btn btn-info" onclick="transaksiPasien(\''.$query->id_pasien.'\')">Transaksi</a>';
						
						return $btn;
                    })
					->addColumn('age', function($query){
                        return  \Carbon\Carbon::parse($query->tanggal_lahir)->diff(\Carbon\Carbon::now())->format('%y thn %m bln %d hr');
					})
                    ->rawColumns(['action'])
                    ->make(true);
	}
	
	public function getDataDokterPoli(Request $request) {
		$dataDokter = DB::table('data_dokter')
			->join('data_poli', 'data_poli.id_poli', '=', 'data_dokter.id_poli')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.id_dokter','data_dokter.nama_dokter','jadwal_poli.tanggal','jadwal_poli.id_jadwal','jadwal_poli.jam_buka','jadwal_poli.jam_tutup','data_poli.nama_poli','jadwal_poli.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->orderBy('jadwal_poli.id_jadwal','ASC')   
			->get();
		if ($dataDokter) {
			return [
			'message' => 'Berhasil Mengambil Data',
			'status' => 1,
			'data' =>  $dataDokter,
			];
			} else {
			return [
			'message' => 'Gagal Mengambil Data',
			'status' => 0
			];
		}
	}
	
	public function showDataDokter(Request $request) {
			//$idDokter = Dokter::where("id_dokter",$request->id_dokter)->get();
			$dataDokter = DB::table('data_dokter')
			->join('data_poli', 'data_poli.id_poli', '=', 'data_dokter.id_poli')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.id_dokter','data_dokter.nama_dokter','jadwal_poli.tanggal','jadwal_poli.id_jadwal','jadwal_poli.jam_buka','jadwal_poli.jam_tutup','data_poli.nama_poli','jadwal_poli.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			//->where('jadwal_poli.tanggal', '=', "2022-01-05")
			//->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->orderBy('jadwal_poli.id_jadwal','ASC')   
			->get();
			$idDokter = DB::table('data_dokter')
			->where('id_dokter', '=', $request->id_dokter)
			->get();
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->get();
			$servings = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 4 )
			->get();
			$served = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 5 )
			->count();
			$registered = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->count();
			if ($dataDokter) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataDokter,
				'id' =>  $idDokter,
                'registered' => $registered
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function showDataPerujuk() {
			//$idDokter = Dokter::where("id_dokter",$request->id_dokter)->get();
			$dataDokter = DB::table('data_dokter')
			->where('data_dokter.id_poli', '=', 0)
			->get();
			if ($dataDokter) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataDokter
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function showDataPasien(Request $request) {
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_pasien.nomer_rm','data_antrian.no_antrian','data_antrian.id_antrian','data_antrian.status','data_antrian.confirmed','data_antrian.pemeriksaan_fisik','data_antrian.pemeriksaan_dokter')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			//->where('jadwal_poli.tanggal', '=', "2022-01-05")
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('data_antrian.id_antrian','asc')
			->get();
			$dataPasienPanggil = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.id_pasien','data_pasien.nama_pasien','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.jenis_kelamin','data_pasien.tanggal_lahir','data_antrian.no_antrian','data_antrian.id_antrian','data_antrian.status','data_antrian.confirmed','data_antrian.keluhan_awal','data_antrian.pemeriksaan_fisik')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 3)
			->orderBy('data_antrian.id_antrian','asc')
			->get();
			$dataPasienAll = DB::table('data_pasien')
			//->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			//->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.id_pasien','data_pasien.nama_pasien','data_pasien.rf_id','data_pasien.nomer_rm')
			->get();
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataPasien,
				'dataPasienAll' =>  $dataPasienAll,
				'dataPasienPanggil' =>  $dataPasienPanggil
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function showDataPasienDisplay(Request $request) {
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			//->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('data_antrian.status', '!=', 4)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('data_antrian.id_antrian','asc')
			->get();
			$displayName = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien')
			//->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('data_antrian.status', '=', 1)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->get();
			$servings = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_antrian.id_antrian','data_antrian.no_antrian')
			//->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('data_antrian.status', '=', 3)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->get();
			
			$child_id=[];
			foreach ($servings as $key => $ch){
				$idAntrian = $ch->id_antrian;
				$nextCall = DB::table('data_antrian')
				->where('data_antrian.id_antrian', '>', $idAntrian)
				->select('data_antrian.no_antrian')
				->min('no_antrian');
				$child_id[$key] =[
				'next'=>$nextCall,
				]; 
			}
			
			if ($dataPasien) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataPasien,
				'displayName' =>  $displayName,
				'servings' =>  $servings,
				'nextCall' =>  $child_id,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataTindakan() {
			$dataTindakan = DB::table('data_tindakan')
			->select('id_tindakan','jenis_tindakan','biaya')
			->get();
			if ($dataTindakan) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataTindakan
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		
		
		public function getDataObat() {
			$dataObat = DB::table('data_obat')
			->select('id_obat','jenis_obat')
			->get();
			if ($dataObat) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataObat
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataPenyakit() {
			$dataPenyakit = DB::table('data_penyakit')
			->select('id_penyakit','jenis_penyakit')
			->get();
			if ($dataPenyakit) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataPenyakit
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDetailTindakan(Request $request) {
			$detailTindakan = DB::table('data_tindakan')
			->select('id_tindakan','jenis_tindakan','biaya')
			->where('id_tindakan', '=', $request->id_tindakan)
			->get();
			if ($detailTindakan) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $detailTindakan
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		
		public function getDetailObat(Request $request) {
			$detailObat = DB::table('data_obat')
			->select('id_obat','jenis_obat','biaya')
			->where('id_obat', '=', $request->id_obat)
			->get();
			if ($detailObat) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $detailObat
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDetailPenyakit(Request $request) {
			$detailPenyakit = DB::table('data_penyakit')
			->select('id_penyakit','jenis_penyakit')
			->where('id_penyakit', '=', $request->id_penyakit)
			->get();
			if ($detailPenyakit) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $detailPenyakit
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		/*public function countTransaksiPasien (Request $request){
			$cekPasienBaru = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_pasien.tanggal_reg')
			->where('data_antrian.id_pasien', '=', $request->id_pasien)
			->first();
			$pasienBaruNow = $cekPasienBaru->tanggal_reg;
			$dateNow = Carbon::now()->format('d-m-Y');
			if ($dateNow == $pasienBaruNow){
					$pendaftaran = new Transaksi;
					$pendaftaran->id_antrian = $request->id_antrian;
					$pendaftaran->transaksi = "Pendaftaran";
					$pendaftaran->jenis_transaksi = "pendaftaran";
					$pendaftaran->nominal = 25000;
					$pendaftaran->jenis_pembayaran = "cash";
					$pendaftaran->save();
				}
			if ($pendaftaran) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $cekPasienBaru,
				'dateNow' =>  $dateNow,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}*/
		
		public function countTransaksiPasien(Request $request) {
			DB::begintransaction();
			try {
				$cekPasienBaru = DB::table('data_pasien')
				->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
				->select('data_pasien.tanggal_reg')
				->where('data_antrian.id_pasien', '=', $request->id_pasien)
				->first();
				$pasienBaruNow = $cekPasienBaru->tanggal_reg;
				$dateNow = Carbon::now()->format('d-m-Y');
				//Data transaksi
				if ($pasienBaruNow == $dateNow){
				$pendaftaran = new Transaksi;
				$pendaftaran->id_antrian = $request->id_antrian;
				$pendaftaran->transaksi = "Pendaftaran";
				$pendaftaran->jenis_transaksi = "pendaftaran";
				$pendaftaran->nominal = 25000;
				$pendaftaran->jenis_pembayaran = "cash";
				$pendaftaran->save();
				}
				if ($pendaftaran) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
			
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $pendaftaran
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $pendaftaran
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeTransaksi(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				$transaksi = new Transaksi;
				$transaksi->id_antrian = $request->id_antrian;
				$transaksi->transaksi = $request->transaksi;
				$transaksi->jenis_transaksi = $request->jenis_transaksi;
				$biaya = $request->biaya;
				$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
				$diskon = $request->diskon;
				$nominalDiskon = $biayaReplace * ($diskon / 100);
				$transaksi->diskon = $nominalDiskon;
				$finalDiskon = $biayaReplace - $nominalDiskon;
				$transaksi->nominal = $finalDiskon;
				$transaksi->jenis_pembayaran = $request->jenis_pembayaran;
				/*$dateNow = Carbon::now()->format('Y-m-d');
				$cekPasienBaru = DB::table('data_pasien')
				->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
				->select('data_pasien.tanggal_reg')
				->where('data_antrian.id_pasien', '=', $request->id_pasien)
				->first();
				$pasienBaru = $cekPasienBaru->tanggal_reg;
				if ($pasienBaru == $dateNow){
					$pendaftaran = new Transaksi;
					$pendaftaran->id_antrian = $request->id_antrian;
					$pendaftaran->transaksi = "Pendaftaran";
					$pendaftaran->jenis_transaksi = "pendaftaran";
					$pendaftaran->nominal = 25000;
					$pendaftaran->jenis_pembayaran = "cash";
					$pendaftaran->save();
				}*/
				
				if (!$transaksi->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $transaksi
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $transaksi
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		
		
		public function storeTransaksiTindakan(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				$transaksiTindakan = new Transaksi;
				$transaksiTindakan->id_antrian = $request->id_antrian;
				$transaksiTindakan->jenis_transaksi = $request->transaksi;
				$transaksiTindakan->transaksi = "Jasa Dokter dan Tindakan";
				$biaya = $request->biaya;
				$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
				$diskon = $request->diskon;
				$nominalDiskon = $biayaReplace * ($diskon / 100);
				$transaksiTindakan->diskon = $nominalDiskon;
				$finalDiskon = $biayaReplace - $nominalDiskon;
				$qty = $request->qty;
				$transaksiTindakan->qty = $qty;
				$grandTotal = $finalDiskon * $qty;
				$transaksiTindakan->nominal = $grandTotal;
				$transaksiTindakan->jenis_pembayaran = $request->jenis_pembayaran;
				
				$tindakanPasien = new TindakanPasien;
				$tindakanPasien->id_antrian = $request->id_antrian;
				$tindakanPasien->tindakan = $request->transaksi;
				$tindakanPasien->save();
				
				
				if (!$transaksiTindakan->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $transaksiTindakan
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $transaksiTindakan
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeTransaksiObat(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				$transaksiObat = new Transaksi;
				$transaksiObat->id_antrian = $request->id_antrian;
				$transaksiObat->transaksi = $request->transaksi;
				$transaksiObat->jenis_transaksi = "obat";
				$biaya = $request->biaya;
				$biayaReplace = preg_replace("/[^0-9]/", "", $biaya);
				$diskon = $request->diskon;
				$nominalDiskon = $biayaReplace * ($diskon / 100);
				$transaksiObat->diskon = $nominalDiskon;
				$finalDiskon = $biayaReplace - $nominalDiskon;
				$qty = $request->qty;
				$transaksiObat->qty = $qty;
				$grandTotal = $finalDiskon * $qty;
				$transaksiObat->nominal = $grandTotal;
				$transaksiObat->jenis_pembayaran = $request->jenis_pembayaran;
				
				$resepObat = new resepObat;
				$resepObat->id_antrian = $request->id_antrian;
				$resepObat->obat = $request->transaksi;
				$resepObat->aturan_pakai = $request->aturan_pakai;
				$resepObat->dosis = $request->dosis;
				$resepObat->save();
				
				
				if (!$transaksiObat->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $transaksiObat
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $transaksiObat
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeDataPerujuk(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				
				$dokterPerujuk = new dokterPerujuk;
				$dokterPerujuk->id_poli = 0;
				$dokterPerujuk->nama_dokter = $request->nama_dokter;
				$dokterPerujuk->save();
				
				
				if (!$dokterPerujuk->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $dokterPerujuk
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'dokterPerujuk' => $dokterPerujuk
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeTransaksiPenyakit(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				
				$penyakitPasien = new penyakitPasien;
				$penyakitPasien->id_antrian = $request->id_antrian;
				$penyakitPasien->penyakit = $request->penyakit;
				$penyakitPasien->save();
				
				
				if (!$penyakitPasien->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $penyakitPasien
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $penyakitPasien
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeMasterPenyakit(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				$transaksiPenyakit = new masterPenyakitPasien;
				$transaksiPenyakit->jenis_penyakit = $request->penyakit;
				
				$penyakitPasien = new penyakitPasien;
				$penyakitPasien->id_antrian = $request->id_antrian;
				$penyakitPasien->penyakit = $request->penyakit;
				$penyakitPasien->save();
				
				
				if (!$transaksiPenyakit->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "client_id" => "01631",
                "data" => $transaksiPenyakit
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $transaksiPenyakit
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeMasterObat(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				$masterObat = new masterObat;
				$masterObat->jenis_obat = $request->jenis_obat;
				$masterObat->biaya = $request->biaya;
				$masterObat->save();
				
				
				if (!$masterObat->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "data" => $masterObat,
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $masterObat
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeMasterTindakan(Request $request) {
			DB::begintransaction();
			try {
				//Data transaksi
				$masterTindakan = new masterTindakan;
				$masterTindakan->jenis_tindakan = $request->jenis_tindakan;
				$masterTindakan->biaya = $request->biaya;
				$masterTindakan->save();
				
				
				if (!$masterTindakan->save()) {
					DB::rollback();
					return [
                    'result' => FALSE,
                    'message' => 'Gagal menyimpan data transaksi'
					];
				}
				
				$postKirim = array(
                "data" => $masterTindakan,
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
                    'message' => 'Berhasil menyimpan data Transaksi ke database. Memuat ulang halaman...',
                    'transaksi' => $masterTindakan
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
                'result' => FALSE,
                'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function deleteTransaksi(Request $request) {
			DB::begintransaction();
			try {
				$delete = Transaksi::find($request->id_trx);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		
		
		public function deleteTransaksiPenyakit(Request $request) {
			DB::begintransaction();
			try {
				$delete = penyakitPasien::find($request->id_penyakit_pasien);
				if (!$delete->delete()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan delete transaksi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil delete transaksi. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function getDataTransaksiPenyakit(Request $request) {
			$dataTransaksiPenyakit = DB::table('penyakit_pasien')
			->select('penyakit','id_penyakit_pasien')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			if ($dataTransaksiPenyakit) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataTransaksiPenyakit,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataTransaksi(Request $request) {
			$dataTransaksi = DB::table('data_transaksi')
			->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_antrian.id_pasien','data_antrian.anamnesa','data_antrian.keluhan_awal','data_pasien.nama_pasien','data_pasien.tanggal_lahir','data_pasien.jenis_kelamin','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.alamat_sekarang','data_pasien.no_telp','data_pasien.email')
			->where('data_antrian.id_antrian', '=', $request->id_antrian)
			->get();
			$totalNominal = DB::table('data_transaksi')
			->where('id_antrian', '=', $request->id_antrian)
			->sum('nominal');
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($dataTransaksi) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataTransaksi,
				'pasien' =>  $dataPasien,
				'total' =>  $totalNominal,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataAnamnesa(Request $request) {
			$dataAnamnesa = DB::table('data_antrian')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			
			if ($dataAnamnesa) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataAnamnesa,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataTransaksiPasien(Request $request) {
			$antrian = DB::table('data_antrian')
			//->join('data_transaksi', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'data_antrian.id_jadwal', '=', 'data_antrian.id_jadwal')
			->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('jadwal_poli.id_jadwal','data_dokter.nama_dokter','data_antrian.anamnesa','data_antrian.id_pasien','data_antrian.id_antrian','data_antrian.tanggal_reg')
			->where('data_antrian.id_pasien', '=', $request->id_pasien)
			//->distinct()
			->groupBy('data_antrian.id_jadwal')
			->get();
			$child_id=[];
			foreach ($antrian as $key => $ch){
				$id_antrian = $ch->id_antrian;
				$anamnesa = $ch->anamnesa;
				//$dokter = $ch->nama_dokter;
				$dokter = DB::table('data_dokter')
				->join('jadwal_poli', 'jadwal_poli.id_dokter', '=', 'data_dokter.id_dokter')
				->join('data_antrian', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.id_antrian', '=', $id_antrian)
				->select('data_dokter.nama_dokter')
				->get();
				$tanggalTrx = $ch->tanggal_reg;
				//$tanggalTrx = Carbon::createFromFormat('d/m/Y', $ch->created_at)->format('Y-m-d');
				$newDate = date("D,d M Y", strtotime($tanggalTrx));
				$transaksi = DB::table('data_transaksi')
				->select('created_at','id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
				->where('id_antrian', '=', $id_antrian)
				->distinct()
				->get();
				$child_id[$key] =[
				'anamnesa'=>$anamnesa,
				'idAntrian'=>$id_antrian,
				'dokter'=>$dokter,
				'tanggal'=>$newDate,
				'transaksi'=>$transaksi,
				]; 
			}
			$dataPasien = DB::table('data_pasien')
			->select('data_pasien.nama_pasien','data_pasien.tanggal_lahir','data_pasien.jenis_kelamin','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.alamat_sekarang','data_pasien.no_telp','data_pasien.email')
			->where('id_pasien', '=', $request->id_pasien)
			->get();
			
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($antrian) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $child_id,
				'pasien' =>  $dataPasien,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		
		public function getDataTransaksiFront(Request $request) {
			$antrian = DB::table('data_antrian')
			->select('id_antrian')
			->where('id_antrian', '=', $request->id_antrian)
			->get();
			$child_id=[];
			foreach ($antrian as $key => $ch){
				$id_antrian = $ch->id_antrian;
				$theraphy = DB::table('data_transaksi')
				->where('id_antrian', '=', $id_antrian)
				->where('jenis_transaksi', '=', 'obat')
				//->whereIn('jenis_transaksi', ['jasa dokter', 'obat'])
				->sum('nominal');
				$transaksi = DB::table('data_transaksi')
				->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
				->where('id_antrian', '=', $id_antrian)
				->whereIn('jenis_transaksi', ['pendaftaran', 'jasa dokter', 'tindakan'])
				->get();
				$child_id[$key] =[
				'antrian'=>$id_antrian,
				'theraphy'=>$theraphy,
				'transaksi'=>$transaksi,
				]; 
			}
			$detailTheraphy = DB::table('data_transaksi')
				->select('id_trx','transaksi','qty','nominal','jenis_pembayaran','jenis_transaksi')
				->where('id_antrian', '=', $id_antrian)
				//->whereIn('jenis_transaksi', ['jasa dokter', 'tindakan'])
				->where('jenis_transaksi', '=', 'obat')
				->get();
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_antrian.no_antrian','data_antrian.anamnesa','data_antrian.keluhan_awal','data_pasien.nama_pasien','data_pasien.tanggal_lahir','data_pasien.jenis_kelamin','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.alamat_sekarang','data_pasien.no_telp','data_pasien.email')
			->where('data_antrian.id_antrian', '=', $request->id_antrian)
			->get();
			$totalNominal = DB::table('data_transaksi')
			->where('id_antrian', '=', $request->id_antrian)
			->sum('nominal');
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($antrian) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $child_id,
				'detail' =>  $detailTheraphy,
				'pasien' =>  $dataPasien,
				'total' =>  $totalNominal,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataTransaksiFrontLab(Request $request) {
			$antrian = DB::table('data_antrian_lab')
			->select('id_antrian_lab')
			->where('id_antrian_lab', '=', $request->id_antrian_lab)
			->get();
			$child_id=[];
			foreach ($antrian as $key => $ch){
				$id_antrian = $ch->id_antrian_lab;
				$transaksi = DB::table('data_transaksi_lab')
				->select('id_trx_lab','transaksi','qty','nominal','jenis_pembayaran')
				->where('id_antrian_lab', '=', $id_antrian)
				->get();
				$child_id[$key] =[
				'antrian'=>$id_antrian,
				'transaksi'=>$transaksi,
				]; 
			}
			$detailTransaksi = DB::table('data_transaksi_lab')
				->select('id_trx_lab','transaksi','qty','nominal','jenis_pembayaran')
				->where('id_antrian_lab', '=', $id_antrian)
				->get();
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->where('data_antrian_lab.id_antrian_lab', '=', $request->id_antrian_lab)
			->get();
			$totalNominal = DB::table('data_transaksi_lab')
			->where('id_antrian_lab', '=', $request->id_antrian_lab)
			->sum('nominal');
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($antrian) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $child_id,
				'detail' =>  $detailTransaksi,
				'pasien' =>  $dataPasien,
				'total' =>  $totalNominal,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function getDataTransaksiLab(Request $request) {
			$dataTransaksi = DB::table('data_transaksi_lab')
			->select('id_trx_lab','transaksi','nominal','jenis_pembayaran')
			->where('id_antrian_lab', '=', $request->id_antrian_lab)
			->get();
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian_lab', 'data_pasien.id_pasien', '=', 'data_antrian_lab.id_pasien')
			->select('data_pasien.nama_pasien','data_pasien.tanggal_lahir','data_pasien.jenis_kelamin','data_pasien.pekerjaan','data_pasien.nomer_rm','data_pasien.alamat_sekarang','data_pasien.no_telp','data_pasien.email')
			->where('data_antrian_lab.id_antrian_lab', '=', $request->id_antrian_lab)
			->get();
			$totalNominal = DB::table('data_transaksi_lab')
			->where('id_antrian_lab', '=', $request->id_antrian_lab)
			->sum('nominal');
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($dataTransaksi) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $dataTransaksi,
				'pasien' =>  $dataPasien,
				'total' =>  $totalNominal,
				'tanggal' =>  $tanggal
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		
		
		/*public function getNomorRm() {
			$lastRM = DB::table('data_pasien')
			->select(DB::raw('MAX(nomer_rm) as nomerRM'))
			->get();
			//$newRM = $lastRM+1 ;
			//$generateAntrian = $countAntrian+1 ;
			//$nomerRM = str_pad($newRM,3,'0',STR_PAD_LEFT);
			if ($lastRM) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'lastRM' =>  $lastRM,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}*/
		
		public function getNomorRm() {
			/*$countPasien = DB::table('data_pasien')
				->select('id_pasien')
				->count();*/
			$countPasien = DB::table('data_pasien')
			->max('nomer_rm');
			$generateRM = $countPasien+1 ;
			$nomerRM = str_pad($generateRM,3,'0',STR_PAD_LEFT);
			if ($nomerRM) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'nomerRM' =>  $nomerRM,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		
		public function getRekamMedis (Request $request){
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian','data_antrian.anamnesa')
			->where('data_pasien.id_pasien', '=', $request->id_pasien)
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$pasien_name = $ch->nama_pasien;
				$pasien_id = $ch->id_pasien;
				$id_antrian = $ch->id_antrian;
				$anamnesa = $ch->anamnesa;
				$antrian = DB::table('data_antrian')
				->select('data_antrian.id_antrian')
				->where('data_antrian.id_antrian', '=', $id_antrian)
				->get();
				$dokter = DB::table('data_dokter')
				->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
				->join('data_antrian', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->select('data_dokter.nama_dokter')
				->where('data_antrian.id_antrian', '=', $id_antrian)
				->get();
				$childs_id=[];
				foreach ($antrian as $keys => $chs){
					$antrian_id = $chs->id_antrian;
					$penyakit = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('penyakit_pasien', 'data_antrian.id_antrian', '=', 'penyakit_pasien.id_antrian')
					->select('penyakit_pasien.penyakit')
					->where('penyakit_pasien.id_antrian', '=', $antrian_id)
					->get();
					$tindakan = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('tindakan_pasien', 'data_antrian.id_antrian', '=', 'tindakan_pasien.id_antrian')
					->select('tindakan_pasien.tindakan')
					->where('tindakan_pasien.id_antrian', '=', $antrian_id)
					->get();
					$obat = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('resep_obat', 'data_antrian.id_antrian', '=', 'resep_obat.id_antrian')
					->select('resep_obat.obat')
					->where('resep_obat.id_antrian', '=', $antrian_id)
					->get();
					$childs_id[$keys] =[
					'penyakit'=>$penyakit,
					'tindakan'=>$tindakan,
					'obat'=>$obat,
					]; 
				}
				$child_id[$key] =[
				'antrian'=>$id_antrian,
				'anamnesa'=>$anamnesa,
				'dokter'=>$dokter,
				'rm'=>$childs_id,
				];
			}
			
			
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'pasien'=>$pasien_name,
				'data' => $child_id
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getTransaksiDokter (Request $request){
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian')
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('data_antrian.no_antrian','ASC')   
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$pasien_id = $ch->nama_pasien;
				$antrian_id = $ch->id_antrian;
				$transaksi = Antrian::find($ch->id_antrian);
				$transaksi = DB::table('data_transaksi')
				->select('transaksi','nominal','jenis_pembayaran','jenis_transaksi','id_trx','status')
				//->where('transaksi', '=', 'Jasa Dokter dan Tindakan')
				->where('id_antrian', '=', $antrian_id)
				->get();
				$child_id[$key] =[
				'pasien'=>$pasien_id,
				'data'=>$transaksi,
				]; 
			}
			$dataDokter = DB::table('data_dokter')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter','jadwal_poli.id_jadwal','jadwal_poli.jam_buka','jadwal_poli.jam_tutup')
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			//->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->get();
			$totalNominal = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->sum('data_transaksi.nominal');
			$totalCash = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.jenis_pembayaran', '=', "cash")
			->sum('data_transaksi.nominal');
			$totalDebit = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.jenis_pembayaran', '=', "debit")
			->sum('data_transaksi.nominal');
			$jumlahPasienTotal =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			//->where('data_antrian.status', '=', 4)
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			->count();
			/*$jumlahPasienBaru =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			->where('data_pasien.tanggal_reg', '=', DB::raw('curdate()'))
			->count();*/
			$jumlahPasienBaru = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			//->sum('data_transaksi.nominal');
			->count();
			$jumlahRpPasienBaru = $jumlahPasienBaru * 25000;
			$Pendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			->sum('data_transaksi.nominal');
			$JasaDanKonsultasi = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
			->sum('data_transaksi.nominal');
			$pendapatanDokter = $JasaDanKonsultasi*(70/100);
			$dataKartu = DB::table('stock_kartu')
			->sum('jumlah_kartu');
			$kartuTerpakai = DB::table('m_rfid')
			->where('status', '=', "aktif" )
			->count();
			$stockKartu = $dataKartu - $kartuTerpakai;
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'dataDokter' =>  $dataDokter ,
				'tanggal' =>  $tanggal,
				'total' =>  $totalNominal,
				'totalCash' =>  $totalCash,
				'totalDebit' =>  $totalDebit,
				'jumlahPasienTotal' =>  $jumlahPasienTotal,
				'jumlahPasienBaru' =>  $jumlahPasienBaru,
				'stockKartu' =>  $stockKartu,
				'jumlahRpPasienBaru' =>  $jumlahRpPasienBaru,
				'Pendaftaran' =>  $Pendaftaran,
				'JasaDanKonsultasi' =>  $JasaDanKonsultasi,
				'pendapatanDokter' =>  $pendapatanDokter,
				
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getTransaksiDokterKirim (Request $request){
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian')
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('data_antrian.no_antrian','ASC')   
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$pasien_id = $ch->nama_pasien;
				$antrian_id = $ch->id_antrian;
				$transaksi = Antrian::find($ch->id_antrian);
				$transaksi = DB::table('data_transaksi')
				->select('transaksi','jenis_transaksi','nominal','jenis_pembayaran')
				->where('transaksi', '=', 'Jasa Dokter dan Tindakan')
				->where('id_antrian', '=', $antrian_id)
				->get();
				$child_id[$key] =[
				'pasien'=>$pasien_id,
				'data'=>$transaksi,
				]; 
			}
			$dataDokter = DB::table('data_dokter')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter','jadwal_poli.id_jadwal','jadwal_poli.jam_buka','jadwal_poli.jam_tutup')
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			//->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->get();
			$totalNominal = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->sum('data_transaksi.nominal');
			$totalCash = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.jenis_pembayaran', '=', "cash")
			->sum('data_transaksi.nominal');
			$totalDebit = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.jenis_pembayaran', '=', "debit")
			->sum('data_transaksi.nominal');
			$jumlahPasienTotal =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			//->where('data_antrian.status', '=', 4)
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			->count();
			$jumlahPasienBaru =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			->where('data_pasien.tanggal_reg', '=', DB::raw('curdate()'))
			->count();
			$jumlahRpPasienBaru = $jumlahPasienBaru * 25000;
			$Pendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			->sum('data_transaksi.nominal');
			$JasaDanKonsultasi = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			//->where('data_antrian.status', '=', 4)
			->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
			->sum('data_transaksi.nominal');
			$pendapatanDokter = $JasaDanKonsultasi*(70/100);
			$dataKartu = DB::table('stock_kartu')
			->sum('jumlah_kartu');
			$kartuTerpakai = DB::table('m_rfid')
			->where('status', '=', "aktif" )
			->count();
			$stockKartu = $dataKartu - $kartuTerpakai;
			$tanggal = Carbon::now()->format('D,d M Y');
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'dataDokter' =>  $dataDokter ,
				'tanggal' =>  $tanggal,
				'total' =>  $totalNominal,
				'totalCash' =>  $totalCash,
				'totalDebit' =>  $totalDebit,
				'jumlahPasienTotal' =>  $jumlahPasienTotal,
				'jumlahPasienBaru' =>  $jumlahPasienBaru,
				'stockKartu' =>  $stockKartu,
				'jumlahRpPasienBaru' =>  $jumlahRpPasienBaru,
				'Pendaftaran' =>  $Pendaftaran,
				'JasaDanKonsultasi' =>  $JasaDanKonsultasi,
				'pendapatanDokter' =>  $pendapatanDokter,
				
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getTransaksiAll (Request $request){
			$sDate = $request->tanggalStart;
			$eDate = $request->tanggalEnd;
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('jadwal_poli.tanggal','data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian')
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			//->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('jadwal_poli.tanggal','ASC')   
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$tanggal = $ch->tanggal;
				$pasien_id = $ch->nama_pasien;
				$antrian_id = $ch->id_antrian;
				$transaksi = Antrian::find($ch->id_antrian);
				$transaksi = DB::table('data_transaksi')
				->select('jenis_transaksi','transaksi','nominal','jenis_pembayaran','id_trx')
				->where('id_antrian', '=', $antrian_id)
				->get();
				$child_id[$key] =[
				'tanggal'=>$tanggal,
				'pasien'=>$pasien_id,
				'idAntrian'=>$antrian_id,
				'data'=>$transaksi,
				]; 
			}
			$dataDokter = DB::table('data_dokter')
			//->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter')
			->where('data_dokter.id_dokter', '=', $request->id_dokter)
			->get();
			$jumlahPasienTotal =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->count();
			$CountPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			//->sum('data_transaksi.nominal');
			->count();
			$sumPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			->sum('data_transaksi.nominal');
			$sumKonsul = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
			->sum('data_transaksi.nominal');
			$tigaPuluhPersen = $sumKonsul*(30/100);
			$JasaDanKonsultasiBersih = $sumKonsul-$tigaPuluhPersen;
			$totalNominal = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->sum('data_transaksi.nominal');
			$totalCash = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.jenis_pembayaran', '=', "cash")
			->sum('data_transaksi.nominal');
			$totalDebit = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.jenis_pembayaran', '=', "debit")
			->sum('data_transaksi.nominal');
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'dataDokter' =>  $dataDokter ,
				'sDate' =>  $sDate ,
				'eDate' =>  $eDate ,
				'jumlahPasienTotal' =>  $jumlahPasienTotal ,
				'jumlahPasienBaru' =>  $CountPendaftaran,
				'jumlahRpPasienBaru' =>  $sumPendaftaran,
				'JasaDanKonsultasi' =>  $sumKonsul,
				'JasaDanKonsultasiBersih' => $JasaDanKonsultasiBersih,
				'total' =>  $totalNominal,
				'totalCash' =>  $totalCash,
				'totalDebit' =>  $totalDebit,
				
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getTransaksiAllkhusus (Request $request){
			$sDate = $request->tanggalStart;
			$eDate = $request->tanggalEnd;
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('jadwal_poli.tanggal','data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian')
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			//->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('jadwal_poli.tanggal','ASC')   
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$tanggal = $ch->tanggal;
				$pasien_id = $ch->nama_pasien;
				$antrian_id = $ch->id_antrian;
				$transaksi = Antrian::find($ch->id_antrian);
				$transaksi = DB::table('data_transaksi')
				->select('transaksi','nominal','jenis_pembayaran')
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->where('id_antrian', '=', $antrian_id)
				->get();
				$child_id[$key] =[
				'tanggal'=>$tanggal,
				'pasien'=>$pasien_id,
				'idAntrian'=>$antrian_id,
				'data'=>$transaksi,
				]; 
			}
			$dataDokter = DB::table('data_dokter')
			//->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter')
			->where('data_dokter.id_dokter', '=', $request->id_dokter)
			->get();
			$jumlahPasienTotal =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->count();
			$CountPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			//->sum('data_transaksi.nominal');
			->count();
			$sumPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			->sum('data_transaksi.nominal');
			$sumKonsul = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
			->sum('data_transaksi.nominal');
			$tigaPuluhPersen = $sumKonsul*(30/100);
			$JasaDanKonsultasiBersih = $sumKonsul-$tigaPuluhPersen;
			$totalNominal = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->sum('data_transaksi.nominal');
			$totalCash = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.jenis_pembayaran', '=', "cash")
			->sum('data_transaksi.nominal');
			$totalDebit = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			//->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->where('jadwal_poli.tanggal', '=', $request->tanggal)
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_transaksi.jenis_pembayaran', '=', "debit")
			->sum('data_transaksi.nominal');
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'dataDokter' =>  $dataDokter ,
				'sDate' =>  $sDate ,
				'eDate' =>  $eDate ,
				'jumlahPasienTotal' =>  $jumlahPasienTotal ,
				'jumlahPasienBaru' =>  $CountPendaftaran,
				'jumlahRpPasienBaru' =>  $sumPendaftaran,
				'JasaDanKonsultasi' =>  $sumKonsul,
				'JasaDanKonsultasiBersih' => $JasaDanKonsultasiBersih,
				'total' =>  $totalNominal,
				'totalCash' =>  $totalCash,
				'totalDebit' =>  $totalDebit,
				
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getTransaksiAlll (Request $request){
			$sDate = $request->tanggalStart;
			$eDate = $request->tanggalEnd;
			//$sDate = date("Y-m-d",strtotime($request->tanggalStart));
            //$eDate = date("Y-m-d",strtotime($request->tanggalEnd));
			//$monthNow = date("m",strtotime($request->monthNow));
			//$yearNow = date("Y",strtotime($request->yearNow));
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('jadwal_poli.tanggal','data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian')
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			//->where('jadwal_poli.tanggal', '=', $request->tanggal)
			//->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('jadwal_poli.tanggal','ASC')   
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$tanggal = $ch->tanggal;
				$pasien_id = $ch->nama_pasien;
				$antrian_id = $ch->id_antrian;
				$transaksi = Antrian::find($ch->id_antrian);
				$transaksi = DB::table('data_transaksi')
				->select('jenis_transaksi','transaksi','nominal','jenis_pembayaran')
				->where('id_antrian', '=', $antrian_id)
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->get();
				$child_id[$key] =[
				'tanggal'=>$tanggal,
				'pasien'=>$pasien_id,
				'idAntrian'=>$antrian_id,
				'data'=>$transaksi,
				]; 
			}
			$dataDokter = DB::table('data_dokter')
			//->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter')
			->where('data_dokter.id_dokter', '=', $request->id_dokter)
			->get();
			$jumlahPasienTotal =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->count();
			$CountPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			//->sum('data_transaksi.nominal');
			->count();
			$sumPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			->sum('data_transaksi.nominal');
			$sumKonsul = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
			->sum('data_transaksi.nominal');
			$tigaPuluhPersen = $sumKonsul*(30/100);
			$JasaDanKonsultasiBersih = $sumKonsul-$tigaPuluhPersen;
			$totalNominal = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->sum('data_transaksi.nominal');
			$totalCash = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->where('data_transaksi.jenis_pembayaran', '=', "cash")
			->sum('data_transaksi.nominal');
			$totalDebit = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->where('data_transaksi.jenis_pembayaran', '=', "debit")
			->sum('data_transaksi.nominal');
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'dataDokter' =>  $dataDokter ,
				'sDate' =>  $sDate ,
				'eDate' =>  $eDate ,
				'jumlahPasienTotal' =>  $jumlahPasienTotal ,
				'jumlahPasienBaru' =>  $CountPendaftaran,
				'jumlahRpPasienBaru' =>  $sumPendaftaran,
				'JasaDanKonsultasi' =>  $sumKonsul,
				'JasaDanKonsultasiBersih' => $JasaDanKonsultasiBersih,
				'total' =>  $totalNominal,
				'totalCash' =>  $totalCash,
				'totalDebit' =>  $totalDebit,
				
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getTransaksiDokterPerMonth (Request $request){
			//$sDate = $request->tanggalStart;
			//$eDate = $request->tanggalEnd;
			//$sDate = date("Y-m-d",strtotime($request->tanggalStart));
            //$eDate = date("Y-m-d",strtotime($request->tanggalEnd));
            $bulan = Carbon::now()->month;
            $tahun = Carbon::now()->year;
			$monthNow = $request->monthNow;
			$yearNow = $request->yearNow;
			//$yearNow = $request->$yearNow;
			//$monthNow = $request->$monthNow;
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('jadwal_poli.tanggal','data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian')
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			//->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			//->where('jadwal_poli.tanggal', '=', $request->tanggal)
			//->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->orderBy('jadwal_poli.tanggal','ASC')   
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$tanggal = $ch->tanggal;
				$pasien_id = $ch->nama_pasien;
				$antrian_id = $ch->id_antrian;
				$transaksi = Antrian::find($ch->id_antrian);
				$transaksi = DB::table('data_transaksi')
				->select('jenis_transaksi','transaksi','nominal','jenis_pembayaran')
				->where('id_antrian', '=', $antrian_id)
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->get();
				$child_id[$key] =[
				'tanggal'=>$tanggal,
				'pasien'=>$pasien_id,
				'idAntrian'=>$antrian_id,
				'data'=>$transaksi,
				]; 
			}
			$dataDokter = DB::table('data_dokter')
			//->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter')
			->where('data_dokter.id_dokter', '=', $request->id_dokter)
			->get();
			$jumlahPasienTotal =  DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			->count();
			$CountPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			//->sum('data_transaksi.nominal');
			->count();
			$sumPendaftaran = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			->where('data_transaksi.transaksi', '=', "Pendaftaran")
			->sum('data_transaksi.nominal');
			$sumKonsul = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
			->sum('data_transaksi.nominal');
			$tigaPuluhPersen = $sumKonsul*(30/100);
			$JasaDanKonsultasiBersih = $sumKonsul-$tigaPuluhPersen;
			$totalNominal = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			->sum('data_transaksi.nominal');
			$totalCash = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			->where('data_transaksi.jenis_pembayaran', '=', "cash")
			->sum('data_transaksi.nominal');
			$totalDebit = DB::table('data_transaksi')
			->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->where('data_antrian.status', '=', 4)
			->where('jadwal_poli.id_dokter', '=', $request->id_dokter)
			->whereMonth('jadwal_poli.tanggal', '=', $monthNow)
			->whereYear('jadwal_poli.tanggal', '=', $yearNow)
			->where('data_transaksi.jenis_pembayaran', '=', "debit")
			->sum('data_transaksi.nominal');
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'dataDokter' =>  $dataDokter ,
				'jumlahPasienTotal' =>  $jumlahPasienTotal ,
				'jumlahPasienBaru' =>  $CountPendaftaran,
				'jumlahRpPasienBaru' =>  $sumPendaftaran,
				'JasaDanKonsultasi' =>  $sumKonsul,
				'JasaDanKonsultasiBersih' => $JasaDanKonsultasiBersih,
				'total' =>  $totalNominal,
			 	'totalCash' =>  $totalCash,
				'totalDebit' =>  $totalDebit,
				'bulan' =>  $bulan,
				'tahun' =>  $tahun,
				
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getJamPraktek(Request $request) {
			$getJamPraktek = DB::table('jadwal_poli')
			->select('id_jadwal','jam_buka','jam_tutup')
			->where('tanggal', '=', $request->tanggal)
			->where('id_dokter', '=', $request->id_dokter)
			->get();
			if ($getJamPraktek) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $getJamPraktek
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
			public function rekapJadwalPerMonth(Request $request) {
			$dokter = DB::table('data_dokter')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter','data_dokter.id_dokter')
			->groupBy('data_dokter.id_dokter')
			->get();
			$child_id=[];
			foreach ($dokter as $key => $ch){
				$namaDokter = $ch->nama_dokter;
				$idDokter = $ch->id_dokter;
				$jumlahPasienTotal =  DB::table('data_pasien')
				->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
				->count();
				$sumKonsul = DB::table('data_transaksi')
				->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->sum('data_transaksi.nominal');
				$tigaPuluhPersen = $sumKonsul*(30/100);
				$JasaDanKonsultasiBersih = $sumKonsul-$tigaPuluhPersen;
				$child_id[$key] =[
				'dokter'=>$namaDokter,
				'totalKonsul'=>$sumKonsul,
				'jumlahPasien' => $jumlahPasienTotal,
				'pendapatanDokter' => $JasaDanKonsultasiBersih,
				'pendapatanKlinik' => $tigaPuluhPersen,
				]; 
			}
			if ($getJamPraktek) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $getJamPraktek
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function resumeTransaksi(Request $request) {
			$sDate = $request->tanggalStart;
			$eDate = $request->tanggalEnd;
			$dokter = DB::table('data_dokter')
			->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->select('data_dokter.nama_dokter','data_dokter.id_dokter')
			->groupBy('data_dokter.id_dokter')
			->get();
			$child_id=[];
			foreach ($dokter as $key => $ch){
				$namaDokter = $ch->nama_dokter;
				$idDokter = $ch->id_dokter;
				$jumlahPasienTotal =  DB::table('data_pasien')
				->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
				->count();
				$sumKonsul = DB::table('data_transaksi')
				->join('data_antrian', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->where('data_antrian.status', '=', 4)
				->where('jadwal_poli.id_dokter', '=', $idDokter)
				->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
				->where('data_transaksi.transaksi', '=', "Jasa Dokter dan Tindakan")
				->sum('data_transaksi.nominal');
				$tigaPuluhPersen = $sumKonsul*(30/100);
				$JasaDanKonsultasiBersih = $sumKonsul-$tigaPuluhPersen;
				$child_id[$key] =[
				'dokter'=>$namaDokter,
				'totalKonsul'=>$sumKonsul,
				'jumlahPasien' => $jumlahPasienTotal,
				'pendapatanDokter' => $JasaDanKonsultasiBersih,
				'pendapatanKlinik' => $tigaPuluhPersen,
				]; 
			}
			if ($dokter) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'sDate' =>  $sDate ,
				'eDate' =>  $eDate ,
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function getStockKartu(Request $request) {
			$sDate = $request->tanggalStart;
			$eDate = $request->tanggalEnd;
			$stockKartu = DB::table('stock_kartu')
			//->whereBetween('tanggal_order', [$sDate, $eDate])
			->get();
			$child_id=[];
			foreach ($stockKartu as $key => $ch){
				$idStock = $ch->id_stock;
				$jumlahKartu = $ch->jumlah_kartu;
				$tglOrder = $ch->tanggal_order;
				$countStock =  DB::table('stock_kartu')
				->join('m_rfid', 'stock_kartu.id_stock', '=', 'm_rfid.id_stock')
				//->where('m_rfid.status', '=', "aktif")
				->where('m_rfid.id_stock', '=', $idStock)
				//->whereBetween('stock_kartu.tanggal_order', [$sDate, $eDate])
				->count();
				$kartuTerpakai = DB::table('m_rfid')
				->where('m_rfid.id_stock', '=', $idStock)
				->where('m_rfid.status', '=', "aktif")
				->count();
				$sisaKartu = DB::table('m_rfid')
				->where('m_rfid.id_stock', '=', $idStock)
				->where('m_rfid.status', '=', "available")
				->count();
				$pendapatanKlinik = $kartuTerpakai*10000;
				$child_id[$key] =[
				'id'=>$idStock,
				'stock'=>$countStock,
				'tglOrder'=>$tglOrder,
				'kartuTerpakai' => $kartuTerpakai,
				'sisaKartu' => $sisaKartu,
				'pendapatanKlinik' => $pendapatanKlinik,
				]; 
			}
			if ($stockKartu) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' => $child_id,
				'sDate' =>  $sDate ,
				'eDate' =>  $eDate ,
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		
		public function counting(Request $request) {
			$registered = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->count();
			$servings = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_antrian.no_antrian')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 3 )
			->get();
			$served = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
			->select('data_pasien.nama_pasien','data_antrian.no_antrian','data_antrian.status')
			->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
			->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
			->where('data_antrian.status', '=', 4 )
			->count();
			$dataKartu = DB::table('stock_kartu')
			->sum('jumlah_kartu');
			$kartuTerpakai = DB::table('m_rfid')
			->where('status', '=', "aktif" )
			->count();
			$stockKartu = $dataKartu - $kartuTerpakai;
			
			if ($registered) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'data' =>  $registered,
				'servings' =>  $servings,
				'served' =>  $served,
				'stockKartu' =>  $stockKartu
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		public function updateAnamnesa(Request $request) {
			DB::begintransaction();
			try {
				$anamnesa = Antrian::find($request->id_antrian);
				$anamnesa->anamnesa = $request->anamnesa;
				if (!$anamnesa->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data anamnesa'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'anamnesa' => $anamnesa->anamnesa,
				'message' => 'Berhasil memperbarui data anamnesa ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		
		
		public function updateStatusJadwalPoli(Request $request) {
			DB::begintransaction();
			try {
				$getStatus = DB::table('jadwal_poli')
				->where('status', '=', "isActive")
				->max('id_jadwal');

				$getIdJadwal = $getStatus ;
				
				$deactivated = jadwalDokter::find($getIdJadwal);
				$deactivated->status = "deactivated";
				if (!$deactivated->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}

				$status = jadwalDokter::find($request->id_jadwal);
				$status->status = "isActive";
				if (!$status->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'status' => $status->status,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function updateStatusPembayaran(Request $request) {
			DB::begintransaction();
			try {
				$status = Transaksi::find($request->id_trx);
				$status->jenis_pembayaran = $request->jenis_pembayaran;
				if (!$status->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data status'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'status' => $status->status,
				'message' => 'Berhasil memperbarui data status ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function updateKonfirmasi(Request $request) {
			DB::begintransaction();
			try {
				$konfirmasi = Antrian::find($request->id_antrian);
				$konfirmasi->confirmed = $request->confirmed;
				if (!$konfirmasi->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data konfirmasi'
					];
				}
				
				DB::commit();
				return [
				'result' => TRUE,
				'message' => 'Berhasil memperbaruis data konfirmasi ke database. Memuat ulang halaman...',
				];
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeRegister(Request $request) {
			DB::begintransaction();
			try {
				
				/*$countAntrian = DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->select('id_antrian')
				->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
				->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
				->count();*/
				$countAntrian = DB::table('data_antrian')
				->where('id_jadwal', '=', $request->id_jadwal)
				->max('no_antrian');
				$generateAntrian = $countAntrian+1 ;
				$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
				//Data Registrasi
				$registrasi = new Registrasi;
				//$registrasi->id_pasien = Registrasi::getID();
				//$registrasi->rf_id = Carbon::now()->format('d M Y');
				$registrasi->rf_id = $request->rf_id;
				$registrasi->nomer_rm = $request->nomer_rm;
				$registrasi->nama_pasien = $request->nama_pasien;
				$registrasi->tanggal_lahir = $request->tanggal_lahir;
				$registrasi->jenis_kelamin = $request->jenis_kelamin;
				$registrasi->kartu_identitas = $request->kartu_identitas;
				$registrasi->nomer_identitas = $request->nomer_identitas;
				$registrasi->alamat_ktp = $request->alamat_ktp;
				$registrasi->alamat_sekarang = $request->alamat_sekarang;
				$registrasi->no_telp = $request->no_telp;
				$registrasi->email = $request->email;
				$registrasi->pekerjaan = $request->pekerjaan;
				
				if (!$registrasi->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Registrasi'
					];
				}
				
				$id = DB::table('data_pasien')->max('id_pasien');
				
				$rfid = Rfid::find($request->rf_id);
				$rfid->status = "aktif";
				$rfid->id_pasien = $id;
				$rfid->tanggal_register = Carbon::now();
				if (!$rfid->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Registrasi'
					];
				}
				
				//Data Antrian
				$antrian = new Antrian;
				$antrian->id_jadwal = $request->id_jadwal;
				$antrian->id_pasien = $id;
				$antrian->keluhan_awal = $request->keluhan_awal;
				$antrian->no_antrian = $nomerAntrian;
				$tanggalTrx = $antrian->tanggal_reg;
				//$tanggalTrx = Carbon::createFromFormat('d/m/Y', $ch->created_at)->format('Y-m-d');
				$newDate = date("D", strtotime($tanggalTrx));
				$antrian->dayname = $newDate;
				
				if (!$antrian->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Antrian'
					];
				}
				
				$id = DB::table('data_antrian')->where('id_jadwal', '=', $request->id_jadwal)->max('id_antrian');
				
				$postKirim = array(
				"data" => $registrasi
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
					'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
					'antrian' => $nomerAntrian,
					'id' => $id
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeRegisterLab(Request $request) {
			DB::begintransaction();
			try {
				
				$countAntrian = DB::table('data_antrian_lab')
				->join('jadwal_lab', 'jadwal_lab.id_jadwal_lab', '=', 'data_antrian_lab.id_jadwal_lab')
				->select('id_antrian_lab')
				->where('jadwal_lab.tanggal', '=', DB::raw('curdate()'))
				->where('jadwal_lab.id_jadwal_lab', '=', $request->id_jadwal_lab)
				->count();
				$generateAntrian = $countAntrian+1 ;
				$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
				//Data Registrasi
				$registrasi = new Registrasi;
				//$registrasi->id_pasien = Registrasi::getID();
				//$registrasi->rf_id = Carbon::now()->format('d M Y');
				$registrasi->status_register = "laboratorium";
				$registrasi->nama_pasien = $request->nama_pasien;
				$registrasi->tanggal_lahir = $request->tanggal_lahir;
				$registrasi->jenis_kelamin = $request->jenis_kelamin;
				$registrasi->kartu_identitas = $request->kartu_identitas;
				$registrasi->nomer_identitas = $request->nomer_identitas;
				$registrasi->alamat_ktp = $request->alamat_ktp;
				$registrasi->alamat_sekarang = $request->alamat_sekarang;
				$registrasi->no_telp = $request->no_telp;
				$registrasi->email = $request->email;
				$registrasi->pekerjaan = $request->pekerjaan;
				//$registrasi->perujuk = $request->getDataDokter_div;
				
				if (!$registrasi->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Registrasi'
					];
				}
				//Data Antrian
				$antrian = new antrianLab;
				$antrian->id_jadwal_lab = $request->id_jadwal_lab;
				$antrian->id_pasien = $id;
				$antrian->no_antrian = $nomerAntrian;
				$antrian->perujuk = $request->getDataDokter_div;
				
				if (!$antrian->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Antrian'
					];
				}
				
				$postKirim = array(
				"data" => $registrasi
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
					'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
					'antrian' => $nomerAntrian
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeRegisterRad(Request $request) {
			DB::begintransaction();
			try {
				
				$countAntrian = DB::table('data_antrian_radiologi')
				->join('jadwal_radiologi', 'jadwal_radiologi.id_jadwal_radiologi', '=', 'data_antrian_radiologi.id_jadwal_radiologi')
				->select('id_antrian_radiologi')
				->where('jadwal_radiologi.tanggal', '=', DB::raw('curdate()'))
				->where('jadwal_radiologi.id_jadwal_radiologi', '=', $request->id_jadwal_radiologi)
				->count();
				$generateAntrian = $countAntrian+1 ;
				$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
				//Data Registrasi
				$registrasi = new Registrasi;
				$registrasi->id_pasien = Registrasi::getID();
				//$registrasi->rf_id = Carbon::now()->format('d M Y');
				$registrasi->status_register = "radiologi";
				$registrasi->nama_pasien = $request->nama_pasien;
				$registrasi->tanggal_lahir = $request->tanggal_lahir;
				$registrasi->jenis_kelamin = $request->jenis_kelamin;
				$registrasi->kartu_identitas = $request->kartu_identitas;
				$registrasi->nomer_identitas = $request->nomer_identitas;
				$registrasi->alamat_ktp = $request->alamat_ktp;
				$registrasi->alamat_sekarang = $request->alamat_sekarang;
				$registrasi->no_telp = $request->no_telp;
				$registrasi->email = $request->email;
				$registrasi->pekerjaan = $request->pekerjaan;
				//$registrasi->perujuk = $request->getDataDokter_div;
				
				if (!$registrasi->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Registrasi'
					];
				}
				//Data Antrian
				$antrian = new antrianRad;
				$antrian->id_jadwal_radiologi = $request->id_jadwal_radiologi;
				$antrian->id_pasien = $registrasi->id_pasien;
				$antrian->no_antrian = $nomerAntrian;
				$antrian->perujuk = $request->getDataDokter_div;
				
				if (!$antrian->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Antrian'
					];
				}
				
				$postKirim = array(
				"data" => $registrasi
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
					'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
					'antrian' => $nomerAntrian
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		
		
		
		public function getJadwalRad() {
			$getJadwal = DB::table('jadwal_radiologi')
				->select('id_jadwal_radiologi')
				->where('jadwal_radiologi.tanggal', '=', DB::raw('curdate()'))
				->get();
			
			if ($getJadwal) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'data' =>  $getJadwal,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function storeFormPoli(Request $request) {
			DB::begintransaction();
			try {
				//$currDate = currdate();
				/*$countAntrian = DB::table('data_antrian')
				->join('jadwal_poli', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->select('id_antrian')
				->where('jadwal_poli.tanggal', '=', DB::raw('curdate()'))
				->where('jadwal_poli.id_jadwal', '=', $request->id_jadwal)
				->count();*/
				$countAntrian = DB::table('data_antrian')
				->where('id_jadwal', '=', $request->id_jadwal)
				->max('no_antrian');
				$generateAntrian = $countAntrian+1 ;
				$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
				//Data Antrian
				$antrian = new Antrian;
				$antrian->id_jadwal = $request->id_jadwal;
				$antrian->id_pasien = $request->id_pasien;
				$antrian->keluhan_awal = $request->anamnesa;
				$antrian->no_antrian = $nomerAntrian;
				$tanggalTrx = $antrian->tanggal_reg;
				//$tanggalTrx = Carbon::createFromFormat('d/m/Y', $ch->created_at)->format('Y-m-d');
				$newDate = date("D", strtotime($tanggalTrx));
				$antrian->dayname = $newDate;
				
				
				if (!$antrian->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Antrian'
					];
				}
				
				$id = DB::table('data_antrian')->where('id_jadwal', '=', $request->id_jadwal)->max('id_antrian');
				
				$postKirim = array(
				"client_id" => "01631",
				"data" => $antrian
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
					'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
					'antrian' => $nomerAntrian,
					'id' => $id
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function storeFormRad(Request $request) {
			DB::begintransaction();
			try {
				//$currDate = currdate();
				$countAntrian = DB::table('data_antrian_radiologi')
				->join('jadwal_radiologi', 'jadwal_radiologi.id_jadwal_radiologi', '=', 'data_antrian_radiologi.id_jadwal_radiologi')
				->select('id_antrian_radiologi')
				->where('jadwal_radiologi.tanggal', '=', DB::raw('curdate()'))
				->where('jadwal_radiologi.id_jadwal_radiologi', '=', $request->id_jadwal_radiologi)
				->count();
				$generateAntrian = $countAntrian+1 ;
				$nomerAntrian = str_pad($generateAntrian,3,'0',STR_PAD_LEFT);
				//Data Antrian
				$antrian = new antrianRad;
				$antrian->id_jadwal_radiologi = $request->id_jadwal_radiologi;
				$antrian->id_pasien = $request->id_pasien;
				$antrian->no_antrian = $nomerAntrian;
				$antrian->perujuk = $request->getDataDokter2_div;
				
				if (!$antrian->save()) {
					DB::rollback();
					return [
					'result' => FALSE,
					'message' => 'Gagal menyimpan data Antrian'
					];
				}
				
				$postKirim = array(
				"client_id" => "01631",
				"data" => $antrian
				);
				if ($postKirim) {
					DB::commit();
					return [
					'result' => TRUE,
					'message' => 'Berhasil menyimpan data Registrasi ke database. Memuat ulang halaman...',
					'antrian' => $nomerAntrian
					];
					} else {
					return [
					'message' => 'Gagal Mengambil Data',
					'status' => 0
					];
				}
				} catch (Exception $ex) {
				DB::rollback();
				return [
				'result' => FALSE,
				'message' => $e->getMessage() . ' on line ' . $e->getLine()
				];
			}
		}
		
		public function getLastAntrian(Request $request) {
			$getAntrianPoli = DB::table('data_antrian')
			->where('id_jadwal', '=', $request->id_jadwal)
			->max('no_antrian');
			$dataPasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_pasien.nama_pasien')
			->where('data_antrian.id_jadwal', '=', $request->id_jadwal)
			->get();
			$tanggal = Carbon::now()->format('D,d M Y');
			
			if ($getAntrianPoli) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
                'antrianPoli' =>  $getAntrianPoli,
				'pasienPoli' =>  $dataPasien,
				'tanggal' =>  $tanggal,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function selectDataPasien(Request $request){

		  $search = $request->search;

		  if($search == ''){
			 $dataPasien = dataPasien::orderby('nama_pasien','asc')->select('id_pasien','nama_pasien','nomer_rm','alamat_ktp','satusehat_number')->limit(5)->get();
		  }else{
			 $dataPasien = dataPasien::orderby('nama_pasien','asc')
			 ->select('id_pasien','nama_pasien','nomer_rm','alamat_ktp','satusehat_number')
			 ->where('nomer_rm', 'like', '%' .$search . '%')
			 ->orWhere('nama_pasien', 'like', '%' .$search . '%')
			 ->orWhere('rf_id', 'like', '%' .$search . '%')
			 ->limit(5)
			 ->get();
		  }

		  $response = array();
		  foreach($dataPasien as $pasien){
			 $response[] = array(
				  $gabungan = $pasien['nama_pasien']." - ".$pasien['nomer_rm']." - ".$pasien['alamat_ktp'],
				  
				  "id"=>$pasien->id_pasien,
				  "ss"=>$pasien->satusehat_number,
				  "text"=>$gabungan
			 );
		  }

		  return response()->json($response);
	    }
		
		public function selectDataPenyakit(Request $request){

		  $search = $request->search;

		  if($search == ''){
			 $dataPenyakit = masterPenyakitPasien::orderby('jenis_penyakit','asc')->select('id_penyakit','jenis_penyakit','kategori','sub_kategori')->limit(5)->get();
		  }else{
			 $dataPenyakit = masterPenyakitPasien::orderby('jenis_penyakit','asc')
			 ->select('id_penyakit','jenis_penyakit','kategori','sub_kategori')
			 ->where('jenis_penyakit', 'like', '%' .$search . '%')
			 ->orWhere('kategori', 'like', '%' .$search . '%')
			 ->orWhere('sub_kategori', 'like', '%' .$search . '%')
			 ->limit(5)
			 ->get();
		  }

		  $response = array();
		  foreach($dataPenyakit as $penyakit){
			 $response[] = array(
				  $gabungan = $penyakit['jenis_penyakit']." - ".$penyakit['kategori'].".".$penyakit['sub_kategori'],
				  
				  "id"=>$penyakit->id_penyakit,
				  "text"=>$gabungan
			 );
		  }

		  return response()->json($response);
	    }
	    
	    public function getDurasiPraktek(Request $request) {
			$sDate = $request->tanggalStart;
			$eDate = $request->tanggalEnd;
			$jadwalPoli = DB::table('jadwal_poli')
			->join('data_dokter', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
			->whereBetween('jadwal_poli.tanggal', [$sDate, $eDate])
			->orderBy('jadwal_poli.id_jadwal','ASC')   
			->get();
			$child_id=[];
			foreach ($jadwalPoli as $key => $ch){
				$idJadwal = $ch->id_jadwal;
				$dokter = $ch->nama_dokter;
				$tanggal = $ch->tanggal;
				$jamBuka = $ch->jam_buka;
				/*$jamTerakhir = DB::table('jadwal_poli')
				->join('data_antrian', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->join('data_transaksi', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->where('data_antrian.id_jadwal', '>', $idJadwal)
				->select('data_transaksi.created_at')
				->orderBy('data_transaksi.id_trx','DESC')   
				->limit(1)
				->get();*/
				$jamTerakhir = DB::table('jadwal_poli')
				->join('data_antrian', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->join('data_transaksi', 'data_antrian.id_antrian', '=', 'data_transaksi.id_antrian')
				->where('data_antrian.id_jadwal', '=', $idJadwal)
				->select('data_transaksi.created_at')
				->orderBy('data_transaksi.id_trx','DESC')   
				->limit(1)
				->get();
				//$last = $jamTerakhir->created_at;
				$child_id[$key] =[
				'dokter'=>$dokter,
				'tanggal'=>$tanggal,
				'jamBuka'=>$jamBuka,
				'jamTerakhir'=>$jamTerakhir,
				]; 
			}
			
			
			if ($jadwalPoli) {
				return [
                'message' => 'Berhasil Mengambil Data',
                'status' => 1,
				'jadwal' => $idJadwal,
				'data' =>  $child_id,
				];
				} else {
				return [
                'message' => 'Gagal Mengambil Data',
                'status' => 0
				];
			}
		}
		
		public function laporanAdmin (Request $request){
			$pasien = DB::table('data_pasien')
			->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
			->select('data_pasien.nama_pasien','data_pasien.id_pasien','data_antrian.id_antrian','data_antrian.anamnesa')
			->where('data_pasien.id_pasien', '=', $request->id_pasien)
			->get();
			$child_id=[];
			foreach ($pasien as $key => $ch){
				$pasien_name = $ch->nama_pasien;
				$pasien_id = $ch->id_pasien;
				$id_antrian = $ch->id_antrian;
				$anamnesa = $ch->anamnesa;
				$antrian = DB::table('data_antrian')
				->select('data_antrian.id_antrian')
				->where('data_antrian.id_antrian', '=', $id_antrian)
				->get();
				$dokter = DB::table('data_dokter')
				->join('jadwal_poli', 'data_dokter.id_dokter', '=', 'jadwal_poli.id_dokter')
				->join('data_antrian', 'jadwal_poli.id_jadwal', '=', 'data_antrian.id_jadwal')
				->select('data_dokter.nama_dokter')
				->where('data_antrian.id_antrian', '=', $id_antrian)
				->get();
				$childs_id=[];
				foreach ($antrian as $keys => $chs){
					$antrian_id = $chs->id_antrian;
					$penyakit = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('penyakit_pasien', 'data_antrian.id_antrian', '=', 'penyakit_pasien.id_antrian')
					->select('penyakit_pasien.penyakit')
					->where('penyakit_pasien.id_antrian', '=', $antrian_id)
					->get();
					$tindakan = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('tindakan_pasien', 'data_antrian.id_antrian', '=', 'tindakan_pasien.id_antrian')
					->select('tindakan_pasien.tindakan')
					->where('tindakan_pasien.id_antrian', '=', $antrian_id)
					->get();
					$obat = DB::table('data_pasien')
					->join('data_antrian', 'data_pasien.id_pasien', '=', 'data_antrian.id_pasien')
					->join('resep_obat', 'data_antrian.id_antrian', '=', 'resep_obat.id_antrian')
					->select('resep_obat.obat')
					->where('resep_obat.id_antrian', '=', $antrian_id)
					->get();
					$childs_id[$keys] =[
					'penyakit'=>$penyakit,
					'tindakan'=>$tindakan,
					'obat'=>$obat,
					]; 
				}
				$child_id[$key] =[
				'antrian'=>$id_antrian,
				'anamnesa'=>$anamnesa,
				'dokter'=>$dokter,
				'rm'=>$childs_id,
				];
			}
			
			
			if ($pasien) {
				return [
				'message' => 'Berhasil Mengambil Data',
				'status' => 1,
				'pasien'=>$pasien_name,
				'data' => $child_id
				];
				} else {
				return [
				'message' => 'Gagal Mengambil Data',
				'status' => 0
				];
			}
		}
		
		/////////////////
		
		/*public function getDatatablesPasien(Request $request){
		   $columns = array( 
	                            0 =>'id_pasien', 
	                            1 =>'nama_pasien',
								2 =>'nomer_rm',
								3 =>'alamat_ktp',
	                            4=> 'no_telp',
	                            5=> 'id_pasien',
	                        );

		$querycount = dataPasien::select('count(id_pasien) as jumlah')->count();
		$datacount = $querycount->fetch_array();
        $totalData = $datacount['jumlah'];
        $totalFiltered = $totalData; 
        $limit = $_POST['length'];
        $start = $_POST['start'];
        $order = $columns[$_POST['order']['0']['column']];
        $dir = $_POST['order']['0']['dir'];
            
        if(empty($_POST['search']['value']))
        {            
        	$query = DB::select("SELECT id_pasien,nama_pasien,nomer_rm,alamat_ktp,no_telp FROM data_pasien order by $order $dir LIMIT $limit 												OFFSET $start");
        }
        else {
            $search = $_POST['search']['value']; 
            $query = DB::select("SELECT id_pasien,nama_pasien,nomer_rm,alamat_ktp,no_telp FROM data_pasien WHERE nama_pasien LIKE '%$search%' 
            															or no_telp LIKE '%$search%' 
            															order by $order $dir 
            															LIMIT $limit 
            															OFFSET $start");


           $querycount = DB::select("SELECT count(id_pasien) as jumlah FROM data_pasien WHERE nama_pasien LIKE '%$search%' 
       																						or no_telp LIKE '%$search%'");
		   $datacount = $querycount->fetch_array();
           $totalFiltered = $datacount['jumlah'];
        }

        $data = array();
        if(!empty($query))
        {
            $no = $start + 1;
            while ($r = $query->fetch_array())
            {
                $nestedData['no'] = $no;
                $nestedData['nama_pasien'] = $r['nama_pasien'];
				$nestedData['nomer_rm'] = $r['nomer_rm'];
				$nestedData['alamat_ktp'] = $r['alamat_ktp'];
                $nestedData['no_telp'] = $r['no_telp'];
               // $nestedData['aksi'] = "<a href='#' class='btn-warning btn-sm'>Ubah</a>&nbsp; <a href='#' class='btn-danger btn-sm'>Hapus</a>";
                $data[] = $nestedData;
                $no++;
            }
        }
          
        $json_data = array(
                    "draw"            => intval($_POST['draw']),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        echo json_encode($json_data); 
	}*/
}
